using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameData.Expression
{
    internal static class ExpressionParser
    {
        /// <summary>
        /// ݂̎dlł͎̉Z͈ȂB
        /// </summary>
        /// <param name="st"></param>
        /// <returns></returns>
        public static double ReduceDoubleTerm(StringStream st)
        {
            TokenReader.SkipWhiteSpace(st);
            return TokenReader.ReadDouble(st);
        }

        /// <summary>
        /// PAtA񎮂̂A񎮂舵Bł%%̒gPRINTSn
        /// </summary>
        /// <param name="st"></param>
        /// <returns></returns>
        public static IOperandTerm ReduceStringTerm(StringStream st)
        {
            TokenReader.SkipWhiteSpace(st);
            if (st.EOS)
                return new SingleTerm("");
            IOperandTerm term = reduceTerm(st, true);
            if (term.GetOperandType() != typeof(string))
                throw new CodeEE("̌ʂł͂܂");
            return term;
        }

        public static IOperandTerm ReduceVariableArgument(StringStream st)
        {
            TermStack stack = new TermStack();
            TokenReader.SkipWhiteSpace(st);
            TokenType type = TokenReader.GetNextTokenType(st);
            if ((st.EOS) || (type == TokenType.EndOfLine) || (type == TokenType.EndOfExpression))
                throw new CodeEE("ʎq܂");
            else if (type == TokenType.Numeric)
            {
                stack.Add(TokenReader.ReadInt64(st));
            }
            else if (type == TokenType.Identifer)
            {
                string idStr = TokenReader.ReadSingleIdentifer(st);
                VariableIdentifier id = VariableIdentifier.GetVariableId(idStr);
                if (id == null)
                {
                    if (ConstantData.isDefined(idStr))
                        stack.Add(idStr);
                    else
                        throw new CodeEE("\"" + idStr + "\"͉߂łȂʎqł");
                }
                else
                    stack.Add(VariableParser.ReduceVariable(id, null, null));
            }
            else if (type == TokenType.StringToken)
            {
                string str = TokenReader.ReadStringWithDoubleQuotation(st);
                if (!ConstantData.isDefined(str))
                    throw new CodeEE("\"" + str + "\"͒`ĂȂʎqł");
                stack.Add(str);
            }
            else if (st.Current == '(')
            {
                st.ShiftNext();
                stack.Add(reduceTerm(st, false));
                if (st.Current != ')')
                    throw new CodeEE("ʂĂ܂");
                st.ShiftNext();
            }
            else if (type == TokenType.Operator)
            {
                throw new CodeEE("ϐ̈̓ǂݎ蒆̂ɗ\ȂZq𔭌܂");
            }
            else
                throw new ExeEE("\Ȃʎq");
            return stack.ReduceAll();
        }

        public static IOperandTerm ReduceIntegerTerm(StringStream st)
        {
            IOperandTerm term = reduceTerm(st, false);
            if (term.GetOperandType() != typeof(Int64))
                throw new CodeEE("̌ʂlł͂܂");
            return term;
        }


        private static IOperandTerm reduceTerm(StringStream st, bool endWithPercent)
        {
            TermStack stack = new TermStack();
            int termCount = 0;
            while (true)
            {
                TokenReader.SkipWhiteSpace(st);
                TokenType type = TokenReader.GetNextTokenType(st);
                if ((st.EOS) || (type == TokenType.EndOfLine)
                    || (type == TokenType.EndOfExpression))
                    break;
                if ((endWithPercent) && (st.Current == '%'))
                    break;
                termCount++;
                if (type == TokenType.Numeric)
                {
                    stack.Add(TokenReader.ReadInt64(st));
                    continue;
                }
                if (type == TokenType.Identifer)
                {
                    stack.Add(VariableParser.ReduceVariable(st));
                    continue;
                }
                if (type == TokenType.Operator)
                {
                    OperatorCode op = TokenReader.ReadOperator(st);
                    stack.Add(op);
                    continue;
                }
                if (type == TokenType.StringToken)
                {
                    stack.Add(TokenReader.ReadStringWithDoubleQuotation(st));
                    continue;
                }
                if (st.Current == '(')
                {
                    st.ShiftNext();
                    stack.Add(reduceTerm(st, endWithPercent));
                    if (st.Current != ')')
                        throw new CodeEE("ʂĂ܂");
                    st.ShiftNext();
                    continue;
                }
                throw new ExeEE("\Ȃʎq");
            }
            return stack.ReduceAll();
        }




        /// <summary>
        /// pNX
        /// </summary>
        private class TermStack
        {
            /// <summary>
            /// ɗׂ̂̎ށB
            /// (Ou)PZql҂Ȃ0A񍀉Zq҂Ȃ1Al҂Ȃ2B
            /// </summary>
            int state = 0;
            Stack<Object> stack = new Stack<Object>();
            public void Add(OperatorCode op)
            {
                if (state == 2)
                    throw new CodeEE("ُł");
                if (state == 0)
                {
                    if (!OperatorManager.IsUnary(op))
                        throw new CodeEE("ُł");
                    stack.Push(op);
                    state = 2;
                    return;
                }
                if (state == 1)
                {
                    if (!OperatorManager.IsBinary(op))
                        throw new CodeEE("ُł");
                    int priority = OperatorManager.GetPriority(op);
                    //ǑvZ̗DxȂҌB
                    while (lastPriority() >= priority)
                    {
                        this.reduceLastThree();
                    }
                    stack.Push(op);
                    state = 0;
                    return;
                }
                throw new CodeEE("ُł");
            }
            public void Add(Int64 i) { Add(new SingleTerm(i)); }
            public void Add(string s) { Add(new SingleTerm(s)); }
            public void Add(IOperandTerm term)
            {
                stack.Push(term);
                if (state == 1)
                    throw new CodeEE("ُł");
                if (state == 2)
                    reduceUnary();
                state = 1;
                return;
            }

            private void reduceUnary()
            {
                if (stack.Count < 2)
                    throw new ExeEE("sȎ̌Ăяo");
                IOperandTerm operand = (IOperandTerm)stack.Pop();
                OperatorCode op = (OperatorCode)stack.Pop();
                Type retType = OperatorMethod.GetReturnType(operand.GetOperandType(), op);
                UnaryMethod method = OperatorMethod.GetUnaryMethod(op);
                if ((retType == typeof(void)) || (method == null))
                {
                    string errMes = "";
                    if (operand.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (operand.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    errMes += "ɒPZq\'" + OperatorManager.ToOperatorString(op) + "\'͓Kpł܂";
                    throw new CodeEE(errMes);
                }
                if (operand is SingleTerm)
                {
                    stack.Push(method(operand, GetSingle));
                }
                else
                {
                    stack.Push(new UnaryExpressionTerm(operand, op, method));
                }
            }

            private int lastPriority()
            {
                if (stack.Count < 3)
                    return -1;
                object temp = (object)stack.Pop();
                OperatorCode opCode = (OperatorCode)stack.Peek();
                int priority = OperatorManager.GetPriority(opCode);
                stack.Push(temp);
                return priority;
            }

            public IOperandTerm ReduceAll()
            {
                if (stack.Count == 0)
                    return new SingleTerm(0);
                if (state != 1)
                    throw new CodeEE("ُł");
                while (stack.Count > 1)
                {
                    reduceLastThree();
                }
                return (IOperandTerm)stack.Pop();

            }



            private void reduceLastThree()
            {
                if (stack.Count < 2)
                    throw new ExeEE("sȎ̌Ăяo");
                IOperandTerm right = (IOperandTerm)stack.Pop();//ォꂽقE
                OperatorCode op = (OperatorCode)stack.Pop();
                IOperandTerm left = (IOperandTerm)stack.Pop();
                if (!OperatorManager.IsBinary(op))
                    throw new ExeEE("ُȎ󂯓Ă܂Ă");
                Type retType = OperatorMethod.GetReturnType(right.GetOperandType(), left.GetOperandType(), op);

                BinaryMethod method = OperatorMethod.GetBinaryMethod(op);
                if ((retType == typeof(void)) || (method == null))
                {
                    string errMes = "";
                    if (left.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (left.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    if (right.GetOperandType() == typeof(Int64))
                        errMes += "l^";
                    else if (right.GetOperandType() == typeof(string))
                        errMes += "^";
                    else
                        errMes += "s^";
                    errMes += "Zɓ񍀉Zq\'" + OperatorManager.ToOperatorString(op) + "\'͓Kpł܂";
                    throw new CodeEE(errMes);
                }
                if ((right is SingleTerm) && (left is SingleTerm))
                {
					stack.Push(method(left, right, GetSingle));
                }
                else
                {
                    stack.Push(new BinaryExpressionTerm(left, right, op, method));
                }

			}
			SingleTerm GetSingle(IOperandTerm oprand)
			{
				return (SingleTerm)oprand;
			}
        }

    }
}