#include "TestResult.h"

void TestResult_init(TestResultRef self,TestListnerRef listner)
{
	self->isa = (TestListnerImplementRef)&TestResultImplement;
	self->numberOfTestsRun = 0;
	self->numberOfFailures = 0;
	self->listener = listner;
}

void TestResult_startTest(TestResultRef self,TestRef test)
{
	self->numberOfTestsRun++;
	if (self->listener) {
		TestListner_startTest(self->listener, test);
	}
}

void TestResult_endTest(TestResultRef self,TestRef test)
{
	if (self->listener) {
		TestListner_endTest(self->listener, test);
	}
}

void TestResult_addFailure(TestResultRef self,TestRef test,char *msg,int line,char *file)
{
	self->numberOfFailures++;
	if (self->listener) {
		TestListner_addFailure(self->listener, test, msg, line, file);
	}
}

const TestListnerImplement TestResultImplement = {
	(TestListnerImplStartTest)TestResult_startTest,
	(TestListnerImplEndTest)TestResult_endTest,
	(TestListnerImplAddFailure)TestResult_addFailure,
};
