#include "TestCase.h"
#include "TestResult.h"

TestResultRef _result;
TestCaseRef _self;

char* TestCase_name(TestCaseRef self)
{
	return self->name;
}

void TestCase_run(TestCaseRef self,TestResultRef result)
{
	if (result) {
		result->isa->startTest(result, (TestRef)self);
	}
	if (self->setUp) {
		self->setUp();
	}
	if (self->runTest) {
		TestResultRef wr =_result;	/*push*/
		TestCaseRef ws = _self;	/*push*/
		_result = result;
		_self = self;
		_self->runTest();
		_result = wr;	/*pop*/
		_self = ws;	/*pop*/
	}
	if (self->tearDown) {
		self->tearDown();
	}
	if (result) {
		result->isa->endTest(result, (TestRef)self);
	}
}

int TestCase_countTestCases(TestCaseRef self)
{
	return 1;
}

const TestImplement TestCaseImplement = {
	(TestImplName)TestCase_name,
	(TestImplRun)TestCase_run,
	(TestImplCountTestCases)TestCase_countTestCases,
};

void addFailure(const char* msg, long line, const char* file)
{
	if (_result)
		_result->isa->addFailure(_result, (TestRef)_self, (char*)msg, line, (char*)file);
}
