#ifndef	__ASSERTIMPL_H__
#define	__ASSERTIMPL_H__

void addFailure(const char* msg, long line, const char* file);	/*TestCase.c*/

void assertEqualsImplInt(int expected,int actual, long line, const char* file);
void assertEqualsImplCStr(const char* expected,const char* actual, long line, const char* file);

#define TEST_ASSERT_EQUAL_STRING(expected,actual)\
	if (expected && actual && (stdimpl_strcmp(expected,actual)==0)) {} else {assertEqualsImplCStr(expected,actual,__LINE__,__FILE__);return;}

#define TEST_ASSERT_EQUAL_INT(expected,actual)\
	if (expected == actual) {} else {assertEqualsImplInt(expected,actual,__LINE__,__FILE__);return;}

#define TEST_ASSERT_NULL(pointer)\
	TEST_ASSERT_MESSAGE(pointer == NULL,#pointer " was not null.")

#define TEST_ASSERT_NOT_NULL(pointer)\
	TEST_ASSERT_MESSAGE(pointer != NULL,#pointer " was null.")

#define TEST_ASSERT_MESSAGE(x, msg)\
	if (x) {} else {TEST_FAIL(msg);}

#define TEST_ASSERT(x)\
	if (x) {} else {TEST_FAIL(#x);}

#define TEST_FAIL(msg)\
	if (0) {} else {addFailure(msg,__LINE__,__FILE__);return;}

#endif/*__ASSERTIMPL_H__*/
