package generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;

public class SchemaBindingGen {

	private String template = "";
	private String schema = "";
	private String dest = "";

	public SchemaBindingGen() {
	}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		SchemaBindingGen self = new SchemaBindingGen();
		try {
			if (args.length < 3) {
				System.err.println("-s=schema -d=dest -t=template");
				return ;
			}
			for (int i = 0; i < args.length; i++) {
				String[] param = args[i].split("=");
				if (param[0].equals("-s")) {
					self.schema = param[1];
				}
				else if (param[0].equals("-d")) {
					self.dest = param[1];
				}
				else if (param[0].equals("-t")) {
					self.template = param[1];
				}
			}
			self.generate();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void generate() {
		File tempFile = new File(template);
		try {
			String tempStr = "";
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(tempFile), "utf-8"));
			String s;
			while ((s = br.readLine())!=null) {
				tempStr += s;
				tempStr += "\n";
				}
			br.close();
			tempStr = tempStr.replaceAll("\\{schema\\}", schema);
			FileOutputStream fos = new FileOutputStream(dest);
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos , "UTF-8"));
			bw.write(tempStr.toString());
			bw.close();
			fos.close();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
}
