/**
 * 
 */
package elazyrest.ext.hibernate;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;



public class HibernateUtil {

    private static final SessionFactory sessionFactory;
	private static Log log = LogFactory.getLog(HibernateUtil.class);

//    private static HibernateUtil _instance = new HibernateUtil();
    private HibernateUtil() {}
//    public static HibernateUtil getInstance() {return _instance;} 

    static {
        try {
            // SessionFactory 
            //sessionFactory = new Configuration().configure().buildSessionFactory();
        	sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
        } catch (HibernateException ex) {
        	log.error("Configuration problem: " + ex.getMessage());
            throw new RuntimeException("Configuration problem: " + ex.getMessage(), ex);
        } catch (Exception ex) {
        	log.error("Configuration problem: " + ex.getMessage());
        	throw new RuntimeException("Configuration problem: " + ex.getMessage(), ex);
        }
    }

    
    private static final ThreadLocal<Session> session = new ThreadLocal<Session>();

    private static final ThreadLocal<List<Transaction>> transactionList = new ThreadLocal<List<Transaction>>();

    public static Session currentSession() throws HibernateException {
        Session s = (Session) session.get();
        // ̃Xbhɂ܂Ȃ΁AVZbVI[v
        if (s == null) {
            s = sessionFactory.openSession();
            session.set(s);
            log.debug("open hibernate session");
        }
        if (!s.isOpen()) {
        	s = sessionFactory.openSession();
        	session.set(s);
        	log.debug("open hibernate session");
        }
        return s;
    }

    public static Transaction beginTransaction() throws HibernateException {
        Session s = currentSession();

        List<Transaction> transactions = transactionList.get();
        if (transactions == null) {
        	transactions = new ArrayList<Transaction>();
        }
        Transaction trans = s.beginTransaction();
		transactions.add(trans);
		transactionList.set(transactions);
		log.debug("begin transaction");
        return trans;
    }

    public static Transaction lastTransaction() throws HibernateException {
    	List<Transaction> transactions = transactionList.get();
    	if (transactions == null) {
    		return null;
    	}
        return transactions.get(transactions.size() - 1);
    }

    public static void rollback() throws HibernateException {
    	List<Transaction> transactions = transactionList.get();
    	if (transactions != null) {
			for (Transaction trans : transactions) {
				if (trans.isActive() && !trans.wasCommitted() && !trans.wasRolledBack()) {
					trans.rollback();
					log.debug("transaction rollback");
				}
			}
			transactionList.set(null);
			//transactionList.remove();
    	}
    }

    public static void closeSession() throws HibernateException {
        try {
        	rollback();
        }
        catch (Exception e) {
        	log.error(e.getMessage(), e);
        }
        Session s = (Session) session.get();
        if (s != null) {
        	try {
        		if (s.isOpen()) {
        			s.close();
        			log.debug("close session");
        		}
        	} catch (Exception e) {
        		log.error(e.getMessage(), e);
        	}

        }
        session.set(null);
    }
}