/*
 * Decompiled with CFR 0.152.
 */
package generator;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;
import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;

public class ResourceGen {
    private StringBuffer resourceXML = null;
    private static String lineSep = System.getProperty("line.separator");
    private MessageResourceBundle paramResource;

    public static void main(String[] args) {
        String packageName = "";
        String srcRoot = "src/main/resources/";
        ResourceGen self = new ResourceGen();
        try {
            self.generate(packageName, srcRoot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate(String packageName, String srcRoot) {
        try {
            this.paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle((String)"resources/param_resource"));
        }
        catch (Exception e) {
            this.paramResource = null;
        }
        this.resourceXML = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSep);
        this.resourceXML.append("<RESOURCE>" + lineSep);
        try {
            URL serviceRoot = this.getClass().getClassLoader().getResource(packageName.replace('.', '/'));
            if (serviceRoot != null) {
                File dir = new File(serviceRoot.getPath());
                this.generate(dir, packageName);
            }
        }
        finally {
            try {
                this.resourceXML.append("</RESOURCE>");
                File resourceFile = new File(String.valueOf(srcRoot) + "param_resource.xml");
                if (!resourceFile.exists()) {
                    resourceFile.createNewFile();
                }
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(resourceFile)));
                printWriter.write(this.resourceXML.toString());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void generate(File file, String parentPackage) {
        String filename = file.getName();
        if (file.isDirectory()) {
            File[] flist = file.listFiles();
            String packname = null;
            if (file.getName().equals("classes") || parentPackage != null && parentPackage.endsWith(file.getName())) {
                packname = parentPackage;
            } else {
                String string = packname = parentPackage.length() > 0 ? String.valueOf(parentPackage) + "." + file.getName() : file.getName();
            }
            if (flist != null && flist.length > 0) {
                File[] fileArray = flist;
                int n = 0;
                int n2 = fileArray.length;
                while (n < n2) {
                    File childFile = fileArray[n];
                    this.generate(childFile, packname);
                    ++n;
                }
            }
        }
        if (!file.getName().endsWith(".class")) {
            return;
        }
        String clname = null;
        clname = parentPackage != null && parentPackage.length() > 0 ? String.valueOf(parentPackage) + "." + filename.substring(0, filename.lastIndexOf(46)) : filename.substring(0, filename.lastIndexOf(46));
        this.generateForm(clname.replace('/', '.'));
    }

    private void generateForm(String clName) {
        try {
            Method[] methods;
            Class<?> cl = Class.forName(clName);
            String clFileName = cl.getName().substring(cl.getName().lastIndexOf(46) + 1);
            if (!cl.isAnnotationPresent(SimpleXml.class)) {
                return;
            }
            Method[] methodArray = methods = cl.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method targetMethod = methodArray[n];
                if (targetMethod.isAnnotationPresent(RestMethod.class)) {
                    Annotation[][] paramAnnotation = targetMethod.getParameterAnnotations();
                    int i = 0;
                    while (i < paramAnnotation.length) {
                        if (i == 0) {
                            this.resourceXML.append(String.valueOf(lineSep) + "<!-- " + clFileName + "." + targetMethod.getName() + "-->" + lineSep);
                        }
                        int j = 0;
                        while (j < paramAnnotation[i].length) {
                            if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                                String description;
                                String key;
                                RestParam restParam = (RestParam)paramAnnotation[i][j];
                                String keyDescription = key = restParam.name();
                                if (this.paramResource != null && (description = this.paramResource.getString(String.valueOf(clFileName) + "." + targetMethod.getName() + "." + key)) != null && description.length() > 0) {
                                    keyDescription = description;
                                }
                                this.resourceXML.append("<MSG id=\"" + clFileName + "." + targetMethod.getName() + "." + key + "\">" + keyDescription + "</MSG>" + lineSep);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                ++n;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

