/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.aspect;

import elazyrest.core.aspect.AspectBase;
import elazyrest.core.util.AppContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AspectChain {
    private List<AspectBase> adviceList = new ArrayList<AspectBase>();
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    int nextIndex = 0;
    private Method mainMethod = null;
    private Object mainInstance = null;
    private Object[] requestParams = null;
    private Object response = null;

    public Method getMainMethod() {
        return this.mainMethod;
    }

    public Object getMainInstance() {
        return this.mainInstance;
    }

    public Object getResponse() {
        return this.response;
    }

    protected void doAdvice() throws IOException {
        int currentIndex = this.nextIndex++;
        AppContext appContext = AppContext.getContext();
        if (this.adviceList.size() > currentIndex) {
            AspectBase advice = this.adviceList.get(currentIndex);
            advice.doAdvice(appContext.getRequest(), appContext.getResponse(), this, this.annotationList.get(currentIndex));
        } else {
            try {
                Object result = this.mainMethod.invoke(this.mainInstance, this.requestParams);
                if (result != null) {
                    this.response = result;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }

    public Object invoke() throws IOException {
        this.doAdvice();
        return this.response;
    }

    public void addAdvice(AspectBase advice, Annotation paramAnnotation) {
        if (!this.adviceList.contains(advice)) {
            this.adviceList.add(advice);
            this.annotationList.add(paramAnnotation);
        }
    }

    public void setMainMethod(Method mainMethod, Object mainIntance, Object[] params) {
        this.mainInstance = mainIntance;
        this.mainMethod = mainMethod;
        this.requestParams = params;
    }
}

