/*
 * Created on 2003/06/25
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.struts.action.ActionForm;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.action.PluginSubmitForm;
import org.j69.eewiki.wiki.Wiki;

/**
 * @author sally
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PluginComment extends WikiPlugin {

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#execute(java.lang.String, java.lang.String[], javax.servlet.http.HttpServletRequest)
	 */
	public String execute(
		String pageData,
		String[] optinos) {

		//ページID
		String pid = super.getPid();

		//コンテキストパス
		String submitPath = super.getContextPath() + "/PluginSubmit.do";
		//メッセージ
		MessageResources msg = super.getMessageResources();
		
		String comHTML = "<br>\n";
		comHTML = comHTML + "<form name=\"comment\" method=\"POST\" action=\"" + submitPath + "\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"pid\" value=\"" + pid + "\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"plugin\" value=\"Comment\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"rowid\" value=\"" + super.getRowid() + "\">\n";
		comHTML = comHTML + msg.getMessage(super.getLocale(), "caption.name","") + ":<input type=\"text\" name=\"options\" size=\"15\" maxlength=\"64\">\n";
		comHTML = comHTML + "<input type=\"text\" name=\"options\" size=\"80\" maxlength=\"256\">\n";
		comHTML = comHTML + "<input type=\"submit\" name=\"comment\" value=\""+ msg.getMessage(super.getLocale(), "caption.comment","") +  "\">\n";
		comHTML = comHTML + "</form>";
		return comHTML;
	}

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#submit(org.j69.eewiki.wiki.Wiki, org.apache.struts.action.ActionForm)
	 */
	public Wiki submit(Wiki wiki, ActionForm form) {

		Perl5Util perl = new Perl5Util();

		PluginSubmitForm psForm = (PluginSubmitForm)form;
		//ページ内でコマンドが置かれている行
		int rowid = psForm.getRowid();

		//名前--64文字まで
		String name = psForm.getOptions()[0];
		if (name.length() > 64) 
			name = name.substring(0, 63);

		//メッセージ--256文字まで
		String msg = psForm.getOptions()[1];
		if (msg.length() > 256) 
			msg = msg.substring(0, 255);

		//連続した改行は1つにしてしまう
		msg = perl.substitute("s/\\r\\n/\n/g", msg);
		msg = perl.substitute("s/\\n+/\n/g", msg);

		Calendar rightNow = Calendar.getInstance();
		String timestump = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(rightNow.getTime());
		try {
			//ページデータの取得
			String pageData = wiki.getPageContent() + "\n";
			StringBuffer buffer = new StringBuffer();
			String[] datas = pageData.split("\n");

			if (datas.length > rowid) {
				for (int i = 0; i < datas.length; i++) {
					buffer.append(datas[i] + "\n");
					if ((rowid-1) == i) {
						setComment(name, msg, timestump, buffer);
					}
				}
			}
			else {
				buffer.append(pageData);
				setComment(name, msg, timestump, buffer);
			}
			wiki.setPageContent(buffer.toString(), true, null);
			wiki.setCachePage(buffer.toString());
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return wiki;
	}

	/**
	 * コメントコンテンツのセット
	 * @param name
	 * @param msg
	 * @param timestump
	 * @param buffer
	 */
	private void setComment(String name, String msg, String timestump, StringBuffer buffer) {
		if (!name.equals("") && !msg.equals("")) {
			buffer.append("-" + msg + " -- " + name + " #Size(1:" + timestump + ")\n");
		}
	}
}
