/*
 * Created on 2004/03/20
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.struts.action.ActionForm;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.action.PluginSubmitForm;
import org.j69.eewiki.wiki.Wiki;

/**
 * @author J.r0ck
 *
 * BBS風コメントプラグイン
 * 2004.03.20
 * 
 */
public class PluginBbs extends WikiPlugin {

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#execute(java.lang.String, java.lang.String[], javax.servlet.http.HttpServletRequest)
	 */
	public String execute(
		String pageData,
		String[] optinos) {

		String pid = super.getPid();
		
		//コンテキストパス
		String submitPath = super.getContextPath() + "/PluginSubmit.do";
		//メッセージ
		MessageResources msg = super.getMessageResources();
		
		String comHTML = "<br>\n";
		comHTML = comHTML + "<SCRIPT language=\"JavaScript\">\n";
		comHTML = comHTML + "function LENGTH_COM() {\n";
		comHTML = comHTML + "    if(bbs.comment.value.length > 2000) {\n";
		comHTML = comHTML + "        bbs.comment.value=bbs.comment.value.substring(0, 1999);\n";
		comHTML = comHTML + "    }\n";
		comHTML = comHTML + "}\n";
		comHTML = comHTML + "</SCRIPT>\n";
		
		comHTML = comHTML + "<form id=\"bbs\" name=\"bbs\" method=\"POST\" action=\"" + submitPath + "\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"pid\" value=\"" + pid + "\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"plugin\" value=\"Bbs\">\n";
		comHTML = comHTML + "<input type=\"hidden\" name=\"rowid\" value=\"" + super.getRowid() + "\">\n";

		comHTML = comHTML + "<table>\n";

		comHTML = comHTML + "<tr>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + msg.getMessage(super.getLocale(), "caption.title","") + "：\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + "<input type=\"text\" name=\"options\" size=\"30\" maxlength=\"64\"><br>\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "</tr>\n";

		comHTML = comHTML + "<tr>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + msg.getMessage(super.getLocale(), "caption.name","") + "：\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + "<input type=\"text\" name=\"options\" size=\"20\" maxlength=\"64\"><br>\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "</tr>\n";

		comHTML = comHTML + "<tr>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + msg.getMessage(super.getLocale(), "caption.comment","") + "：\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "<td>\n";
		comHTML = comHTML + "<textarea id=\"comment\" name=\"options\"cols=\"50\" rows=\"4\" wrap=\"hard\"></textarea><br>\n";
		comHTML = comHTML + "<input type=\"submit\" name=\"bbs\" onclick=\"LENGTH_COM()\" value=\""+ msg.getMessage(super.getLocale(), "caption.write","") +  "\">\n";
		comHTML = comHTML + "</td>\n";
		comHTML = comHTML + "</tr>\n";

		comHTML = comHTML + "</table>\n";
		comHTML = comHTML + "</form>";
		return comHTML;
	}

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#submit(org.j69.eewiki.wiki.Wiki, org.apache.struts.action.ActionForm)
	 */
	public Wiki submit(Wiki wiki, ActionForm form) {

		Perl5Util perl = new Perl5Util();

		PluginSubmitForm psForm = (PluginSubmitForm)form;
		//ページ内でコマンドが置かれている行
		int rowid = psForm.getRowid() - 1;
		
		//タイトル--64文字まで
		String title = psForm.getOptions()[0];
		if (title.length() > 64) 
			title = title.substring(0, 63);

		//名前--64文字まで
		String name = psForm.getOptions()[1];
		if (name.length() > 64) 
			name = name.substring(0, 63);
		
		//コメント--2000文字まで
		String comment = psForm.getOptions()[2];
		if (comment.length() > 2000) 
			comment = comment.substring(0, 1999);
		
		//連続した改行は1つにしてしまう
		comment = perl.substitute("s/\\r\\n/\n/g", comment);
		comment = perl.substitute("s/\\n{3,}/\n\n/g", comment);
		
		//書き込み日付
		Calendar rightNow = Calendar.getInstance();
		String timestump = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(rightNow.getTime());

		try {
			//ページデータの取得
			String pageData = wiki.getPageContent() + "\n";
			StringBuffer buffer = new StringBuffer();
			String[] datas = pageData.split("\n");
			if (datas.length > rowid) {
				for (int i = 0; i < datas.length; i++) {
					if (rowid == i) {
						buffer.append(datas[i] + "\n");
						setBss(title, name, comment, timestump, buffer);
					}
					else {
						buffer.append(datas[i] + "\n");	
					}
				}
			}
			else {
				buffer.append(pageData);
				setBss(title, name, comment, timestump, buffer);
			}
			wiki.setPageContent(buffer.toString(), true, null);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return wiki;
	}

	/**
	 * BSSコンテンツのセット
	 * @param title
	 * @param name
	 * @param comment
	 * @param timestump
	 * @param buffer
	 */
	private void setBss(String title, String name, String comment, String timestump, StringBuffer buffer) {
		if (!name.equals("")) {
			if (title.equals("")) title = "non-taitle";
			buffer.append("#Size(4:#Color(blue:" + title + "))" + " -- ''" + name + "'' #Size(1:" + timestump + ")\n");
			buffer.append("----\n");
			buffer.append(comment + "\n");
			buffer.append("\n");
		}
	}
}
