package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiUtil;

/**
 * NewpageAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 05-23-2003
 *
 * XDoclet definition:
 * @struts:action path="/NewPage" name="CreateForm" attribute="" input="/pages/Viewpage.vm"
 * @struts:action-forward name="/Edit" path="/Edit"
 */
public class NewpageAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_Edit = "Edit";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //フォームBeanの値取得
        //fromが無い場合はEditFormを作成
        HttpSession session = request.getSession();
        if (form == null) {
            form = new EditForm();
            if ("request".equals(mapping.getScope()))
                request.setAttribute(mapping.getAttribute(), form);
            else
                session.setAttribute(mapping.getAttribute(), form);
        }
        CreateForm crform = (CreateForm) form;
        String pageName = crform.getPagename();
        Wiki wiki = null;

        //Wikiのページ名としてふさわしいかを判定
        if (!WikiUtil.validWikiWordName(pageName)) {
			String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.create"));
            wiki = new Wiki(linkName, request, msg);
            request.setAttribute("content" , wiki);
            request.setAttribute("contentType", "create");
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.pagename", pageName));
            return mapping.findForward(FORWARD_Edit);
        }
		
		pageName = WebUtil.escapeChar(pageName);
		
        //新規なのでページオーナーはデフォルト
		String pageowner = config_.getConfig("define.default,pageowner");
        wiki = new Wiki(pageName, pageowner, true, request, msg);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "edit");

        //ページの存在チェック
        if (wiki.isExist()) {
            //すでに有ればエラー画面に遷移
			String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.create"));
            wiki = new Wiki(linkName, request, msg);
            request.setAttribute("content" , wiki);
            request.setAttribute("contentType", "create");
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.isexists", pageName));
            return mapping.findForward(FORWARD_Edit);
        }

        //コンテンツ格納
        request.setAttribute("content" , wiki);

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Newpage");

        return mapping.findForward(FORWARD_Edit);
    }

}
