/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class GenericObjectPool
extends BaseObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int _maxIdle = 8;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private CursorableLinkedList _pool = null;
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;
    private Evictor _evictor = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this._factory = factory;
        this._maxActive = maxActive;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public int getMaxActive() {
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.notifyAll();
        }
    }

    public byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.notifyAll();
        }
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
        this.notifyAll();
    }

    public synchronized Object borrowObject() throws Exception {
        ObjectTimestampPair pair;
        long starttime = System.currentTimeMillis();
        block11: while (true) {
            pair = null;
            try {
                pair = (ObjectTimestampPair)this._pool.removeFirst();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (null == pair) {
                Object obj;
                if (this._maxActive <= 0 || this._numActive < this._maxActive) {
                    obj = this._factory.makeObject();
                    pair = new ObjectTimestampPair(obj);
                } else {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            obj = this._factory.makeObject();
                            pair = new ObjectTimestampPair(obj);
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (this._maxWait <= 0L || System.currentTimeMillis() - starttime < this._maxWait) continue block11;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
            }
            this._factory.activateObject(pair.value);
            if (!this._testOnBorrow || this._factory.validateObject(pair.value)) break;
            try {
                this._factory.passivateObject(pair.value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this._factory.destroyObject(pair.value);
        }
        ++this._numActive;
        return pair.value;
    }

    public synchronized void invalidateObject(Object obj) throws Exception {
        --this._numActive;
        this._factory.destroyObject(obj);
        this.notifyAll();
    }

    public synchronized void clear() {
        Iterator it = this._pool.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(((ObjectTimestampPair)it.next()).value);
            }
            catch (Exception e) {
                // empty catch block
            }
            it.remove();
        }
        this._pool.clear();
        this.notifyAll();
    }

    public int getNumActive() {
        return this._numActive;
    }

    public int getNumIdle() {
        return this._pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        block12: {
            boolean success = true;
            if (this._testOnReturn && !this._factory.validateObject(obj)) {
                success = false;
            } else {
                try {
                    this._factory.passivateObject(obj);
                }
                catch (Exception e) {
                    success = false;
                }
            }
            boolean shouldDestroy = !success;
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                --this._numActive;
                if (this._maxIdle > 0 && this._pool.size() >= this._maxIdle) {
                    shouldDestroy = true;
                } else if (success) {
                    this._pool.addFirst((Object)new ObjectTimestampPair(obj));
                }
                this.notifyAll();
            }
            if (!shouldDestroy) break block12;
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e) {}
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
        this.startEvictor(-1L);
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    public synchronized void evict() throws Exception {
        if (!this._pool.isEmpty()) {
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._pool.size());
            } else if (!this._evictionCursor.hasPrevious()) {
                this._evictionCursor.close();
                this._evictionCursor = this._pool.cursor(this._pool.size());
            }
            int i = 0;
            int m = this.getNumTests();
            while (i < m) {
                if (!this._evictionCursor.hasPrevious()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._pool.size());
                } else {
                    ObjectTimestampPair pair = (ObjectTimestampPair)this._evictionCursor.previous();
                    if (this._minEvictableIdleTimeMillis > 0L && System.currentTimeMillis() - pair.tstamp > this._minEvictableIdleTimeMillis) {
                        try {
                            this._evictionCursor.remove();
                            this._factory.destroyObject(pair.value);
                        }
                        catch (Exception e) {}
                    } else if (this._testWhileIdle) {
                        boolean active = false;
                        try {
                            this._factory.activateObject(pair.value);
                            active = true;
                        }
                        catch (Exception e) {
                            this._evictionCursor.remove();
                            try {
                                this._factory.passivateObject(pair.value);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this._factory.destroyObject(pair.value);
                        }
                        if (active) {
                            if (!this._factory.validateObject(pair.value)) {
                                this._evictionCursor.remove();
                                try {
                                    this._factory.passivateObject(pair.value);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                this._factory.destroyObject(pair.value);
                            } else {
                                try {
                                    this._factory.passivateObject(pair.value);
                                }
                                catch (Exception e) {
                                    this._evictionCursor.remove();
                                    this._factory.destroyObject(pair.value);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor(delay);
            Thread t = new Thread(this._evictor);
            t.setDaemon(true);
            t.start();
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        buf.append("Idle Objects:\n");
        Iterator it = this._pool.iterator();
        long time = System.currentTimeMillis();
        while (it.hasNext()) {
            ObjectTimestampPair pair = (ObjectTimestampPair)it.next();
            buf.append("\t").append(pair.value).append("\t").append(time - pair.tstamp).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    class Evictor
    implements Runnable {
        private boolean _cancelled = false;
        private long _delay = 0L;

        public Evictor(long delay) {
            this._delay = delay;
        }

        void cancel() {
            this._cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._cancelled) {
                try {
                    Thread.currentThread();
                    Thread.sleep(this._delay);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    GenericObjectPool.this.evict();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            GenericObjectPool genericObjectPool = GenericObjectPool.this;
            synchronized (genericObjectPool) {
                if (null != GenericObjectPool.this._evictionCursor) {
                    GenericObjectPool.this._evictionCursor.close();
                    GenericObjectPool.this._evictionCursor = null;
                }
            }
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object val) {
            this.value = val;
            this.tstamp = System.currentTimeMillis();
        }

        ObjectTimestampPair(Object val, long time) {
            this.value = val;
            this.tstamp = time;
        }
    }
}

