/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class LinkTool
implements ViewTool,
Cloneable {
    public static final String HTML_QUERY_DELIMITER = "&";
    public static final String XHTML_QUERY_DELIMITER = "&amp;";
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private String uri = null;
    private String anchor = null;
    private ArrayList queryData = null;
    private String queryDataDelim = "&";
    private static Method encode = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URLEncoder;

    protected void setXhtml(boolean useXhtml) {
        this.queryDataDelim = useXhtml ? XHTML_QUERY_DELIMITER : HTML_QUERY_DELIMITER;
    }

    protected LinkTool copyWith(QueryPair pair) {
        LinkTool copy = this.duplicate();
        copy.queryData = copy.queryData != null ? (ArrayList)this.queryData.clone() : new ArrayList();
        copy.queryData.add(pair);
        return copy;
    }

    protected LinkTool copyWith(String uri) {
        LinkTool copy = this.duplicate();
        copy.uri = uri;
        return copy;
    }

    protected LinkTool copyWithAnchor(String anchor) {
        LinkTool copy = this.duplicate();
        copy.anchor = anchor;
        return copy;
    }

    private LinkTool duplicate() {
        try {
            return (LinkTool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LinkTool copy;
            Velocity.warn((Object)("LinkTool: could not properly clone " + this.getClass() + " - " + e));
            try {
                copy = (LinkTool)this.getClass().newInstance();
            }
            catch (Exception ee) {
                copy = new LinkTool();
            }
            copy.application = this.application;
            copy.request = this.request;
            copy.response = this.response;
            copy.uri = this.uri;
            copy.anchor = this.anchor;
            copy.queryData = this.queryData;
            copy.queryDataDelim = this.queryDataDelim;
            return copy;
        }
    }

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        this.request = context.getRequest();
        this.response = context.getResponse();
        this.application = context.getServletContext();
        Boolean b = (Boolean)context.getAttribute("XHTML");
        if (b != null) {
            this.setXhtml(b);
        }
    }

    public LinkTool setAnchor(String anchor) {
        return this.copyWithAnchor(anchor);
    }

    public String getAnchor() {
        return this.anchor;
    }

    public LinkTool setRelative(String uri) {
        if (uri.startsWith("/")) {
            return this.copyWith(this.request.getContextPath() + uri);
        }
        return this.copyWith(this.request.getContextPath() + '/' + uri);
    }

    public LinkTool setURI(String uri) {
        return this.copyWith(uri);
    }

    public String getURI() {
        return this.uri;
    }

    public LinkTool addQueryData(String key, Object value) {
        return this.copyWith(new QueryPair(key, value));
    }

    public String getQueryData() {
        if (this.queryData != null && !this.queryData.isEmpty()) {
            StringBuffer out = new StringBuffer();
            int i = 0;
            while (i < this.queryData.size()) {
                out.append(this.queryData.get(i));
                if (i + 1 < this.queryData.size()) {
                    out.append(this.queryDataDelim);
                }
                ++i;
            }
            return out.toString();
        }
        return null;
    }

    public String getContextURL() {
        String scheme = this.request.getScheme();
        int port = this.request.getServerPort();
        StringBuffer out = new StringBuffer();
        out.append(this.request.getScheme());
        out.append("://");
        out.append(this.request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            out.append(':');
            out.append(port);
        }
        out.append(this.request.getContextPath());
        return out.toString();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getBaseRef() {
        StringBuffer out = new StringBuffer();
        out.append(this.getContextURL());
        out.append(this.request.getServletPath());
        return out.toString();
    }

    public String toString() {
        String query;
        StringBuffer out = new StringBuffer();
        if (this.uri != null) {
            out.append(this.uri);
        }
        if ((query = this.getQueryData()) != null) {
            if (this.uri == null || this.uri.indexOf(63) < 0) {
                out.append('?');
            } else {
                out.append(this.queryDataDelim);
            }
            out.append(query);
        }
        if (this.anchor != null) {
            out.append('#');
            out.append(this.encodeURL(this.anchor));
        }
        return this.response.encodeURL(out.toString());
    }

    public String encodeURL(String url) {
        if (encode != null) {
            try {
                Object[] args = new Object[]{url, this.response.getCharacterEncoding()};
                return (String)encode.invoke(null, args);
            }
            catch (IllegalAccessException e) {
                encode = null;
                Velocity.debug((Object)("LinkTool: Can't access JDK 1.4 encode method (" + e + "). Using deprecated version from now on."));
            }
            catch (InvocationTargetException e) {
                Velocity.debug((Object)("LinkTool: Error using JDK 1.4 encode method (" + e + "). Using deprecated version."));
            }
        }
        return URLEncoder.encode(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LinkTool.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LinkTool.class$("java.lang.String")) : class$java$lang$String};
            encode = (class$java$net$URLEncoder == null ? (class$java$net$URLEncoder = LinkTool.class$("java.net.URLEncoder")) : class$java$net$URLEncoder).getMethod("encode", args);
        }
        catch (NoSuchMethodException e) {
            Velocity.debug((Object)"LinkTool: Can't find JDK 1.4 encode method. Using JDK 1.3 version.");
        }
    }

    protected final class QueryPair {
        private final String key;
        private final Object value;

        public QueryPair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            StringBuffer out = new StringBuffer();
            if (this.value == null) {
                out.append(LinkTool.this.encodeURL(this.key));
                out.append('=');
            } else if (this.value instanceof List) {
                this.appendAsArray(out, this.key, ((List)this.value).toArray());
            } else if (this.value instanceof Object[]) {
                this.appendAsArray(out, this.key, (Object[])this.value);
            } else {
                out.append(LinkTool.this.encodeURL(this.key));
                out.append('=');
                out.append(LinkTool.this.encodeURL(String.valueOf(this.value)));
            }
            return out.toString();
        }

        private void appendAsArray(StringBuffer out, String key, Object[] arr) {
            String encKey = LinkTool.this.encodeURL(key);
            int i = 0;
            while (i < arr.length) {
                out.append(encKey);
                out.append('=');
                if (arr[i] != null) {
                    out.append(LinkTool.this.encodeURL(String.valueOf(arr[i])));
                }
                if (i + 1 < arr.length) {
                    out.append(LinkTool.this.queryDataDelim);
                }
                ++i;
            }
        }
    }
}

