/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class StrutsUtils {
    public static DataSource getDataSource(ServletContext app) {
        return (DataSource)app.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    public static ActionFormBeans getActionFormBeans(ServletContext app) {
        return (ActionFormBeans)app.getAttribute("org.apache.struts.action.FORM_BEANS");
    }

    public static FormBeanConfig getFormBean(String name, ServletContext app) {
        ActionFormBeans formBeans = StrutsUtils.getActionFormBeans(app);
        if (formBeans == null) {
            return null;
        }
        return formBeans.findFormBean(name);
    }

    public static ActionForwards getActionForwards(ServletContext app) {
        return (ActionForwards)app.getAttribute("org.apache.struts.action.FORWARDS");
    }

    public static ActionForward getActionForward(String name, ServletContext app) {
        ActionForwards forwards = StrutsUtils.getActionForwards(app);
        if (forwards == null) {
            return null;
        }
        return forwards.findForward(name);
    }

    public static ActionMappings getActionMappings(ServletContext app) {
        return (ActionMappings)app.getAttribute("org.apache.struts.action.MAPPINGS");
    }

    public static ActionMapping getActionMapping(String path, ServletContext app) {
        ActionMappings mappings = StrutsUtils.getActionMappings(app);
        if (mappings == null) {
            return null;
        }
        return mappings.findMapping(path);
    }

    public static MessageResources getMessageResources(ServletContext app) {
        return (MessageResources)app.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static MessageResources getMessageResources(HttpServletRequest request, ServletContext app) {
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)request, (ServletContext)app);
        return (MessageResources)app.getAttribute("org.apache.struts.action.MESSAGE" + moduleConfig.getPrefix());
    }

    public static MessageResources getMessageResources(HttpServletRequest request, ServletContext app, String bundle) {
        MessageResources resources = null;
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)request, (ServletContext)app);
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)request.getAttribute(bundle + moduleConfig.getPrefix())) == null) {
            resources = (MessageResources)app.getAttribute(bundle + moduleConfig.getPrefix());
        }
        return resources;
    }

    public static ModuleConfig selectModule(String urlPath, ServletContext app) {
        String prefix = RequestUtils.getModuleName((String)urlPath, (ServletContext)app);
        ModuleConfig config = (ModuleConfig)app.getAttribute("org.apache.struts.action.MODULE" + prefix);
        return config;
    }

    public static String getServletMapping(ServletContext app) {
        return (String)app.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public static Locale getLocale(HttpServletRequest request, HttpSession session) {
        Locale locale = null;
        if (session != null) {
            locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    public static String getToken(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("org.apache.struts.action.TOKEN");
    }

    public static ActionErrors getActionErrors(HttpServletRequest request) {
        return (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
    }

    public static ActionMessages getActionMessages(HttpServletRequest request) {
        return (ActionMessages)request.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public static Throwable getException(HttpServletRequest request) {
        return (Throwable)request.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    public static MultipartRequestWrapper getMultipartRequestWrapper(HttpServletRequest request) {
        return (MultipartRequestWrapper)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    public static ActionForm getActionForm(HttpServletRequest request, HttpSession session) {
        ActionConfig mapping = (ActionConfig)request.getAttribute("org.apache.struts.action.mapping.instance");
        if (mapping == null) {
            return null;
        }
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        if ("request".equals(mapping.getScope())) {
            return (ActionForm)request.getAttribute(attribute);
        }
        if (session != null) {
            return (ActionForm)session.getAttribute(attribute);
        }
        return null;
    }

    public static String getCancelName() {
        return "org.apache.struts.taglib.html.CANCEL";
    }

    public static String getGlobalErrorName() {
        return "org.apache.struts.action.GLOBAL_ERROR";
    }

    public static String getTokenName() {
        return "org.apache.struts.taglib.html.TOKEN";
    }

    public static String getActionMappingName(String action) {
        return RequestUtils.getActionMappingName((String)action);
    }

    public static String getActionMappingURL(ServletContext application, HttpServletRequest request, String action) {
        String servletMapping;
        StringBuffer value = new StringBuffer(request.getContextPath());
        ModuleConfig config = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        if (config != null) {
            value.append(config.getPrefix());
        }
        if ((servletMapping = (String)application.getAttribute("org.apache.struts.action.SERVLET_MAPPING")) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = RequestUtils.getActionMappingName((String)action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public static String getForwardURL(HttpServletRequest request, ServletContext app, String forward) {
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)request, (ServletContext)app);
        ForwardConfig fc = moduleConfig.findForwardConfig(forward);
        if (fc == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        if (fc.getPath().startsWith("/")) {
            url.append(request.getContextPath());
            url.append(RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)fc));
        } else {
            url.append(fc.getPath());
        }
        return url.toString();
    }

    public static String errorMarkup(String property, HttpServletRequest request, HttpSession session, ServletContext application) {
        return StrutsUtils.errorMarkup(property, null, request, session, application);
    }

    public static String errorMarkup(String property, String bundle, HttpServletRequest request, HttpSession session, ServletContext application) {
        ActionErrors errors = StrutsUtils.getActionErrors(request);
        if (errors == null) {
            return "";
        }
        Iterator reports = null;
        reports = property == null ? errors.get() : errors.get(property);
        if (!reports.hasNext()) {
            return "";
        }
        StringBuffer results = new StringBuffer();
        String header = null;
        String footer = null;
        Locale locale = StrutsUtils.getLocale(request, session);
        MessageResources resources = StrutsUtils.getMessageResources(request, application, bundle);
        if (resources != null) {
            header = resources.getMessage(locale, "errors.header");
            footer = resources.getMessage(locale, "errors.footer");
        }
        if (header == null) {
            header = "errors.header";
        }
        if (footer == null) {
            footer = "errors.footer";
        }
        results.append(header);
        results.append("\r\n");
        while (reports.hasNext()) {
            String message = null;
            ActionMessage report = (ActionMessage)reports.next();
            if (resources != null) {
                message = resources.getMessage(locale, report.getKey(), report.getValues());
            }
            if (message != null) {
                results.append(message);
                results.append("\r\n");
                continue;
            }
            results.append(report.getKey());
            results.append("\r\n");
        }
        results.append(footer);
        results.append("\r\n");
        return results.toString();
    }
}

