/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Validator;

public class ValidatorAction
implements Serializable {
    private String name = null;
    private String classname = null;
    private String method = null;
    private String methodParams = Validator.BEAN_KEY + "," + Validator.VALIDATOR_ACTION_KEY + "," + Validator.FIELD_KEY;
    private String depends = null;
    private String msg = null;
    private String jsFunctionName = null;
    private String javascript = null;
    private Object instance = null;
    private FastHashMap hDependencies = new FastHashMap();
    private List lMethodParams = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(String methodParams) {
        this.methodParams = methodParams;
    }

    public List getMethodParamsList() {
        return Collections.unmodifiableList(this.lMethodParams);
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getJsFunctionName() {
        return this.jsFunctionName;
    }

    public void setJsFunctionName(String jsFunctionName) {
        this.jsFunctionName = jsFunctionName;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    public Object getClassnameInstance() {
        return this.instance;
    }

    public void setClassnameInstance(Object instance) {
        this.instance = instance;
    }

    public synchronized void process(Map globalConstants) {
        String value;
        StringTokenizer st;
        if (this.getDepends() != null) {
            if (this.hDependencies == null) {
                this.hDependencies = new FastHashMap();
            }
            st = new StringTokenizer(this.getDepends(), ",");
            value = "";
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                if (depend == null || depend.length() <= 0) continue;
                this.hDependencies.put((Object)depend, (Object)value);
            }
            this.hDependencies.setFast(true);
        }
        if (this.getMethodParams() != null) {
            if (this.lMethodParams == null) {
                this.lMethodParams = new ArrayList();
            }
            st = new StringTokenizer(this.getMethodParams(), ",");
            while (st.hasMoreTokens()) {
                value = st.nextToken().trim();
                if (value == null || value.length() <= 0) continue;
                this.lMethodParams.add(value);
            }
        }
    }

    public boolean isDependency(String key) {
        if (this.hDependencies != null) {
            return this.hDependencies.containsKey((Object)key);
        }
        return false;
    }

    public Collection getDependencies() {
        return Collections.unmodifiableMap(this.hDependencies).keySet();
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("ValidatorAction: ");
        results.append(this.name);
        results.append("\n");
        return results.toString();
    }
}

