package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RTag</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="tag">
 *   <tag>
 *     <attribute name="name" type="string"/>
 *     <attribute name="ref" type="string"/>
 *   </tag>
 *   <sequence>
 *     <ref label="attribute" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="tag"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="name" type="string"/&gt;
 *     &lt;attribute name="ref" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="attribute" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RTag implements java.io.Serializable, IEE2RDefvarChoice {
    private String name_;
    private String ref_;
    // List<EE2RAttribute>
    private java.util.List attribute_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RTag</code>.
     *
     */
    public EE2RTag() {
    }

    /**
     * Creates a <code>EE2RTag</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RTag(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RTag</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RTag(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RTag</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RTag(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RTag</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RTag</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RTag</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RTag</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RTag</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RTag</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTag(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RTag</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RTag</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RTag</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        ref_ = URelaxer.getAttributePropertyAsString(element, "ref");
        attribute_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RAttribute.isMatch(stack)) {
                addAttribute(new EE2RAttribute(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("tag");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.ref_ != null) {
            URelaxer.setAttributePropertyByString(element, "ref", this.ref_);
        }
        size = this.attribute_.size();
        for (int i = 0;i < size;i++) {
            EE2RAttribute value = (EE2RAttribute)this.attribute_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RTag</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RTag</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RTag</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RTag</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RTag</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RTag</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>ref</b>.
     *
     * @return String
     */
    public final String getRef() {
        return (ref_);
    }

    /**
     * Sets the String property <b>ref</b>.
     *
     * @param ref
     */
    public final void setRef(String ref) {
        this.ref_ = ref;
    }

    /**
     * Gets the EE2RAttribute property <b>attribute</b>.
     *
     * @return EE2RAttribute[]
     */
    public final EE2RAttribute[] getAttribute() {
        EE2RAttribute[] array = new EE2RAttribute[attribute_.size()];
        return ((EE2RAttribute[])attribute_.toArray(array));
    }

    /**
     * Sets the EE2RAttribute property <b>attribute</b>.
     *
     * @param attribute
     */
    public final void setAttribute(EE2RAttribute[] attribute) {
        this.attribute_.clear();
        this.attribute_.addAll(java.util.Arrays.asList(attribute));
    }

    /**
     * Sets the EE2RAttribute property <b>attribute</b>.
     *
     * @param attribute
     */
    public final void setAttribute(EE2RAttribute attribute) {
        this.attribute_.clear();
        this.attribute_.add(attribute);
    }

    /**
     * Adds the EE2RAttribute property <b>attribute</b>.
     *
     * @param attribute
     */
    public final void addAttribute(EE2RAttribute attribute) {
        this.attribute_.add(attribute);
    }

    /**
     * Gets number of the EE2RAttribute property <b>attribute</b>.
     *
     * @return int
     */
    public final int getAttributeCount() {
        return (attribute_.size());
    }

    /**
     * Gets the EE2RAttribute property <b>attribute</b> by index.
     *
     * @param index
     * @return EE2RAttribute
     */
    public final EE2RAttribute getAttribute(int index) {
        return ((EE2RAttribute)attribute_.get(index));
    }

    /**
     * Sets the EE2RAttribute property <b>attribute</b> by index.
     *
     * @param index
     * @param attribute
     */
    public final void setAttribute(int index, EE2RAttribute attribute) {
        this.attribute_.set(index, attribute);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<tag");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(getName()));
            buffer.append("\"");
        }
        if (ref_ != null) {
            buffer.append(" ref=\"");
            buffer.append(URelaxer.escapeAttrQuot(getRef()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.attribute_.size();
        for (int i = 0;i < size;i++) {
            EE2RAttribute value = (EE2RAttribute)this.attribute_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</tag>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<tag");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(getName()));
            buffer.print("\"");
        }
        if (ref_ != null) {
            buffer.print(" ref=\"");
            buffer.print(URelaxer.escapeAttrQuot(getRef()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.attribute_.size();
        for (int i = 0;i < size;i++) {
            EE2RAttribute value = (EE2RAttribute)this.attribute_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</tag>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RTag</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "tag")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RAttribute.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTag</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTag</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
