package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RStructure</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="structure">
 *   <tag name="structure">
 *     <attribute name="value" type="string"/>
 *     <attribute name="type" type="NMTOKEN">
 *       <enumeration value="no-type"/>
 *       <enumeration value="indent"/>
 *       <enumeration value="cursor"/>
 *       <enumeration value="keyword"/>
 *       <enumeration value="argument"/>
 *       <enumeration value="region"/>
 *     </attribute>
 *   </tag>
 *   <empty/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="structure"&gt;
 *   &lt;tag name="structure"&gt;
 *     &lt;attribute name="value" type="string"/&gt;
 *     &lt;attribute name="type" type="NMTOKEN"&gt;
 *       &lt;enumeration value="no-type"/&gt;
 *       &lt;enumeration value="indent"/&gt;
 *       &lt;enumeration value="cursor"/&gt;
 *       &lt;enumeration value="keyword"/&gt;
 *       &lt;enumeration value="argument"/&gt;
 *       &lt;enumeration value="region"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/tag&gt;
 *   &lt;empty/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RStructure implements java.io.Serializable {
    private String value_;
    private String type_;

    /**
     * Creates a <code>EE2RStructure</code>.
     *
     */
    public EE2RStructure() {
    }

    /**
     * Creates a <code>EE2RStructure</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RStructure(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RStructure(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RStructure</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RStructure(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RStructure</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RStructure</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RStructure(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        value_ = URelaxer.getAttributePropertyAsString(element, "value");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("structure");
        if (this.value_ != null) {
            URelaxer.setAttributePropertyByString(element, "value", this.value_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RStructure</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RStructure</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>value</b>.
     *
     * @return String
     */
    public final String getValue() {
        return (value_);
    }

    /**
     * Sets the String property <b>value</b>.
     *
     * @param value
     */
    public final void setValue(String value) {
        this.value_ = value;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<structure");
        if (value_ != null) {
            buffer.append(" value=\"");
            buffer.append(URelaxer.escapeAttrQuot(getValue()));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</structure>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<structure");
        if (value_ != null) {
            buffer.print(" value=\"");
            buffer.print(URelaxer.escapeAttrQuot(getValue()));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</structure>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RStructure</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "structure")) {
            return (false);
        }
        RStack target = new RStack(element);
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RStructure</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RStructure</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
