/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import java.util.StringTokenizer;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Code Indenter document
 */
public class EE2ECIDocument implements EE2EDocument {
    public EE2ECIDocument(String string) {
        this.string = string;
    }
    
    /**
     * Returns the number of characters in this document.
     *
     * @return the number of characters in this document
     */
    public int getLength() {
        return this.string.length();
    }

    /**
     * Returns the character at the given document offset in this document.
     *
     * @param offset a document offset
     * @return the character at the offset
     * @exception EE2EIndentException if the offset is invalid in this document
     */
    public char getChar(int offset) throws EE2EIndentException {
        return this.string.charAt(offset);
    }

    /**
     * Returns this document's complete text.
     *
     * @return the document's complete text
     */
    public String get() {
        return this.string;
    }
    
    /**
     * Returns this document's text for the specified range.
     *
     * @param offset the document offset
     * @param length the length of the specified range
     * @return the document's text for the specified range
     * @exception EE2EIndentException if the range is invalid in this document
     */
    public String get(int offset, int length) throws EE2EIndentException {
        return this.get(offset,length);
    }

    /**
     * Returns the number of lines in this document
     *
     * @return the number of lines in this document
     */
    public int getNumberOfLines() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.string);
        int len = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextToken();
            len++;
        }
        return len;
    }

    /**
     * Determines the offset of the first character of the given line.
     *
     * @param line the line of interest
     * @return the document offset
     * @exception BadLocationException if the line number is invalid in this document
     */
    public int getLineOffset(int line) throws EE2EIndentException {
        int offset = 0;
        int nowLine = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.string);
        if (line <= 0) {
            return 0;
        }
        while (true) {
            String work = stringTokenizer.nextToken();
            nowLine++;
            offset += work.length();
            
            offset++; // '\n'
            if (line <= nowLine) {
                break;
            }
            if (!stringTokenizer.hasMoreElements()) {
                throw new EE2EIndentException("Buffer overflow Exception!!");
            }
        }
        return offset;
    }

    /**
     * Replaces the content of the document with the given text.
     * Sends a <code>DocumentEvent</code> to all registered <code>IDocumentListener</code>.
     * This method is a convenience method for <code>replace(0, getLength(), text)</code>.
     *
     * @param text the new content of the document
     */
    public void set(String text) {
        this.string = text;
    }

    /**
     * Substitutes the given text for the specified document range.
     * Sends a <code>DocumentEvent</code> to all registered <code>IDocumentListener</code>.
     *
     * @param offset the document offset
     * @param length the length of the specified range
     * @param text the substitution text
     * @exception EE2EIndentException if the offset is invalid in this document
     *
     * @see DocumentEvent
     * @see IDocumentListener
     */
    public void replace(int offset, int length, String text) throws EE2EIndentException {
        String one = this.string.substring(0,offset);
        String two = this.string.substring(offset + length);
        this.string = one + text + two;
    }


    private String string;
}
