/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.wizards;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTemplateList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class EE2ENewWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private String targetKey;
    private int targetIndex;

    public EE2ENewWizardPage(ISelection selection, ImageDescriptor image, String targetKey, int targetIndex) {
        super("wizardPage", null, image);
        this.selection = selection;
        this.targetKey = targetKey;
        this.targetIndex = targetIndex;
        this.setTitle(EE2EPlugin.getResourceString("file.title"));
        this.setDescription(String.valueOf(EE2EPlugin.getResourceString("file.title.tooltip.before")) + this.getMyExtention() + " " + EE2EPlugin.getResourceString("file.title.tooltip.after"));
    }

    protected String getTargetKey() {
        return this.targetKey;
    }

    protected int getTargetIndex() {
        return this.targetIndex;
    }

    public String getMyExtention() {
        String key = this.getTargetKey();
        int index = this.getTargetIndex();
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(key);
        if (index >= 0 && index <= ee2e.getTemplateListCount()) {
            EE2RTemplateList list = ee2e.getTemplateList(index);
            String extention = list.getExtention();
            if (extention == null) {
                return "";
            }
            return extention;
        }
        return "";
    }

    public String getMyIndex() {
        String key = this.getTargetKey();
        int index = this.getTargetIndex();
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(key);
        if (index >= 0 && index <= ee2e.getTemplateListCount()) {
            EE2RTemplateList list = ee2e.getTemplateList(index);
            String indexString = list.getIndex();
            if (indexString == null) {
                return "";
            }
            return indexString;
        }
        return "";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(EE2EPlugin.getResourceString("file.container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EE2ENewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EE2ENewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(EE2EPlugin.getResourceString("file.file"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EE2ENewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            IContainer container = null;
            if (obj instanceof IContainer) {
                container = (IContainer)obj;
            } else if (obj instanceof IResource) {
                container = ((IResource)obj).getParent();
            }
            if (container != null) {
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText(String.valueOf(this.getMyIndex()) + "." + this.getMyExtention());
    }

    private void handleBrowse() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result.length < 1) {
            return;
        }
        Object object = result[0];
        IPath path = null;
        if (object instanceof IContainer) {
            IContainer container = (IContainer)object;
            path = container.getFullPath();
        } else if (object instanceof IPath) {
            path = (IPath)object;
        }
        if (path == null) {
            return;
        }
        this.containerText.setText(path.toString());
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(this.getMyExtention())) {
            this.updateStatus("File extension must be \"" + this.getMyExtention() + "\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

