package jp.sourceforge.projects.ee2e.core.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.core.resources.*;
import org.eclipse.swt.events.*;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.runtime.IPath;
import jp.sourceforge.projects.ee2e.core.relax.*;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ENewWizardPage extends WizardPage {

	/**
	 * Constructor for SampleNewWizardPage.
	 * @param pageName
	 */
	public EE2ENewWizardPage(ISelection selection,ImageDescriptor image,String targetKey,int targetIndex) {
		super("wizardPage",null,image);
        this.selection = selection;
        this.targetKey = targetKey;
        this.targetIndex = targetIndex;
		this.setTitle(EE2EPlugin.getResourceString("file.title"));
		this.setDescription(EE2EPlugin.getResourceString("file.title.tooltip.before") +
			this.getMyExtention() + " " +
			EE2EPlugin.getResourceString("file.title.tooltip.after"));
	}

    protected String getTargetKey() {
        return this.targetKey;
    }
    protected int getTargetIndex() {
        return this.targetIndex;
    }

    public String getMyExtention() {
        String key = this.getTargetKey();
        int index = getTargetIndex();
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(key);
        if((0 <= index) && (index <= ee2e.getTemplateListCount())) {
            EE2RTemplateList list = ee2e.getTemplateList(index);
            String extention = list.getExtention();
            if(extention == null) {
                return "";
            }
            return extention;
        }
        return "";
    }
    public String getMyIndex() {
        String key = this.getTargetKey();
        int index = getTargetIndex();
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(key);
        if((0 <= index) && (index <= ee2e.getTemplateListCount())) {
            EE2RTemplateList list = ee2e.getTemplateList(index);
            String indexString = list.getIndex();
            if(indexString == null) {
                return "";
            }
            return indexString;
        }
        return "";
    }

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText(EE2EPlugin.getResourceString("file.container"));

		containerText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		containerText.setLayoutData(gd);
		containerText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		Button button = new Button(container, SWT.PUSH);
		button.setText("Browse...");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});
		label = new Label(container, SWT.NULL);
		label.setText(EE2EPlugin.getResourceString("file.file"));

		fileText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fileText.setLayoutData(gd);
		fileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		initialize();
		dialogChanged();
		setControl(container);
	}
	
	/**
	 * Tests if the current workbench selection is a suitable
	 * container to use.
	 */
	
	private void initialize() {
        if ( (selection == null) || (selection.isEmpty() == true) ) {
            /*EMPTY*/
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel.size()>1) return;
            Object obj = ssel.getFirstElement();

            IContainer container = null;
            //if (obj instanceof JavaElement) {
            //    containerText.setText(((JavaElement) obj).getElementName());
            //} else
            if (obj instanceof IContainer) {
                container = (IContainer)obj;
            } else if (obj instanceof IResource) {
                container = ((IResource)obj).getParent();
            }
            if(container != null) {
                containerText.setText(container.getFullPath().toString());
            }
        }
		fileText.setText(this.getMyIndex() + "." + this.getMyExtention());
	}
	
	/**
	 * Uses the standard container selection dialog to
	 * choose the new value for the container field.
	 */

	private void handleBrowse() {
		ContainerSelectionDialog dialog =
			new ContainerSelectionDialog(
				getShell(),
				ResourcesPlugin.getWorkspace().getRoot(),
				false,
				"Select new file container");
		if (dialog.open() != Window.OK) {
            return;
		}
        Object[] result = dialog.getResult();
        if (result.length < 1) {
            return;
        }
        Object object = result[0];
        IPath path = null;
        if(object instanceof IContainer) {
            IContainer container = (IContainer) object;
            path = container.getFullPath();
        } else if(object instanceof IPath) {
            path = (IPath) object;
        }
        if(path == null) {
            return;
        }
        containerText.setText(path.toString());
	}
	
	/**
	 * Ensures that both text fields are set.
	 */

	private void dialogChanged() {
		String container = getContainerName();
		String fileName = getFileName();

		if (container.length() == 0) {
			updateStatus("File container must be specified");
			return;
		}
		if (fileName.length() == 0) {
			updateStatus("File name must be specified");
			return;
		}
		int dotLoc = fileName.indexOf('.');
		if (dotLoc != -1) {
			String ext = fileName.substring(dotLoc + 1);
			if (ext.equalsIgnoreCase(this.getMyExtention()) == false) {
				updateStatus("File extension must be \"" +
					this.getMyExtention() + "\"");
				return;
			}
		}
		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

	public String getContainerName() {
		return containerText.getText();
	}
	public String getFileName() {
		return fileText.getText();
	}
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private String targetKey;
    private int targetIndex;
}