package jp.sourceforge.projects.ee2e.core.scratch;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;
import org.eclipse.jface.text.*;
import org.eclipse.core.resources.*;
import org.eclipse.ui.internal.dialogs.*;
import org.eclipse.ui.internal.*;
import org.eclipse.ui.texteditor.*;
import org.eclipse.ui.part.*;
import jp.sourceforge.projects.ee2e.core.typeset.EE2EReasonedFile;
import jp.sourceforge.projects.ee2e.core.*;

/**
 * Our sample action implements workbench action delegate.
 * The action proxy will be created by the workbench and
 * shown in the UI. When the user tries to use the action,
 * this delegate will be created and execution will be 
 * delegated to it.
 * @see IWorkbenchWindowActionDelegate
 */
public abstract class EE2EConsoleAction
    implements org.eclipse.ui.IViewActionDelegate {
    /**
     * 
     * The constructor.
     */
    public EE2EConsoleAction() {
        this.reasonedFile = new EE2EReasonedFile();
    }

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        //If this indication is given,
        // a message will go into EE2EScratch and Region will disappear.
        //EE2EDebug.printf(3, "EE2EConsoleAction#run");
        try {
            if (viewPart instanceof EE2EScratchView) {
                this.runScratch((EE2EScratchView) viewPart);
            } else {
                throw new PartInitException(
                    viewPart.toString() + " not understand!");
            }
        } catch (PartInitException e) {
            EE2EPlugin plugin = EE2EPlugin.getDefault();
            if (plugin == null) {
                EE2EDebug.printf(1, "EE2EPlugin not found!");
                return;
            }
            IWorkbench bentch = plugin.getWorkbench();
            if (bentch == null) {
                EE2EDebug.printf(1, "IWorkbench not found!");
                return;
            }
            IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
            if (window == null) {
                EE2EDebug.printf(1, "IWorkbenchWindow not found!");
                return;
            }
            DialogUtil.openError(
                window.getShell(),
                WorkbenchMessages.OpenNewWindowMenu_dialogTitle,
                e.getMessage(),
                e);
        }
    }
    protected void runScratch(EE2EScratchView scratchView)
        throws PartInitException {
        String selected = scratchView.getSelectionText();
        if ((selected == null) || (selected.equals(""))) {
            throw new PartInitException("Region not found!");
        }
        java.io.File parent = scratchView.getParent();
        this.actionStart(selected, parent);
    }
    protected abstract void actionStart(
        String selectString,
        java.io.File parent)
        throws PartInitException;
    public void selectionChanged(IAction action, ISelection selection) {
        /*EMPTY*/
    }
    protected void openEditor(IFile anserFile, boolean flag)
        throws PartInitException {
        if (anserFile == null) {
            return;
        }
        IWorkbenchPage page =
            PlatformUI
                .getWorkbench()
                .getActiveWorkbenchWindow()
                .getActivePage();
        IEditorInput input = new FileEditorInput(anserFile);
        if (!flag) {
            page.openEditor(input,IEditorRegistry.SYSTEM_EXTERNAL_EDITOR_ID);
            return;
        } else {
            IEditorPart editorPart = page.openEditor(input, IEditorRegistry.SYSTEM_INPLACE_EDITOR_ID);
            this.gotoLine(editorPart);
        }
    }
    public void gotoLine(IEditorPart editorPart) throws PartInitException {
        if (this.reasonedFile.getLineNumber() <= 0) {
            EE2EDebug.printf(1, "not number");
            return;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            EE2EDebug.printf(1, "not AbstractTextEditor!!");
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor) editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument(editor.getEditorInput());
        try {
            int lineNumber = this.reasonedFile.getLineNumber();
            int start = document.getLineOffset(lineNumber - 1);
            editor.selectAndReveal(start, 0);
            IWorkbenchWindow window =
                EE2EPlugin
                    .getDefault()
                    .getWorkbench()
                    .getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            page.activate(editor);
        } catch (BadLocationException e) {
            throw new PartInitException(
                "BadLocationException e=" + e.getMessage());
        }
    }
    protected EE2EReasonedFile getReasonedFile() {
        return this.reasonedFile;
    }
    private IViewPart viewPart;
    private EE2EReasonedFile reasonedFile;
}