package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ERecenter implements EE2EMenuBehavior {
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.recenter") + "(&k)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.recenter.tooltip");
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    public final void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {

        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        int maxOffset = document.getLength() - 1;
        if (maxOffset <= 0) {
            return;
        }
        int offset = textSelection.getOffset();
        int beforeOffset = 0;
        if (beforeOffset < (maxOffset - offset)) {
            beforeOffset = maxOffset;
        }
        EE2ESelectIndent sec = new EE2ESelectIndent(offset);
        editor.getSelectionProvider().setSelection(sec);
        // redhat linux motif-ver issue
        editor.setFocus();
        //
        sec = new EE2ESelectIndent(offset);
        editor.getSelectionProvider().setSelection(sec);
        //
        // redhat linux motif-ver issue
        editor.setFocus();
    }
}
