package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.text.*;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;

import org.eclipse.jface.text.Position;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentBehavior implements EE2EMenuBehavior {
    public EE2EIndentBehavior(EE2EIndentAction action) {
        this.action = action;
    }
    
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.indent");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.indent.tooltip");
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    public final void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {

        try {
            IDocument iDocument = EE2EToolkit.get().getEditorToDocument(editor);
            EE2EDocument document = new EE2EEclipseDocument(iDocument);

            int offset = textSelection.getOffset() + textSelection.getLength();

            Position saveExcursion = new Position(offset);
            iDocument.addPosition(saveExcursion);

            this.action.doIndent(offset,document);

            offset = saveExcursion.getOffset();
            iDocument.removePosition(saveExcursion);
            int head = EE2ELispBase.get().beginningOfLine(offset,document);
            head = EE2ELispBase.get().skipCharsForward(head," \t",document) + 1;
            if( head < document.getLength() ) {
                offset = head;
            }
            EE2ESelectIndent sec = new EE2ESelectIndent(offset);
            editor.getSelectionProvider().setSelection(sec);
            //
            // redhat linux motif-ver issue
            editor.setFocus();
        } catch (EE2EIndentException e) {
            throw new BadLocationException(e.getMessage());
        }
    }
    public EE2EIndentAction getAction() {
        return this.action;
    }
    private EE2EIndentAction action;
}
