package jp.sourceforge.projects.ee2e.core.editors;



import org.eclipse.ui.IEditorPart;
import org.eclipse.jface.action.IMenuManager;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView;
import jp.sourceforge.projects.ee2e.core.preferences.EE2EPreferencePage;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EJavaEditorActionContributor
    extends org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditorActionContributor {
    public EE2EJavaEditorActionContributor() {
        super();
        EE2EDebug.printf(3, "EE2EJavaEditorActionContributor start!");
    }

	/**
	 * @see org.eclipse.ui.IEditorActionBarContributor#setActiveEditor(IEditorPart)
	 */
    public void setActiveEditor(IEditorPart part) {
    	if(part != null) {
        	EE2EPreferencePage.checkStaticDefaults(part);
            //EE2ETextEditorActionContributor.changeScopeStatus(part);
            EE2ETextEditorActionContributor.createIMenuManager(part);
    	}
    	super.setActiveEditor(part);
    }

    /**
     * @see IEditorActionBarContributor#dispose()
     * @since 2.0
     */
    public void dispose() {
        super.dispose();
        EE2EDebug.printf(3, "EE2EJavaEditorActionContributor#dispose");
        EE2EMiniBufferView.removeEE2EDisplayCompletion();
    }
	/**
	 * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToMenu(IMenuManager)
	 */
    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        EE2EDebug.printf(3, "EE2EJavaEditorActionContributor#contributeToMenu");
        EE2ETextEditorActionContributor.staticContributeToMenu(manager);
    }
}
