/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;
import jp.sourceforge.projects.ee2e.core.relax.EE2RDefvar;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;

public class EE2EIndentLisp
implements EE2EIndentAction {
    public void doIndent(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int len = this.getLispCalculateIndent(argumentOffset, document);
        EE2ELispBase.get().indentTo(argumentOffset, len, document);
    }

    protected int getLispCalculateIndent(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        char ch;
        int offset = EE2ELispBase.get().beginningOfLine(argumentOffset, document);
        if (offset <= 0) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return 0;
        }
        if (this.doSharpSheck(offset, document)) {
            return 0;
        }
        boolean toriger = false;
        if (this.isNowTroiger(offset, document)) {
            return 0;
        }
        int pos = 0;
        --offset;
        while (offset >= 0) {
            if (this.isQuoteToriger(offset, document)) {
                boolean bl = toriger = !toriger;
            }
            if (!toriger && !this.isComment(offset, document)) {
                ch = document.getChar(offset);
                if (ch == '(') {
                    if (--pos < 0) {
                        break;
                    }
                } else if (ch == ')') {
                    ++pos;
                }
            }
            --offset;
        }
        if (pos >= 0) {
            return 0;
        }
        if (this.isDefine(++offset, document)) {
            ++offset;
        } else {
            char ch2;
            int oldOffset = offset;
            while (offset < document.getLength()) {
                char ch3 = document.getChar(offset);
                if (ch3 == '\r' || ch3 == '\n' || ch3 == ' ' || ch3 == '\t' || ch3 == ';') break;
                ++offset;
            }
            int counter = 0;
            while (offset < document.getLength()) {
                ch2 = document.getChar(offset);
                if (ch2 != ' ' && ch2 != '\t') break;
                ++counter;
                ++offset;
            }
            if (counter == 0 || document.getLength() <= offset) {
                offset = oldOffset;
            } else {
                ch2 = document.getChar(offset);
                if (ch2 == '\r' || ch2 == '\t' || ch2 == ';') {
                    offset = oldOffset;
                }
            }
        }
        pos = offset - 1;
        while (pos >= 0) {
            ch = document.getChar(pos);
            if (ch == '\r' || ch == '\n') break;
            --pos;
        }
        return offset - ++pos;
    }

    protected boolean isDefine(int offset, EE2EDocument document) throws EE2EIndentException {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("lisp");
        if (ee2e == null) {
            EE2EDebug.printf(1, "getDefvarData/ee2e is null");
            return false;
        }
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar("lisp-constants-table");
        if (defvar == null) {
            EE2EDebug.printf(1, "getDefvarData/defvar is null");
            return false;
        }
        int i = 0;
        while (i < defvar.getContentCount()) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2RTag) {
                EE2RTag tag = (EE2RTag)choice;
                if (EE2ELispBase.get().lookingAt(offset, tag.getName(), document)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean isComment(int offset, EE2EDocument document) throws EE2EIndentException {
        boolean toriger = false;
        int i = offset;
        while (i >= 0) {
            if (this.isQuoteToriger(i, document)) {
                boolean bl = toriger = !toriger;
            }
            if (!toriger) {
                char ch = document.getChar(i);
                if (ch == ';') {
                    return true;
                }
                if (ch == '\r' || ch == '\n') break;
            }
            --i;
        }
        return false;
    }

    private boolean doSharpSheck(int offset, EE2EDocument document) throws EE2EIndentException {
        int next = EE2ELispBase.get().skipCharsForward(offset, " \t\r\n", document);
        if (document.getLength() <= ++next + 1) {
            return false;
        }
        char char1 = document.getChar(next);
        char char2 = document.getChar(next + 1);
        return char1 == ';' && char2 == ';';
    }

    protected boolean isNowTroiger(int offset, EE2EDocument document) throws EE2EIndentException {
        boolean toriger = false;
        int i = 0;
        while (i < offset) {
            char ch;
            if (this.isQuoteToriger(i, document)) {
                boolean bl = toriger = !toriger;
            }
            if (!toriger && (ch = document.getChar(i)) == ';') {
                while (i < offset) {
                    ch = document.getChar(i);
                    if (ch == '\r' || ch != '\n') {
                        // empty if block
                    }
                    ++i;
                }
            }
            ++i;
        }
        return toriger;
    }

    protected boolean isQuoteToriger(int offset, EE2EDocument document) throws EE2EIndentException {
        boolean ans;
        if (offset < 0 || document.getLength() <= offset) {
            return false;
        }
        char ch = document.getChar(offset);
        boolean bl = ans = ch == '\"';
        if (!ans) {
            return false;
        }
        int count = 0;
        --offset;
        while (offset >= 0) {
            ch = document.getChar(offset);
            if (ch != '\\') break;
            ++count;
            --offset;
        }
        return count % 2 == 0;
    }
}

