/*
 * Created on 2003/08/23
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package jp.sourceforge.projects.ee2e.core.indent;

import junit.framework.Assert;

/**
 * Indentation fails for Snmp.
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentSnmpTest extends EE2EIndentBaseTest {

    public EE2EIndentSnmpTest(String name) {
        super(name);
    }

    /** public class */
    public void testDoIndent() {
        String base =
            "foo\n" +
             "        END\n";
        String now = "--";
        String answer = base + "    " + now;
        now = "  " + now; // dummy space

        EE2EDocument document = this.createEE2EDocument(base + now);
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = base.length();
        try {
            offset = EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1;
            target.doIndent(offset, document);
        } catch (EE2EIndentException e) {
            Assert.fail(e.getMessage());
        }
        String answerData = document.get();
        Assert.assertEquals(answerData, answer);
    }

    /**  */
    public void testEnd() {
        String base =
            "foo\n" +
            "        END";
        int answer = 4;
        this.snmpCalculateIndent(base, answer);
    }
    /**  */
    public void testComment() {
        String base =
            "   fooBar\n" +
            "    fooBar\n" +
            "      -- END";
        int answer = 4;
        this.snmpCalculateIndent(base, answer);
    }
    /**  */
    public void testCommentDouble() {
        String base =
            "boo\n" +
            "    fooBar" +
            "  -- aaa" +
            "      -- aaa";
        int answer = 4;
        this.snmpCalculateIndent(base, answer);
    }
    public void testUp() {
        String base =
            "fooBar\n" +
            "    IMPORTS";
        int answer = 8;
        this.snmpCalculateIndent(base, answer);
    }
    public void testTab() {
        String base =
            "fooBar\n" +
            "\taa";
        int answer = 4;
        this.snmpCalculateIndent(base, answer);
    }
    public void testDown() {
        String base =
            "gfoo" +
            "            fooBar\n" +
            "        END";
        int answer = 4;
        this.snmpCalculateIndent(base, answer);
    }

    /**
     * (defun snmp-calculate-indent ()
     *   (let ((empty (concat "\\([ \t]*\\)\\(" comment-start-skip "\\|$\\)"))
     *         (case-fold-search nil)) ; keywords must be in uppercase
     *     (save-excursion
     *       (while (and (>= (forward-line -1) 0)
     *                   (looking-at empty)))
     *       (skip-chars-forward " \t")
     *       (+ (current-column)
     *          ;; Are we looking at a macro open string?  If so, add more.
     *          (cond ((looking-at snmp-macro-open)
     *                 snmp-indent-level)
     *                ;; macro close string?  If so, remove some.
     *                ((looking-at snmp-macro-close)
     *                 (- snmp-indent-level))
     *                ;; Neither; just stay here.
     *                (t 0))))))
     */
    protected void snmpCalculateIndent(String base, int answer) {
        String now = "\n  --"; // dummy document
        EE2EDocument document = this.createEE2EDocument(base + now);
        Assert.assertNotNull(document);
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = base.length() + 1;
        try {
            offset = EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1;
            int answerData = target.doSnmpCalculateIndent(offset, document);
            Assert.assertEquals(answerData, answer);
        } catch (EE2EIndentException e) {
            Assert.fail(e.getMessage());
        }
    }

    /**
     * (defvar snmp-macro-open
     *   "[a-zA-Z][-a-zA-Z0-9]*[ \t]*\\(OBJECT\\|TRAP\\)-\\(TYPE\\|GROUP\\)\
     * \\|DESCRIPTION\\|IMPORTS\\|MODULE\\(-IDENTITY\\|-COMPLIANCE\\)\
     * \\|.*::=[ \t]*\\(BEGIN\\|TEXTUAL-CONVENTION\\)[ \t]*$")"
     */
    public void testLookingAtSnmpMacroOpen() throws EE2EIndentException {
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = 0;
        EE2EDocument document = this.createEE2EDocument("a0aZ OBJECT-TYPE");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("foo" + "\nendofline\n");
        Assert.assertTrue(! target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("DESCRIPTION" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("IMPORTS" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("MODULE-IDENTITY" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("MODULE-COMPLIANCE" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("MODULE-COMPLIANCE" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=" + "\nendofline\n");
        Assert.assertTrue(! target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=  " + "\nendofline\n");
        Assert.assertTrue(! target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("aa::=BEGIN" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tBEGIN" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tBEGIN  " + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tBEGINa" + "\nendofline\n");
        Assert.assertTrue(! target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("aa::=TEXTUAL-CONVENTION" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tTEXTUAL-CONVENTION" + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tTEXTUAL-CONVENTION  " + "\nendofline\n");
        Assert.assertTrue(target.lookingAtSnmpMacroOpen(offset, document));
        //
        document = this.createEE2EDocument("::=\tTEXTUAL-CONVENTIONa" + "\nendofline\n");
        Assert.assertTrue(! target.lookingAtSnmpMacroOpen(offset, document));
    }

    /** [a-zA-Z][-a-zA-Z0-9]*[ \t]+\\(OBJECT\\|TRAP\\)-\\(TYPE\\|GROUP\\) */
    public void testLookinAtFunction() throws EE2EIndentException {
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = 0;
        EE2EDocument document = this.createEE2EDocument("a0aZ OBJECT-TYPE");
        Assert.assertTrue(target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("a");
        Assert.assertTrue(! target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("c  \t foo");
        Assert.assertTrue(!target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("c  \t OBJECT-TYPE");
        Assert.assertTrue(target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("A  \t OBJECT-TYPE");
        Assert.assertTrue(!target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("a-  \t OBJECT-TYPE");
        Assert.assertTrue(!target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("9  \t OBJECT-TYPE");
        Assert.assertTrue(!target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("z09AZaz  \t OBJECT-GROUP");
        Assert.assertTrue(target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("b18BYby TRAP-TYPE");
        Assert.assertTrue(target.lookinAtFunctionObject(offset, document));
        //
        document = this.createEE2EDocument("y18BYby TRAP-GROUP");
        Assert.assertTrue(target.lookinAtFunctionObject(offset, document));
    }

    public void testLookingAtSnmpMacroClose() throws EE2EIndentException {
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = 0;
        EE2EDocument document = this.createEE2EDocument("END\n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("END  \t  \n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("ENDa\n" + "    foo");
        Assert.assertTrue(! target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument(";\n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("aa;\n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("aa;  \t  \n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("::=\n" + "    foo");
        Assert.assertTrue(! target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("::=  \n" + "    foo");
        Assert.assertTrue(! target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("::=  {\n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("::={\n" + "    foo");
        Assert.assertTrue(target.lookingAtSnmpMacroClose(offset,document));
        //
        document = this.createEE2EDocument("--\n" + "    foo");
        Assert.assertTrue(!target.lookingAtSnmpMacroClose(offset,document));
    }
    
    public void testIsSpaceCheck() throws EE2EIndentException {
        EE2EIndentSnmp target = (EE2EIndentSnmp) this.createEE2EIndent();
        int offset = 0;
        EE2EDocument document = this.createEE2EDocument("OBJECT-TYPE\n" + "    foo");
        Assert.assertTrue(! target.isSpaceCheck(offset,document));
        //
        offset = 0;
        document = this.createEE2EDocument(" \t  \n" + "    foo");
        Assert.assertTrue(target.isSpaceCheck(offset,document));
        //
        offset = 3;
        document = this.createEE2EDocument("AAA  \n" + "    foo");
        Assert.assertTrue(target.isSpaceCheck(offset,document));
        //
        offset = 3;
        document = this.createEE2EDocument("AAA   k \n" + "    foo");
        Assert.assertTrue(! target.isSpaceCheck(offset,document));
    }
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentSnmp(4);
    }
}
