package jp.sourceforge.projects.ee2e.core.indent;

import junit.framework.TestCase;
import junit.framework.Assert;

/**
 * Abstract class for Java indent
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public abstract class EE2EIndentBaseTest extends TestCase {

	/**
	 * Constructor for EE2EIndentJavaTest.
	 * @param name
	 */
	public EE2EIndentBaseTest(String name) {
		super(name);
	}
    protected void doIndent(String base, String now, String answer) {
        EE2EDocument document = this.createEE2EDocument(base + now);
        Assert.assertNotNull(document);
        EE2EIndentAction target = this.createEE2EIndent();
        int offset = base.length();
        try {
            offset = EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1;
            target.doIndent(offset, document);
        } catch (EE2EIndentException e) {
            Assert.fail(e.getMessage());
        }
        String answerData = document.get();
        Assert.assertEquals(answerData, answer);
    }
    protected abstract EE2EIndentAction createEE2EIndent();
    
    protected String getSpace(int len) {
        String ans = "";
        for(int i = 0 ; i < len ; i++) {
            ans += " ";
        }
        return ans;
    }
    public EE2EDocument createEE2EDocument(String string) {
        return EE2EIndentAllTests.createDocument(string);
    }
}
