package jp.sourceforge.projects.ee2e.core.editors;

import java.net.MalformedURLException;
import java.net.URL;

import jp.sourceforge.projects.ee2e.core.*;
import jp.sourceforge.projects.ee2e.core.relax.*;
import junit.framework.TestCase;
import junit.framework.Assert;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EFileTest extends TestCase {

	/**
	 * Constructor for EE2EToolkitTest.
	 * @param arg0
	 */
	public EE2EFileTest(String arg0) {
		super(arg0);
	}

	/**
	* fileTest
	*/
	public void testFileTexTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("tex");
		this.ee2eRefCheck(toolkit,ee2e);
	}
	public void testFileRubyTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("rb");
		this.ee2eRefCheck(toolkit,ee2e);
	}
	public void testFilePerlTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("pl");
		this.ee2eRefCheck(toolkit,ee2e);
	}
	public void testFileBatTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("bat");
		this.ee2eRefCheck(toolkit,ee2e);
	}
	public void testFileCTest() {
        EE2EToolkit toolkit = this.getMOCEE2ECdtToolkit();
		EE2REe2e ee2e = toolkit.getEe2e("c");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileTocTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
        EE2REe2e ee2e = toolkit.getEe2e("toc");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileTldTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("tld");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileJnipTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("jnlp");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileXslTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("xsl");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileWappTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("wapp");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileSevTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("sev");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileTtlTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("ttl");
		this.ee2eRefCheck(toolkit,ee2e);
    }
    public void testFileSnmp() {
        EE2EToolkit toolkit = EE2EToolkit.get();
        EE2REe2e ee2e = toolkit.getEe2e("snmp");
        this.ee2eRefCheck(toolkit,ee2e);
    }
    public void testFileLisp() {
        EE2EToolkit toolkit = EE2EToolkit.get();
        EE2REe2e ee2e = toolkit.getEe2e("lisp");
        this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileRlxTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("rlx");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileSdocTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("sdoc");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileJspTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("jsp");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileAntTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("ant");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileScofTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("scof");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileEe2eTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("ee2e");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileJavaTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("java");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileXmlTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("xml");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileTextTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("text");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileXhtmlTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("xhtml");
		this.ee2eRefCheck(toolkit,ee2e);
    }
	public void testFileXiTest() {
        EE2EToolkit toolkit = EE2EToolkit.get();
		EE2REe2e ee2e = toolkit.getEe2e("xi");
		this.ee2eRefCheck(toolkit,ee2e);
    }

	private static final String[] FUNC_LIST =
		{
			EE2EDependCompletent.ENUMULATION,
			EE2EDependCompletent.INTEGER,
			EE2EDependCompletent.FILE,
			EE2EDependCompletent.FILE_NAME,
			EE2EDependCompletent.XML_FILE_NAME,
			EE2EDependCompletent.FOLDER,
			EE2EDependCompletent.XML_SAME_ALIST,
			EE2EDependCompletent.XI_XPAHT,
			EE2EDependCompletent.HTML_IMAGE_FILE_NAME,
			EE2EDependCompletent.HTML_IMAGE_ALT,
			EE2EDependCompletent.HTML_IMAGE_WIDTH,
			EE2EDependCompletent.HTML_IMAGE_HEIGHT,
			EE2EDependCompletent.HTML_SET_REV_LINK,
			EE2EDependCompletent.HTML_SET_REL_LINK,
			EE2EDependCompletent.HTML_SET_CSS_STYLE,
			EE2EDependCompletent.HTML_SET_META_TYPES,
			EE2EDependCompletent.HTML_SET_HTTP_EQUIV,
			EE2EDependCompletent.HTML_SET_CONTENT,
			EE2EDependCompletent.JSP_SAME_ALIST,
			EE2EDependCompletent.JSP_ACTION_ALIST,
			EE2EDependCompletent.SDOC_IMAGE_STYLE,
			EE2EDependCompletent.JSP_JSTL_EL };

	private static final String[] STRUCTURE_TYPE =
		{
			EE2EToolkit.NO_TYPE,
			EE2EToolkit.INDENT,
			EE2EToolkit.CURSOR,
			EE2EToolkit.KEYWORD,
			EE2EToolkit.ARGUMENT,
			EE2EToolkit.REGION
		};

	private void ee2eRefCheck(EE2EToolkit toolkit,EE2REe2e ee2e) {
		Assert.assertNotNull(ee2e);
		for (int i = 0; i < ee2e.getStructureListCount(); i++) {
			EE2RStructureList list = ee2e.getStructureList(i);
			this.refCheck(toolkit,list.getTagref());
		}
		for (int i = 0; i < ee2e.getDefvarCount(); i++) {
			EE2RDefvar defvar = ee2e.getDefvar(i);
			for (int j = 0; j < defvar.getContentCount(); j++) {
				IEE2RDefvarChoice ch = defvar.getContent(j);
				if (ch instanceof EE2RAttribute) {
					EE2RAttribute ans = (EE2RAttribute) ch;
					Assert.assertNotNull(ans.getName());
					Assert.assertNull(ans.getRef());
					this.attributeCheck(toolkit,ans);
				} else if (ch instanceof EE2REnumeration) {
					EE2REnumeration ans = (EE2REnumeration) ch;
					this.enumerationCheck(toolkit,ans);
				} else if (ch instanceof EE2RTag) {
					EE2RTag ans = (EE2RTag) ch;
					Assert.assertNotNull(
						defvar.getId() + " index=" + j,
						ans.getName());
					Assert.assertNull(ans.getRef());
					this.tagCheck(toolkit,ans);
				} else {
					Assert.fail();
				}
			}
		}
		EE2RIterationList iteList = ee2e.getIterationList();
		if (iteList != null) {
			iterationListCheck(iteList);
		}
		for(int i = 0 ; i < ee2e.getProcessListCount() ; i++) {
            EE2RProcessList pList = ee2e.getProcessList(i);
            this.processListCheck(pList);
		}
		for(int i = 0 ; i < ee2e.getTemplateListCount() ; i++) {
            EE2RTemplateList pList = ee2e.getTemplateList(i);
            this.templateListCheck(pList);
		}
	}

	private void tagCheck(EE2EToolkit toolkit,EE2RTag ans) {
		for (int i = 0; i < ans.getAttributeCount(); i++) {
			this.attributeCheck(toolkit,ans.getAttribute(i));
		}
	}
	private void attributeCheck(EE2EToolkit toolkit,EE2RAttribute ans) {
		if ((ans.getRef() != null) && (!ans.getRef().equals(""))) {
			this.refCheck(toolkit,ans.getRef());
		}
		for (int i = 0; i < ans.getEnumerationCount(); i++) {
			this.enumerationCheck(toolkit,ans.getEnumeration(i));
		}
	}
	private void enumerationCheck(EE2EToolkit toolkit,EE2REnumeration enum) {
		if ((enum.getRef() == null) && (enum.getName() == null)) {
			Assert.fail(enum.getName() + "/" + enum.getRef());
		}

		EE2RDefvar newDefvar = EE2EToolkit.get().getDefvar(enum.getRef());
		if (newDefvar != null) {
			for (int j = 0; j < newDefvar.getContentCount(); j++) {
				IEE2RDefvarChoice choice = newDefvar.getContent(j);
				Assert.assertTrue(
					"error ref=" + enum.getRef(),
					choice instanceof EE2REnumeration);
			}
		}
		this.refCheck(toolkit,enum.getRef());
	}
	private void refCheck(EE2EToolkit toolkit,String ref) {
		if ((ref == null) || ref.equals("")) {
			return;
		}
		EE2RDefvar defvar = toolkit.getDefvar(ref);
		if (defvar != null) {
			return;
		}
		boolean flag = true;
		for (int i = 0; i < FUNC_LIST.length; i++) {
			if (ref.equals(FUNC_LIST[i])) {
				flag = false;
				break;
			}
		}
		if (flag) {
			EE2EDebug.printf(1, ref);
			Assert.fail(ref);
		}
	}
	protected void iterationListCheck(EE2RIterationList iteList) {
		Assert.assertNotNull(iteList.getType());
		Assert.assertTrue(
			iteList.getType().equals(
				EE2EInsertIterator.ITERATOR_LIST_TYPE_XML));
		for (int i = 0; i < iteList.getIterationCount(); i++) {
			iterationCheck(iteList.getIteration(i));
		}
	}
	protected void iterationCheck(EE2RIteration iteration) {
		Assert.assertNotNull(iteration.getOpener());
		Assert.assertTrue(
			(iteration.getRequire() == null)
				|| iteration.getRequire().equals(""));
		for (int i = 0; i < iteration.getStructureCount(); i++) {
			structureCheck(iteration.getStructure(i));
		}
	}
	protected void structureListCheck(EE2EToolkit toolkit,EE2RStructureList structureList) {
		for(int i = 0 ; i < structureList.getTagextCount() ; i++) {
            targetExtCheck(toolkit,structureList.getTagext(i));
		}
        for (int i = 0; i < structureList.getStructureCount(); i++) {
			structureCheck(structureList.getStructure(i));
		}
	}
	protected void targetExtCheck(EE2EToolkit toolkit,EE2RTagext ref) {
        if( (ref.getTagref() == null) || ref.getTagref().equals("")) {
            Assert.fail("getTagext is null!");
        }
        refCheck(toolkit,ref.getTagref());
        if( (ref.getTarget() == null) || ref.getTarget().equals("")) {
            Assert.fail("getTarget is null!");
        }
	}
	protected void structureCheck(EE2RStructure structure) {
		if (((structure.getType() == null) || (structure.getType().equals("")))
			&& ((structure.getValue() == null)
				|| (structure.getValue().equals("")))) {
			Assert.fail("structureCheck/both data is null!");
		}
        if((structure.getType() == null) || (structure.getType().equals("")) ) {
            return;
        }
		for(int i = 0 ; i < STRUCTURE_TYPE.length ; i++) {
            if(structure.getType().equals(STRUCTURE_TYPE[i])) {
                return;
            }
		}
		Assert.fail("structureCheck/type not found type=\"" + structure.getType() + "\"");
	}
	protected void processListCheck(EE2RProcessList pList) {
        Assert.assertNotNull(pList.getFile());
        Assert.assertTrue(! pList.getFile().equals(""));
        Assert.assertNotNull(pList.getFileType());
        Assert.assertTrue(! pList.getFileType().equals(""));
        Assert.assertNotNull(pList.getProcessName());
        Assert.assertTrue(! pList.getProcessName().equals(""));
        Assert.assertNotNull(pList.getFolder());
        Assert.assertTrue(! pList.getFolder().equals(""));
        for(int i = 0 ; i < pList.getProcessCount() ; i++) {
            this.processCheck(pList.getProcess(i));
        }
        try {
            pList.getIsJava();
        } catch(IllegalStateException e) {
            throw e;
        }
	}
	protected void templateListCheck(EE2RTemplateList pList) {
        Assert.assertNotNull(pList.getName());
        Assert.assertTrue(! pList.getName().equals(""));
        Assert.assertNotNull(pList.getType());
        Assert.assertTrue(! pList.getType().equals(""));
        Assert.assertNotNull(pList.getIndex());
        Assert.assertTrue(! pList.getIndex().equals(""));
        Assert.assertNotNull(pList.getExtention());
        Assert.assertTrue(! pList.getExtention().equals(""));
        for(int i = 0 ; i < pList.getTemplateCount() ; i++) {
            this.templateCheck(pList.getTemplate(i));
        }
	}
	protected void processCheck(EE2RProcess pList) {
        Assert.assertNotNull(pList.getArgument());
        Assert.assertTrue(! pList.getArgument().equals(""));
	}
	protected void templateCheck(EE2RTemplate pList) {
		String name = pList.getName();
		if( (name != null) && (!name.equals("")) ) {
            return;
		}
		String type = pList.getType();
		Assert.assertNotNull(type);
        Assert.assertTrue(!type.equals(""));
	}
	protected EE2EToolkit getMOCEE2ECdtToolkit() {
		return new MOCEE2ECdtToolkit();
	}
	public class MOCEE2ECdtToolkit extends EE2EToolkit {
        /** This is a method for a test. It uses succeeding. */
        protected URL getBaseURL(AbstractUIPlugin plugin) throws MalformedURLException {
            URL base;
            if (plugin != null) {
                EE2EDebug.printf(3, "use default");
                base = plugin.getBundle().getEntry("/");
            } else {
                EE2EDebug.printf(3, "use resouce");
                base = EE2REe2e.class.getResource("./");
                base = new URL(base, "../../../../../../../../jp.sourceforge.projects.ee2e.cdt.core/");
            }
            return base;
        }
	};
}
