package jp.sourceforge.projects.ee2e.core.cf;

import junit.framework.TestCase;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.*;
import junit.framework.Assert;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECFTest extends TestCase {

    /**
     * Constructor for EE2ECFTest.
     * @param name
     */
    public EE2ECFTest(String name) {
        super(name);
    }

    public void testGetTexFactory() {
        EE2ECF factory = this.getFileToFactory("struts-config.tex");
        Assert.assertTrue(factory instanceof EE2ECFTex);
        EE2ECF factory2 = this.getFileToFactory("work.tex");
        Assert.assertTrue(factory2 instanceof EE2ECFTex);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetPerlFactory() {
        EE2ECF factory = this.getFileToFactory("struts-config.pl");
        Assert.assertTrue(factory instanceof EE2ECFPerl);
        EE2ECF factory2 = this.getFileToFactory("work.cgi");
        Assert.assertTrue(factory2 instanceof EE2ECFPerl);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetRubyFactory() {
        EE2ECF factory = this.getFileToFactory("struts-config.rb");
        Assert.assertTrue(factory instanceof EE2ECFRuby);
        EE2ECF factory2 = this.getFileToFactory("work.rb");
        Assert.assertTrue(factory2 instanceof EE2ECFRuby);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetBatFactory() {
        EE2ECF factory = this.getFileToFactory("struts-config.bat");
        Assert.assertTrue(factory instanceof EE2ECFBat);
        EE2ECF factory2 = this.getFileToFactory("work.bat");
        Assert.assertTrue(factory2 instanceof EE2ECFBat);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetScofFactory() {
        EE2ECF factory = this.getFileToFactory("struts-config.xml");
        Assert.assertTrue(factory instanceof EE2ECFScof);
        EE2ECF factory2 = this.getFileToFactory("struts-config.xml");
        Assert.assertTrue(factory2 instanceof EE2ECFScof);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetAntFactory() {
        EE2ECF factory = this.getFileToFactory("build.xml");
        Assert.assertTrue(factory instanceof EE2ECFAnt);
        EE2ECF factory2 = this.getFileToFactory("build.xml");
        Assert.assertTrue(factory2 instanceof EE2ECFAnt);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetWappFactory() {
        EE2ECF factory = this.getFileToFactory("web.xml");
        Assert.assertTrue(factory instanceof EE2ECFWapp);
        EE2ECF factory2 = this.getFileToFactory("web.xml");
        Assert.assertTrue(factory2 instanceof EE2ECFWapp);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetSevFactory() {
        EE2ECF factory = this.getFileToFactory("server.xml");
        Assert.assertTrue(factory instanceof EE2ECFSev);
        EE2ECF factory2 = this.getFileToFactory("server.xml");
        Assert.assertTrue(factory2 instanceof EE2ECFSev);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetTextFactory() {
        EE2ECF factory1 = this.getFileToFactory("hogehoge.txt");
        Assert.assertTrue(factory1 instanceof EE2ECFText);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.txt");
        Assert.assertTrue(factory2 instanceof EE2ECFText);
        Assert.assertTrue(factory1 == factory2);
    }
    public void testGetJavaFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.java");
        Assert.assertTrue(factory instanceof EE2ECFJava);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.java");
        Assert.assertTrue(factory2 instanceof EE2ECFJava);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetXmlFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.xml");
        Assert.assertTrue(factory instanceof EE2ECFXml);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.xml");
        Assert.assertTrue(factory2 instanceof EE2ECFXml);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetEe2eFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.ee2e");
        Assert.assertTrue(factory instanceof EE2ECFEe2e);
        EE2ECF factory2 = this.getFileToFactory("bbb.ee2e");
        Assert.assertTrue(factory2 instanceof EE2ECFEe2e);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetXiFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.xi");
        Assert.assertTrue(factory instanceof EE2ECFXi);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.xi");
        Assert.assertTrue(factory2 instanceof EE2ECFXi);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetXhtmlFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.html");
        Assert.assertTrue(factory instanceof EE2ECFXhtml);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.html");
        Assert.assertTrue(factory2 instanceof EE2ECFXhtml);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetJspFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.jsp");
        Assert.assertTrue(factory instanceof EE2ECFJsp);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.jsp");
        Assert.assertTrue(factory2 instanceof EE2ECFJsp);
        Assert.assertTrue(factory == factory2);
        EE2ECF factory3 = this.getFileToFactory("test.jspf");
        Assert.assertTrue(factory3 instanceof EE2ECFJsp);
        Assert.assertTrue(factory == factory3);
    }
    public void testGetSdocFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.sdoc");
        Assert.assertTrue(factory instanceof EE2ECFSdoc);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.sdoc");
        Assert.assertTrue(factory2 instanceof EE2ECFSdoc);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetRelaxFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.rlx");
        Assert.assertTrue(factory instanceof EE2ECFRlx);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.rlx");
        Assert.assertTrue(factory2 instanceof EE2ECFRlx);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetXslFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.xsl");
        Assert.assertTrue(factory instanceof EE2ECFXsl);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.xsl");
        Assert.assertTrue(factory2 instanceof EE2ECFXsl);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetTldFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.tld");
        Assert.assertTrue(factory instanceof EE2ECFTld);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.tld");
        Assert.assertTrue(factory2 instanceof EE2ECFTld);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetJnlpFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.jnlp");
        Assert.assertTrue(factory instanceof EE2ECFJnlp);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.xjnlp");
        Assert.assertTrue(factory2 instanceof EE2ECFJnlp);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetTtlFactory() {
        EE2ECF factory = this.getFileToFactory("aaa.ttl");
        Assert.assertTrue(factory instanceof EE2ECFTtl);
        EE2ECF factory2 = this.getFileToFactory("hogehoge.ttl");
        Assert.assertTrue(factory2 instanceof EE2ECFTtl);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetSnmpFactory() {
        EE2ECF factory = this.getFileToFactory("rfc1213.mib");
        Assert.assertTrue(factory instanceof EE2ECFSnmp);
        EE2ECF factory2 = this.getFileToFactory("rfc1902.mib");
        Assert.assertTrue(factory2 instanceof EE2ECFSnmp);
        Assert.assertTrue(factory == factory2);
    }
    public void testGetLispFactory() {
        EE2ECF factory = this.getFileToFactory("epo-java.el");
        Assert.assertTrue(factory instanceof EE2ECFLisp);
        EE2ECF factory2 = this.getFileToFactory("epojava.el");
        Assert.assertTrue(factory2 instanceof EE2ECFLisp);
        Assert.assertTrue(factory == factory2);
    }
    public EE2ECF getFileToFactory(String name) {
        AbstractTextEditor editor = new MocAbstractTextEditor(name);
        Assert.assertNotNull(editor);
        IEditorInput imput = editor.getEditorInput();
        Assert.assertNotNull(imput);
        String realName = editor.getEditorInput().getName();
        Assert.assertNotNull(realName);
        String fileName = editor.getEditorInput().getName();
        EE2EGetFactory factory = EE2EGetFactory.get();
        //factory.clearInstance();
        return factory.getFactory(fileName);
    }
    private class MocAbstractTextEditor extends AbstractTextEditor {
        public MocAbstractTextEditor(String name) {
            this.name = name;
        }
        public IEditorInput getEditorInput() {
            return new MocEditorInput(name);
        }
        private String name;
    }
    private class MocEditorInput implements IEditorInput {
        public MocEditorInput(String name) {
            this.name = name;
        }
        public boolean exists() {
            return true;
        }
        public String getName() {
            return name;
        }
        public ImageDescriptor getImageDescriptor() {
            return null;
        }
        public IPersistableElement getPersistable() {
            return null;
        }
        public String getToolTipText() {
            return null;
        }
        public Object getAdapter(Class adapter) {
            return null;
        }
        private String name;
    }
}
