package jp.ac.takushoku_u.cs;
import java.util.Set;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.ArrayList;
import java.lang.Double;
/**
* TaskSequencePresumption饹Ϸ󲽤줿꤫顢
* ɸظ٥եظ٥١μꤦϰϤ
ꤹ뤿Υ饹Ǥ<br>
* ܥ饹ΥɥȤǤϡ<br>
* 
ե˴ؤ(1)f(v_i-1,v_i)-s_a*s_b*g(v_i-1,v_i)-f(v_i-1,v_j)+s_a*s_b*g(v_i-1,v_j)<br>
* (2)s_b*g(v_i-1,v_j)-s_b*g(v_i-1,v_i)<br>
* 
١˴ؤ(1)g(v_i-1,v_i)-s_a*s_b*f(v_i-1,v_i)-g(v_i-1,v_j)+s_a*s_b*f(v_i-1,v_j)<br>
* (2)s_a*f(v_i-1,v_j)-s_a*f(v_i-1,v_i)<br>
* Ȥޤ
* @version 1.0.1
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0107
*/
public class TaskSequencePresumption extends TaskSequence{
	
/**
* Ԥ
*/
	private Sequence series;
	
/**
* Ԥä
*/
	private ArithmeticMatrix matrix;
	
/**
* ͭ󥼥
*/
	private double POSITIVE_NOT_ZERO = Double.MIN_VALUE;
	
/**
* ͭ󥼥
*/
	private double NEGATIVE_NOT_ZERO = Double.MIN_VALUE * -1.0;
	
/**
* ѥ륹Ƚ
*/
	private double PULSE_NUMBER = 1.0E-16d;
	
	
/**
* ԤȤ0ηꤷޤ
*/
	public TaskSequencePresumption(){
		series = new Sequence();
		matrix = new ArithmeticMatrix();
		setGraph(matrix);
		setSequence(series);
		
		//TaskSequenceꤹ
		setMatrix(matrix);
	}
	
/**
* ܥޥȥꥯȿԤꤷޤ
* @param preSequence ꤹ
* @param graph 󲽤Ԥä
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤ

* @exception DisagreementSequenceSizeException ޥȥꥯSequenceΥ
פʤ
*/
	public TaskSequencePresumption(Sequence preSequence, ArithmeticMatrix 
graph){
		series = new Sequence();
		matrix = new ArithmeticMatrix();
		setGraph(graph);
		setSequence(preSequence);
		
		//TaskSequenceꤹ
		setMatrix(graph);
	}
	
	
/**
* ݸ¤ˤꤵ줿եζ֤ν֤ޤ
* @param k ݸ
* @return ꤷ֤ν
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaRangeSet(int k)
*/
    public RangeSet getAlphaRangeSet(int k){
	if(inQuadrant(k)){
	    int keiretu = 0;
	    //׻̤ Range
	    Range ra = new Range();
	    
	    //̰ݻѤ Range
	    Range ran = new Range();
	    
	    //ݻ RangeSet
	    RangeSet hashSet = new RangeSet();
	    
	    //ǽܤä     /*Υ*/
	    int[] el = new int[series.getLength()];
	    boolean[] es = new boolean[series.getLength()];
	    //Ѥιܤä 
	    boolean[] ek = new boolean[series.getLength()];
	    
	    for(int i = 0; i < series.getLength(); i++){
		int x=0;		
		int number = i;
		//ǽܤäƤ
		System.arraycopy(getIntReachElement(series.getItem(i)), 0, el, 0, 
series.getLength());
		
System.arraycopy(getReachElement(series.getItem(i)),0,es,0,series.getLength());
		//ѤߤιܤäƤ
		System.arraycopy(choicedItem(number),0,ek,0,series.getLength());
		//ǽܤѤߤιܤ
		for(int j=0; j<series.getLength(); j++){
		    if(es[j]==true && ek[j]==false){
			es[j] = true;
		    }
		    else{
			es[j] = false;
		    }
		}

		ran.rangeCopy(getAlphaNotItemRange(k));
		int co=0;
		int count;
		count = countReachElement(series.getItem(i));
		//ǽܤĴ٤
		//ǽܤ򤵤줿x򣱰ʾ
		for(int v=0; v<count; v++){
		    if((series.getItem(i)+1)==el[v]){
			x++;
			keiretu++;
				  }
		}
		if(x>0){
		    for(int j=0; j<series.getLength(); j++){
			if(es[j]&&(series.getItem(i)!=j)){
			    ra.rangeCopy(getAlphaPresumptionRange(series.getItem(i), j, k));
			    ran.rangeCopy(ran.getAndRange(ra));
			    co++;
			}
		    }
		    if(co == 0){
			ran.rangeCopy(getAlphaNotItemRange(k));
		    }
		}
		
		else{
		    ran.rangeCopy(getNaNRange(k));
		}	
		
		//֤ݻ
		hashSet.add(new Range(ran.getMin(), ran.getMax(), ran.hasMin(), 
ran.hasMax()));
	
		/*Ȥж֤ɤäɽǤޤ*/
		//	System.out.println(ran.getMin()+"<a<"+ran.getMax());
		
	    }
	    return hashSet;
	}
	else{
	    throw new ValueFormatException("quadrant(" + k + ")");
	}
    }
    
    
    
/**
* ݸ¤ˤꤵ줿եζ֤֤ޤ
* @param k ݸ
* @return ꤷ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaRange(int k)
*/
	public Range getAlphaRange(int k){
		if(inQuadrant(k)){
			RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
			Range ra = new Range();
			Range ran = new Range();
			ran.rangeCopy(getAlphaNotItemRange(k));
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				ran.rangeCopy(ran.getAndRange(ra));
			}
			
			return ran;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ͤˤ륢եε°ٴؿ֤ͤޤ
* @param k ݸ
* @param value ꤷ
* @return °ٴؿ
* @exception ValueFormatException ꤷݸ¤⤷ϻꤷͤꤨ
ʤͤǤä
* @see #getBetaAttribute(int k, double value)
*/
	public double getAlphaAttribute(int k, double value){
		if(inQuadrant(k)){
			if(isNormalAlpha(value)){
				RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
				int count = 0;
				Range ra = new Range();
				
				Iterator i = hashSet.iterator();
				while(i.hasNext()){
					ra.rangeCopy((Range)i.next());
					if(ra.hasValue(value)){
						count++;
					}
				}
				
				return (count * 1.0) / hashSet.size();
			}
			else{
				throw  new ValueFormatException("alpha(" + value + ")");
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}

	
/**
* 򤷤ݸ¤ˤ륢եε°ٴؿ֤ͤޤ
* @param k ݸ
* @param changevalue 򤷤ݸ¤ˤ°ٴؿѲ 
* @return abelon 򤵤줿ݸ¤°ٴؿ
* @see #getBetaAttribute(int k, double changevalue)
*/
	public double[] getAlphaAttributeDouble(int k, double[] changevalue){
	    int size = changevalue.length;
	    double[] abelon = new double[size];
	    for(int i=0; i<size; i++){
		abelon[i] = getAlphaAttribute(k,changevalue[i]);
	    }
	    return abelon;
	}


/**
* ݸ¤μꤦˤƵ°ٴؿͤѲ륢եͤ
֤ޤ
* ݸ¤μꤦ֤ξüϽ˴ޤޤޤ
* @param k ݸ
* @return Ѳ륢եͤ줿
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaAttributeSet(int k)
*/
	public Set getAlphaAttributeSet(int k){
		if(inQuadrant(k)){
			Set treeSet = new TreeSet();
			
			RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
    
			Range ra = new Range();
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
			    ra.rangeCopy((Range)i.next());
			  
				    treeSet.add(new Double(ra.getMin()));
				    treeSet.add(new Double(ra.getMax()));
				    if(Double.isNaN(ra.getMin()) == true){
					treeSet.remove(new Double(ra.getMin()));
				    }
				    if(Double.isNaN(ra.getMax()) == true){
					treeSet.remove(new Double(ra.getMax()));
				    }				   
 
				    if(ra.isSame()){
					if(getSAlpha(k) == 1.0){
					    if(ra.getMin() == 0.0){
						treeSet.add(new Double(ra.getMin()));
					    }
					    else if(ra.getMin() == 1.0){
					    treeSet.add(new Double( ra.getMin()));
					    }
					    else{
						treeSet.add(new Double(ra.getMin()));
						treeSet.add(new Double(ra.getMin()));
					    }
					}
					else{
					    if(ra.getMin() == 0.0){
						treeSet.add(new Double(ra.getMin()));
					    }
					    else if(ra.getMin() == -1.0){
						treeSet.add(new Double(ra.getMin()));
					    }
					    else{
						treeSet.add(new Double(ra.getMin()));
					    treeSet.add(new Double(ra.getMin()));
					    }
					}
				    }
				}
			return treeSet;
		}
		else{
		    throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
    
/**ݸ¤μꤦˤƵ°ٴؿͤѲͤѥ륹
*Ǥ򽸹֤ޤ
*@param kݸ
*@return Ѳͤѥ륹Ǥν
*@exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
*/
    public Set getAlphaPulseSet(int k){
	if(inQuadrant(k)){
	    Set treeSet = new TreeSet();
	    RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
	    int size = hashSet.size();
	    Double[] MIN = alphaMin(k);
	    Double[] MAX = alphaMax(k);


	    for(int x=0; x<size; x++){
		for(int j=0; j<size; j++){
		    if(MIN[x].compareTo(MAX[j])==0){
			if(Double.isNaN(MIN[x].doubleValue()) == false){
			    treeSet.add(MIN[x]);
			}
		    }
		}
	    }
	    return treeSet;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
    }

    /*min*/
    public Double[] alphaMin(int k){
	if(inQuadrant(k)){
	    Set ptreeSet = new TreeSet();	
	    RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
	    
	    int size = hashSet.size();
	    Double[] MIN = new Double[size];	    
	    int s = 0;
	    Range ra = new Range();
	    Iterator i = hashSet.iterator();
	    while(i.hasNext()){
		ra.rangeCopy((Range)i.next());
		MIN[s] = new Double(ra.getMin());
		s++;
	    }
	    return MIN;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
    }


 
    /*amax*/
    public Double[] alphaMax(int k){
	if(inQuadrant(k)){
	    Set ptreeSet = new TreeSet();	
	    RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
	    
	    int size = hashSet.size();
	    Double[] MAX = new Double[size];	    
	    int s = 0;
	    Range ra = new Range();
	    Iterator i = hashSet.iterator();
	    while(i.hasNext()){
		ra.rangeCopy((Range)i.next());
		MAX[s] = new Double(ra.getMax());
		s++;
	    }
	    return MAX;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
    }



/**ݸ¤μꤦˤƦͤѥ륹λε°ٴؿ
*֤ޤ
*@param kݸ
*@return ͤѥ륹λε°ٴؿ
*@exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
*/
    public double[] getAlphaPaluseAttribute(int k){
	if(inQuadrant(k)){
	    Set treeSet = new TreeSet();
	
	    RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
       
	    int size = hashSet.size();
	    int s = 0;
	    int v = 0;
	    Double[] MIN = alphaMin(k);
	    Double[] MAX = alphaMax(k);     

	    Set setx = new TreeSet(getAlphaPulseSet(k));
	    Iterator ix = setx.iterator();
	    while(ix.hasNext()){
		Double dy = (Double)ix.next();
		s++;
	    }
	  
	    double[] kizokudo = new double[s];
	    Double[] paluse = new Double[s];
	    Set sety = new TreeSet(getAlphaPulseSet(k));
	    Iterator iy = sety.iterator();
	    while(iy.hasNext()){
		paluse[v] = (Double)iy.next();
		v++;
	    }
	    int count1 = 0;
	    int count2 = 0;
	    int count3 = 0;
	    int same = 0;

	    for(int x=0; x<v; x++){
		count1 = 0;
		count2 = 0;
		count3 = 0;
		same = 0;

		Range ra = new Range();
		Iterator i = hashSet.iterator();
		while(i.hasNext()){
		    ra.rangeCopy((Range)i.next());
		    
		    if(ra.isSame()){
			if(paluse[x].compareTo(new Double(ra.getMin()))==0){
			    same++;
			}
		    }
		}

		if((paluse[x].intValue() != 0.0)&&(paluse[x].intValue() != 1.0)&&(paluse[x].intValue() != -1.0)){
		    for(int e=0; e<size; e++){
			if(paluse[x].compareTo(MIN[e])==0){
			    count1++;
			}
		    }	
		    for(int e=0; e<size; e++){
			if(paluse[x].compareTo(MAX[e])==0){
			    count2++;
			}
		    }

                    if(count1 == count2){
			count3 = count1;
		    }
		    else if(count1>count2){
			count3 = count2;
		    }
		    else{
			count3 = count1;
		    }

		    if(same == count3){
			count3 = count3 - same;
		    }
		}
		kizokudo[x] = ((count3+same)*1.0)/size;
	    }
	    return kizokudo;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
    }

/**
* ݸ¤μꤦˤƵ°ٴؿͤѲ륢եͤ
*double1֤ޤ
* ݸ¤μꤦ֤ξüϽ˴ޤޤޤ
* @param k ݸ
* @return Ѳ륢եͤ줿double1
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaAttributeSet(int k)
*/
    public double[] getAlphaAttributeDoubleSet(int k){
       
	if(inQuadrant(k)){
	    Set setx = new TreeSet(getAlphaAttributeSet(k));
	    int size = setx.size();           //ѲθĿ
	    int m=0;
	    Iterator ix = setx.iterator();
	    double[] achange = new double[size];      //°ٴؿθĿ
	    
	    
	    while(ix.hasNext()){
		Double dx = (Double)ix.next();
		double x = dx.doubleValue();
		achange[m] = x;
		m++;
	    }
	    return achange;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
	
    }


    /**
     * ݸ¤ˤꤵ줿١ζ֤ν֤ޤ
     * @param k ݸ
     * @return ꤷ֤ν
     * @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä

     * @see #getAlphaRangeSet(int k)
     */
    public RangeSet getBetaRangeSet(int k){
	if(inQuadrant(k)){
	    int keiretu = 0;
	    //׻̤ Range
	    Range ra = new Range();
	    
	    //̰ݻѤ Range
	    Range ran = new Range();
	    
	    //ݻ RangeSet
	    RangeSet hashSet = new RangeSet();
	    
	    //ǽܤä     /*Υ*/
	    int[] el = new int[series.getLength()];
	    boolean[] es = new boolean[series.getLength()];
	    boolean[] ek = new boolean[series.getLength()];

	    for(int i = 0; i < series.getLength(); i++){
		int x=0;		
		//ߤֹ
		int number = i;
		
		//ѤߤιܤäƤ
		System.arraycopy(choicedItem(number),0,ek,0,series.getLength());
		//ǽܤäƤ
		System.arraycopy(getIntReachElement(series.getItem(i)), 0, el, 0, 
series.getLength());
		
System.arraycopy(getReachElement(series.getItem(i)),0,es,0,series.getLength());

		//ǽܤѤߤιܤ
		for(int j=0; j<series.getLength(); j++){
		    if(es[j]==true && ek[j]==false){
			es[j] = true;
		    }
		    else{
			es[j] = false;
		    }
		}
		ran.rangeCopy(getBetaNotItemRange(k));
		int co=0;
		int count;
		count = countReachElement(series.getItem(i));
		//ǽܤĴ٤
		//ǽܤ򤵤줿x򣱰ʾ
		for(int v=0; v<count; v++){
		    if((series.getItem(i)+1)==el[v]){
			x++;
			keiretu++;
		    }
		}
		if(x>0){
		    for(int j=0; j<series.getLength(); j++){
			if(es[j]&&(series.getItem(i)!=j)){
			    ra.rangeCopy(getBetaPresumptionRange(series.getItem(i), j, k));
			    ran.rangeCopy(ran.getAndRange(ra));
			    co++;
			}
		    }
		    if(co == 0){
			ran.rangeCopy(getBetaNotItemRange(k));
		    }
		}
		
		else{
		    ran.rangeCopy(getNaNRange(k));
		}	
		
		
		//֤ݻ
		hashSet.add(new Range(ran.getMin(), ran.getMax(), ran.hasMin(), 
ran.hasMax()));
		/*	Ȥж֤ɤäɽǤޤ
		System.out.println(ran.getMin()+"<b<"+ran.getMax());
		*/
	    }
	    if(keiretu==series.getLength()){
		System.out.println();
		System.out.println("Legalʷ");
	    }
	    else{
		System.out.println("Illegalʷ");
	    }
	    return hashSet;
	}
	else{
	    throw new ValueFormatException("quadrant(" + k + ")");
	}
    }
    
    
    

		
/**
* ݸ¤ˤꤵ줿١ζ֤֤ޤ
* @param k ݸ
* @return ꤷ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getAlphaRange(int k)
*/
	public Range getBetaRange(int k){
		if(inQuadrant(k)){
			RangeSet hashSet = new RangeSet(getBetaRangeSet(k));
			Range ra = new Range();
			Range ran = new Range();
			ran.rangeCopy(getBetaNotItemRange(k));
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				ran.rangeCopy(ran.getAndRange(ra));
			}
			
			return ran;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ͤˤ١ε°ٴؿ֤ͤޤ
* @param k ݸ
* @param value ꤷ
* @return °ٴؿ
* @exception ValueFormatException ꤷݸ¤⤷ϻꤷͤꤨ
ʤͤǤä
* @see #getAlphaAttribute(int k, double value)
*/
	public double getBetaAttribute(int k, double value){
		if(inQuadrant(k)){
			if(isNormalAlpha(value)){
				RangeSet hashSet = new RangeSet(getBetaRangeSet(k));
				int count = 0;
				Range ra = new Range();
				
				Iterator i = hashSet.iterator();
				while(i.hasNext()){
					ra.rangeCopy((Range)i.next());
					if(ra.hasValue(value)){
						count++;
					}
				}
				
				return (count * 1.0) / hashSet.size();
			}
			else{
				throw  new ValueFormatException("alpha(" + value + ")");
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	

/**
* 򤷤ݸ¤ˤ¤ε°ٴؿ֤ͤޤ
* @param k ݸ
* @param changevalue 򤷤ݸ¤ˤ¤°ٴؿѲ 
* @return abelon 򤵤줿ݸ¤°ٴؿ
* @see #getBetaAttribute(int k, double changevalue)
*/
	public double[] getBetaAttributeDouble(int k, double[] changevalue,int 
size){
	    
	    double[] abelon = new double[size];
	    for(int i=0; i<size; i++){
		abelon[i] = getBetaAttribute(k,changevalue[i]);
	    }
	    return abelon;
	}



/**
* ݸ¤μꤦˤƵ°ٴؿͤѲ١ͤ
֤ޤ
* ݸ¤μꤦ֤ξüϽ˴ޤޤޤ
* @param k ݸ
* @return Ѳ١ͤ줿
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getAlphaAttributeSet(int k)
*/
	public Set getBetaAttributeSet(int k){
		if(inQuadrant(k)){
			Set treeSet = new TreeSet();
			
			RangeSet hashSet = new RangeSet(getBetaRangeSet(k));


			Range ra = new Range();
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				treeSet.add(new Double(ra.getMin()));
				treeSet.add(new Double(ra.getMax()));
				
				if(Double.isNaN(ra.getMin()) == true){
				    treeSet.remove(new Double(ra.getMin()));
				}
				if(Double.isNaN(ra.getMax()) == true){
				    treeSet.remove(new Double(ra.getMax()));
				}				   
				
				if(ra.isSame()){
					if(getSBeta(k) == 1.0){
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(POSITIVE_NOT_ZERO));
						}
						else if(ra.getMin() == 1.0){
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
						else{
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
					}
					else{
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(NEGATIVE_NOT_ZERO));
						}
						else if(ra.getMin() == -1.0){
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
						}
						else{
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
					}
				}
			}
			return treeSet;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}

/**
* 
ݸ¤μꤦˤƵ°ٴؿͤѲ١ͤdouble
1֤ޤ
* ݸ¤μꤦ֤ξüϽ˴ޤޤޤ
* @param k ݸ
* @return Ѳ륢եͤ줿double1
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaAttributeSet(int k)
*/
    public double[] getBetaAttributeDoubleSet(int k){
	if(inQuadrant(k)){
	    Set setx = new TreeSet(getBetaAttributeSet(k));
	    int size = setx.size();                        //ѲθĿ
	    Iterator ix = setx.iterator();
	    double[] bchange = new double[size];      //°ٴؿ

		int m=0;
	    while(ix.hasNext()){
		Double dx = (Double)ix.next();
		double x = dx.doubleValue();
		bchange[m] = x;
		m++;
	    }
	    return bchange;
	}
	else{
	    throw new ValueFormatException("quadrant("+k+")");
	}
    }
	
/**
* ¾ǽܤ̵Υեοꤵ줿֤֤ޤ
* @param k ݸ
* @return ꤷ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getBetaNotItemRange(int k)
*/
	private Range getAlphaNotItemRange(int k){
		if(inQuadrant(k)){
			if(getSAlpha(k) == 1.0){
				return new Range(0.0 ,1.0, true, true);
			}
			else{
				return new Range(-1.0, 0.0 , true, true);
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
/**
*¾ǽܤ̵ζ֤NaN֤ޤ
*@param kݸ
*@return NaN
*@exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
*/
    private Range getNaNRange(int k){
	if(inQuadrant(k)){
	    return new Range();
		}
	else{
	    throw new ValueFormatException("quadrant(" + k + ")");
	}
    }
	
	


/**
* ¾ǽܤ̵Υ١οꤵ줿֤֤ޤ
* @param k ݸ
* @return ꤷ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getAlphaNotItemRange(int k)
*/
	private Range getBetaNotItemRange(int k){
		if(inQuadrant(k)){
			if(getSBeta(k) == 1.0){
				return new Range(0.0, 1.0, true, true);
			}
			else{
				return new Range(-1.0, 0.0, true, true);
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* 2ܴ֤ꤷեζ֤֤ޤ
* vi  vj ꤷܥޥȥꥯιܤιֹꤷޤ(0ϲ
۹ܤǤϤޤ)
* @param vi ºݤ򤵤줿
* @param vj ¾ǽ
* @param k ݸ(եμꤦ֡
* @return Ǥ
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getBetaPresumptionRange(int vi, int vj, int k)
*/
	public Range getAlphaPresumptionRange(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					if(inQuadrant(k)){
						double expressionOne = getDiscriminantOneAlpha(vi, vj, k);		//(1)
						double expressionTwo = getDiscriminantTwoAlpha(vi, vj, k);		//(2)
						double expression = getDiscriminantAlpha(vi, vj, k);		//(2)/(1)
						
						return getPresumptionRange(expressionOne, expressionTwo, expression, 
getSAlpha(k));
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* 2ܴ֤ꤷ١ζ֤֤ޤ
* vi  vj ꤷܥޥȥꥯιܤιֹꤷޤ(0ϲ
۹ܤǤϤޤ)
* @param vi ºݤ򤵤줿
* @param vj ¾ǽ
* @param k ݸ(١μꤦ֡
* @return Ǥ
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getAlphaPresumptionRange(int vi, int vj, int k)
*/
	public Range getBetaPresumptionRange(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					if(inQuadrant(k)){
						double expressionOne = getDiscriminantOneBeta(vi, vj, k);		//(1)
						double expressionTwo = getDiscriminantTwoBeta(vi, vj, k);		//(2)
						double expression = getDiscriminantBeta(vi, vj, k);		//(2)/(1)
						
						return getPresumptionRange(expressionOne, expressionTwo, expression, 
getSBeta(k));
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* 2ܴ֤ǿꤷ֤֤ޤ
* @param expressionOne (1)η׻
* @param expressionTwo (2)η׻
* @param expression (2) / (1)η׻
* @param k ꤷݸ¤ξ
* @return ꤷ
*/
	private Range getPresumptionRange(double expressionOne, double 
expressionTwo, double expression, double k){
		if(expressionOne == 0.0){
			if(expressionTwo > 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionZeroPlusPlusOut(expression);
					}
					else{
						return calPresumptionZeroPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionZeroPlusMinusOut(expression);
					}
					else{
						return calPresumptionZeroPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionZeroMinusPlusOut(expression);
					}
					else{
						return calPresumptionZeroMinusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionZeroMinusMinusOut(expression);
					}
					else{
						return calPresumptionZeroMinusMinusIn(expression);
					}
				}
			}
		}
		else if(expressionOne > 0.0){
			if(expressionTwo >= 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionPlusPlusPlusOut(expression);
					}
					else{
						return calPresumptionPlusPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionPlusPlusMinusOut(expression);
					}
					else if(expression == 0){
						return calPresumptionPlusPlusMinusZero(expression);
					}
					else{
						return calPresumptionPlusPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionPlusMinusPlusOut(expression);
					}
					else{
						return calPresumptionPlusMinusPlusIn(expression);
					}
				}
				else{
					if(expression <= -1){
						return calPresumptionPlusMinusMinusOut(expression);
					}
					else{
						return calPresumptionPlusMinusMinusIn(expression);
					}
				}
			}
		}
		else{
			if(expressionTwo >= 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionMinusPlusPlusOut(expression);
					}
					else if(expression == 0.0){
						return calPresumptionMinusPlusPlusZero(expression);
					}
					else{
						return calPresumptionMinusPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionMinusPlusMinusOut(expression);
					}
					else{
						return calPresumptionMinusPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionMinusMinusPlusOut(expression);
					}
					else{
						return calPresumptionMinusMinusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionMinusMinusMinusOut(expression);
					}
					else{
						return calPresumptionMinusMinusMinusIn(expression);
					}
				}
			}
		}
	}
	
/**
* vi1δܤ֤ޤ
* ֹ֤vi򤹤ιܤǤ
* ۹ܤͿɬפܥޥȥꥯǤ硢ܤͿ0
֤ޤ
* @param vi 
* @return 1δ
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public int getBeforeItem(int vi){
		if(matrix.isRowNumber(vi)){
			int va = series.getNumber(vi) -1;		//viν֡viʤ礳㳰ȯ
			int v;		//ܤõ
			
			if(isDummy()){		//۹ܤΤ
				if(va < 0){
					v = 0;
				}
				else{
					v = series.getItem(va) + 1;
				}
			}
			else{
				v = series.getItem(va);
			}
			return v;
		}
		else{
			throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* եˤ(1)η׻̤֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantOneBeta(int vi, int vj, int k)
*/
	public double getDiscriminantOneAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
				
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantOneAlpha(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* եˤ(1)η׻̤֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantOneBeta(double fVi, double gVi, double fVj, double 
gVj, int k)
*/
	public double getDiscriminantOneAlpha(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			double sb = getSBeta(k);
			return fVi - sa * sb * gVi - fVj + sa * sb * gVj;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* եˤ(2)η׻̤֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantTwoBeta(int vi, int vj, int k)
*/
	public double getDiscriminantTwoAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
					
						return getDiscriminantTwoAlpha(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* եˤ(2)η׻̤֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantTwoBeta(double fVi, double gVi, double fVj, double 
gVj, int k)
*/
	public double getDiscriminantTwoAlpha(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			double sb = getSBeta(k);
			return sb * gVj - sb * gVi;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* եˤ(2) / (1)η׻̤֤ޤ
* (1)0ξ0֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantBeta(int vi, int vj, int k)
*/
	public double getDiscriminantAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantAlpha(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* եˤ(2) / (1)η׻̤֤ޤ
* (1)0ξ0֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantBeta(double fVi, double gVi, double fVj, double gVj, 
int k)
*/
	public double getDiscriminantAlpha(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			if(getDiscriminantOneAlpha(fVi, gVi, fVj, gVj, k) != 0){
				return getDiscriminantTwoAlpha(fVi, gVi, fVj, gVj, k) / 
getDiscriminantOneAlpha(fVi, gVi, fVj, gVj, k);
			}
			else{
				return 0;
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ١ˤ(1)η׻̤֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantOneAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantOneBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
				
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantOneBeta(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* ١ˤ(1)η׻̤֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantOneAlpha(double fVi, double gVi, double fVj, double 
gVj, int k)
*/
	public double getDiscriminantOneBeta(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			double sb = getSBeta(k);
			return gVi - sa * sb * fVi - gVj + sa * sb * fVj;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ١ˤ(2)η׻̤֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantTwoAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantTwoBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
					
						return getDiscriminantTwoBeta(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* ١ˤ(2)η׻̤֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantTwoAlpha(double fVi, double gVi, double fVj, double 
gVj, int k)
*/
	public double getDiscriminantTwoBeta(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			return sa * fVj - sa * fVi;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ١ˤ(2) / (1)η׻̤֤ޤ
* (1)0ξ0֤ޤ
* @param vi ºݤ
* @param vj Ԥʤäǽ
* @param k ݸ
* @return ׻
* @exception NotItemException ꤷܤ¸ߤʤ
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @exception IllegalRelationValuesException ºݤ򤵤줿ܤ
ǽܤδطۤʤ
* @see #getDiscriminantAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//kϰϤ
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//۹ܤΤ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantBeta(getF(v, vi), getG(v, vi), getF(v, vj), 
getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + 
")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* ١ˤ(2) / (1)η׻̤֤ޤ
* (1)0ξ0֤ޤ
* @param fVi ºݤܤι
* @param gVi ºݤܤιɸ
* @param fVj Ԥʤäǽܤι
* @param gVj Ԥʤäǽܤιɸ
* @param k ݸ
* @return ׻
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getDiscriminantAlpha(double fVi, double gVi, double fVj, double 
gVj, int k)
*/
	public double getDiscriminantBeta(double fVi, double gVi, double fVj, 
double gVj, int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			if(getDiscriminantOneBeta(fVi, gVi, fVj, gVj, k) != 0){
				return getDiscriminantTwoBeta(fVi, gVi, fVj, gVj, k) / 
getDiscriminantOneBeta(fVi, gVi, fVj, gVj, k);
			}
			else{
				return 0;
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ꤵ줿ݸ¤ͤs_a֤ͤޤ
* @param k ݸ
* @return s_a
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getSBeta(int k)
*/
	private double getSAlpha(int k){
		
		//kϰϤ
		if(inQuadrant(k)){
			
			double value;
			if(k == 1 || k == 4){
				value = 1.0;
			}
			else{
				value = -1.0;
			}
			return value;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ꤵ줿ݸ¤ͤs_b֤ͤޤ
* @param k ݸ
* @return s_b
* @exception ValueFormatException ꤷݸ¤ꤨʤͤǤä
* @see #getSAlpha(int k)
*/
	private double getSBeta(int k){
		
		//kϰϤ
		if(inQuadrant(k)){
		
			double value;
			if(k == 1 || k == 2){
				value = 1.0;
			}
			else{
				value = -1.0;
			}
			return value;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* (1) = 0  (2) > 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0<= 
(2)/(1)
 <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroPlusPlusIn(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 < -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1 <= (2)
/(1) <= 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroPlusMinusIn(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) <= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) = 0  (2) <= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0 <= (2)
/(1) <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroMinusPlusIn(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) = 0  (2) <= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 < -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, false);
	}
	
/**
* (1) = 0  (2) <= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1<= (2)
/(1) <= 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionZeroMinusMinusIn(double expression){
		return new Range( -1.0, 0.0, true, false);
	}
	
/**
* (1) > 0  (2) >= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0<= 
(2)/(1)
 <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusPlusPlusIn(double expression){
		return new Range( expression, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) >= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 < -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1<= (2)
/(1) < 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusPlusMinusIn(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 = 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusPlusMinusZero(double expression){
		return new Range( 0.0, 0.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0<= 
(2)/(1)
 <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusMinusPlusIn(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 <= -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1 < (2)
/(1) <= 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionPlusMinusMinusIn(double expression){
		return new Range( expression, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) >= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0< 
(2)/(1)
 <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusPlusPlusIn(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 = 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusPlusPlusZero(double expression){
		return new Range( 0.0, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) >= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 < -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1 <= (2)
/(1) <= 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusPlusMinusIn(double expression){
		return new Range( -1.0, expression, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  (2)/(1)
 > 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ǡ
* եξ1ޤ4ݸ¡١ξ1ޤ2ݸ  0<= 
(2)/(1)
 <= 1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusMinusPlusIn(double expression){
		return new Range( 0.0, expression, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  (2)/(1)
 < -1
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ǡ
* եξ2ޤ3ݸ¡١ξ3ޤ4ݸ  -1 <= (2)
/(1) <= 0
* ΤȤοꤷ֤֤ޤ
* @param expression (2) / (1)
* @return ꤷ
*/
	private Range calPresumptionMinusMinusMinusIn(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* ꤷޤ
* @param preSequence ꤹ
* @exception DisagreementSequenceSizeException ǤꤵƤޥȥ
SequenceΥפʤ
*/
	public void setSequence(Sequence preSequence){
		if(isSameSize(matrix, preSequence)){
			series.sequenceCopy(preSequence);
		}
		else{
			throw new DisagreementSequenceSizeException();
		}
	}
	
/**
* ܥޥȥꥯꤷޤ
* @param graph ꤹܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤ

*/
	private void setGraph(ArithmeticMatrix graph){
		if(graph.isSquare()){
			matrix.matrixCopy(graph);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ݸ¤ϰϤåޤ
* @param k Ĵ٤ݸ
* @return ϰϤǤ true
*/
	private boolean inQuadrant(int k){
		return 1 <= k && k <= 4;
	}
	
/**
* ܤ餽λǽܤ֤ޤ
* ̤ϥǿ(۹ܤʤ)boolean֤ޤ
* ܼȤ true Ȥ֤ޤ
* @param item 
* @return ̤
* @exception NotItemException ꤷܤ¸ߤʤä
*/
    public boolean[] getReachElement(int item){
	if(matrix.isRowNumber(item)){
	    return super.getReachElement(getItemReachMatrix(item, 
matrix.getReachMatrix()));
	}
	else{
	    throw new NotItemException("item("+ item+")");
	}
    }

/**   
* ܤ餽λǽܤ֤ޤ
* ̤ϥǿ(۹ܤʤ)int֤ޤ
* @param item 
* @return ̤
* @exception NotItemException ꤷܤ¸ߤʤä
*/

    public int[] getIntReachElement(int item){
	if(matrix.isRowNumber(item)){
	    return 
super.getIntReachElement(getItemReachMatrix(item,matrix.getReachMatrix()));
	}
	else{
	    throw new NotItemException("item("+item+")");
	}
    }
    /**/
    public int countReachElement(int item){
	if(matrix.isRowNumber(item)){
	    return super.countReachElement(getItemReachMatrix(item, 
matrix.getReachMatrix()));
	}
	else{
	    throw new NotItemException("item("+item+")");
	}
    }
  
/**
* ãޥȥꥯꤷܤβãޥȥꥯι¤
֤ޤ
* ܤꤷϻꤷãޥȥꥯƱΤ֤
ޤ
* @param item 
* @param reachMatrix ãޥȥꥯ
* @return ¤Ѥãޥȥꥯ
* @exception NotItemException ꤷܤ¸ߤʤä
*/
	private ArithmeticMatrix getItemReachMatrix(int item, ArithmeticMatrix 
reachMatrix){
		if(matrix.isRowNumber(item)){
			for(int i = 0; series.getItem(i) != item && i < 
reachMatrix.getRowLength(); i++){
			
				//¤
				for(int j = 0; j < reachMatrix.getColLength(); j++){
					reachMatrix.setCell(series.getItem(i), j, 0);
				}
			}
			
			return reachMatrix;
		}
		else{
			throw new NotItemException("item("+ item+")");
		}
	}
/**
* ܤǽܤδطäƤ뤫åޤ
* @param v 
* @param vi ǽ
* @return ط true
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	private boolean isNomalChoice(int v, int vi){
		if(matrix.isRowNumber(v)){
			if(matrix.isRowNumber(vi)){
				boolean[] el = new boolean[series.getLength()];
				
				//ǽܤäƤ
				System.arraycopy(getReachElement(v), 0, el, 0, series.getLength());
				
				return el[vi];
			}
			else{
				throw new NotItemException("vi("+ vi+")");
			}
		}
		else{
				throw new NotItemException("v("+ v+")");
		}
	}
	
/**
* ꤷܥޥȥꥯSequenceΥפ뤫åޤ
* @param mat ܥޥȥꥯ
* @param seq ꤷSequence
* @return פ true
*/
	private boolean isSameSize(ArithmeticMatrix mat, Sequence seq){
		return mat.getRowLength() == seq.getLength() && mat.getColLength() == 
seq.getLength();
	}

/**
*ꤵ줿󤫤餹Ǥ򤵤줿ܤboolean֤ޤ
*@param number Ĵֹ
*@param returnArray Ǥ򤵤줿
*/
    private boolean[] choicedItem(int number){
	boolean[] returnArray = new boolean[series.getLength()];
	int x = choicedCount(number);
	int[] choiced = new int[x];
	if(number==0){
	    for(int i=0; i<series.getLength(); i++){
		returnArray[i] = false;
	    } 
	}
	else{
	    for(int i=0; i<number; i++){
		choiced[i] = (series.getItem(i));
	    }	
	    
	    for(int i=0; i<series.getLength(); i++){
		int count = 0;
		for(int j=0; j<number; j++){
		    if(i == choiced[j]){
			count++;
		    }
		}
		
		if(count == 1){
		    returnArray[i] = true; 
		}
		else{
		    returnArray[i] = false;
		}
	    }
	}
	return returnArray;
    }
/**
*ꤵ줿󤫤줹Ǥ򤵤줿ܤθĿint֤ޤ
*@param number Ĵֹ
*@return count Ŀ
*/ 

    private int choicedCount(int number){
	int count = 0;	
	if(number==0){
	    count=0;
	}
	else{
	    for(int i=0; i<number; i++){
		count++;
	    }
	}
	return count;
    }
}
