package jp.ac.takushoku_u.cs;

/**
* SSGraphPoint饹SSդκɸ뤿Υ饹Ǥ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0301
*/
public class SSGraphPoint{
	
/**
* ܥޥȥꥯ
*/
	private BooleanMatrix matrix;
	
/**
* ãޥȥꥯ
*/
	private BooleanMatrix reachMatrix;
	
/**
* ٥(ʿɾ)
*/
	private double maxLevel;
	
/**
* ǿ
*/
	private int elementNumber;
	
/**
* ֥٥(ǿ)
*/
	private int[] paintLevel;
	
/**
* ļ
*/
	private double[] heigthNumber;
	
/**
* 
*/
	private int[] paintNumber;
	
/**
* (ϥ٥)
*/
	private int[] paintWide;
	
/**
* Ʊ٥Ǥ
*/
	private int[] paintWideNumber;
	
/**
* Ǥx,yɸ
*/
	private int[][] paintPoint;
	
/**
* 褹Ǥ礭
*/
	private int elementSize = 20;
	
/**
* 褹Ȥ1֥å礭
*/
	private int blockSize = 50;
	
/**
* ե졼Υ(y)
*/
	private int flameSize = 700;
	
	
/**
* ǤΤʤȥޥȥꥯꤷޤ
*/
	public SSGraphPoint(){
		BooleanMatrix mat = new BooleanMatrix();
		setMatrix(mat);
	}
	
/**
* ȥޥȥꥯꤷ־ޤ
* @param skeletonMatrix ȥޥȥꥯ
* @param maxValue ɾκ
* @param heightArray դ¤ؤ
* @param averageArray դνļ(ʿɾ)
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(BooleanMatrix skeletonMatrix, double maxValue, int[] heightArray, double[] averageArray){
		setMatrix(skeletonMatrix);
		setAverageArray(averageArray);
		setHeightArray(heightArray);
		setMaxValue(maxValue);
	}
	
/**
* ȥޥȥꥯꤷ־ޤ
* @param skeletonMatrix ȥޥȥꥯ
* @param maxValue ɾκ
* @param heightArray դ¤ؤ
* @param averageArray դνļ(ʿɾ)
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(ArithmeticMatrix skeletonMatrix, double maxValue, int[] heightArray, double[] averageArray){
		setMatrix(skeletonMatrix.toBooleanMatrix());
		setAverageArray(averageArray);
		setHeightArray(heightArray);
		setMaxValue(maxValue);
	}
	
/**
* ȥޥȥꥯꤷ־ޤ
* @param skeletonMatrix ȥޥȥꥯ
* @param maxValue ɾκ
* @param averageArray դνļ(ʿɾ)
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(BooleanMatrix skeletonMatrix, double maxValue, double[] averageArray){
		setMatrix(skeletonMatrix);
		setAverageArray(averageArray);
		setHeightArray(getGraphArray(averageArray));
		setMaxValue(maxValue);
	}
	
/**
* ȥޥȥꥯꤷ־ޤ
* @param skeletonMatrix ȥޥȥꥯ
* @param maxValue ɾκ
* @param averageArray դνļ(ʿɾ)
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(ArithmeticMatrix skeletonMatrix, double maxValue, double[] averageArray){
		setMatrix(skeletonMatrix.toBooleanMatrix());
		setAverageArray(averageArray);
		setHeightArray(getGraphArray(averageArray));
		setMaxValue(maxValue);
	}

	
/**
* դݤγǤΥ٥Ȥ֤ޤ
* @return ٥Ǽ(礭Ԥܿ)
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//ν
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		boolean flag = true;
		
		//٥Ǽ
		int level = 0;
		int count = 0;
		for(int i = 0; i < returnArray.length; i++){
			int lookElement = paintNumber[i];
			returnArray[lookElement] = level;
			
			//Ʊ٥ǤʤС
			//Ǥãޤܿ
			if(count == 0){
				for(int j = i + 1; j < returnArray.length; j++){
					if(matrix.getCell(paintNumber[j] , lookElement)){
						count++;
					}
				}
				level++;
				count--;
			}
			else if(i < returnArray.length-1 &&(!matrix.getCell(paintNumber[i+1],paintNumber[i]) ||
				(matrix.getCell(paintNumber[i+1],paintNumber[i])&&matrix.getCell(paintNumber[i],paintNumber[i+1])))){
				count--;
			}
		}
		
		//롼Ȥΰ֤ѹ
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int countA = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(countA < returnArray[j]){
							countA = returnArray[j];
						}
					}
				}
				returnArray[i] = countA - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* ɤ֤뤫ɸ(x,y)ꤷ֤ޤ
* @return ɸꤷ
*/
	public int[][] getPointArray(){
		paintLevel = new int[elementNumber];
		System.arraycopy(getPaintLevel(), 0, paintLevel, 0, elementNumber);
		getPaintWide();
		getPaintWideNumber();
		int maxWide = getColMaxLevel(paintLevel);
		
		int center = (maxWide+1) * blockSize / 2;
		
		//ƥ٥Ǵǿ򥫥Ȥޤ
		int[] countArray = new int [getRowMaxLevel(getPaintLevel())+1];
		
		//󥿥
		for(int i = 0; i <= getRowMaxLevel(getPaintLevel()); i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		//yɸδֳ
			double interval;
			
			//ʿɾͤδֳ֤ޤ
			if(getRowMaxLevel(getPaintLevel()) <= flameSize - blockSize){
				interval = (flameSize - blockSize*2) / maxLevel;
			}
			else{
				interval = maxLevel / (flameSize - blockSize*2);
			}
		
		
		//Ǥxɸyɸޤ
		for(int i = 0; i < elementNumber; i++){
			//
			if(paintWide[paintLevel[i]] % 2 == 0){
				if(paintWideNumber[i] > paintWide[paintLevel[i]] / 2){
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i] + 1) * blockSize;
				}
				else{
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i]) * blockSize;
				}
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i]) * blockSize;
			}
			
			
			//yɸ
			paintPoint[i][1] = (int)((flameSize - blockSize)- heigthNumber[i] * interval);
				
		}
		
		//yɸ᤹ܶ
		for(int i = 0; i < paintPoint.length; i++){
			for(int j = 0; j < paintPoint.length; j++){
				if(i != j && paintPoint[j][1] >= paintPoint[i][1] &&
				paintPoint[j][1] <= paintPoint[i][1] + elementSize && paintPoint[j][0] == paintPoint[i][0]){
					paintPoint[j][0] = paintPoint[i][0] + blockSize / 2;
					
				}
			}
		}
		
		return paintPoint;
	}
	
/**
* ȥޥȥꥯꤷޤ
* @param skeletonMatrix ȥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
*/
	public void setMatrix(BooleanMatrix skeletonMatrix){
		if(skeletonMatrix.isSquare()){
			matrix = new BooleanMatrix();
			reachMatrix = new BooleanMatrix();
			matrix.matrixCopy(skeletonMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			elementNumber = skeletonMatrix.getRowLength();
			paintPoint = new int[elementNumber][2];
		}
		else{
			throw new NotSquareMatrixException("row("+ skeletonMatrix.getRowLength() +
				"),col("+skeletonMatrix.getColLength()+")");
		}
	}
	
/**
* ɾ(դνļκ)ꤷޤ
* ꤵƤƹܤʿɾͤ㤤ͤꤵ줿硢
* ɾͤȤʤޤ
* @param max ɾ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
*/
	public void setMaxValue(double max){
		maxLevel = max;
		double maxValue = max;
		for(int i = 0; i < heigthNumber.length; i++){
			if(heigthNumber[i] > max){
				maxValue = heigthNumber[i];
			}
		}
	}
	
/**
* ƹܤʿɾ(ļ)ꤷޤ
* @param averageArray ʿɾ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public void setAverageArray(double[] averageArray){
		if(matrix.getRowLength() == averageArray.length){
			heigthNumber = new double[averageArray.length];
			System.arraycopy(averageArray, 0, heigthNumber, 0, averageArray.length);
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+averageArray.length+")");
		}
	}
	
/**
* ܤ򥰥դ¤ؤꤷޤ
* @param heightArray դ˹ܤ¤ؤ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
*/
	public void setHeightArray(int[] heightArray){
		if(matrix.getRowLength() == heightArray.length){
			paintNumber = new int[heightArray.length];
			System.arraycopy(heightArray, 0, paintNumber, 0, heightArray.length);
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
			"),array("+heightArray.length+")");
		}
	}
	
/**
* ꤵ줿ļ󤫤ޤ
* @param averageArray ļ
* @return Ǥ夫˹ֹ¤ؤ
*/
	private int[] getGraphArray(double[] averageArray){
		int[] returnArray = new int[matrix.getColLength()];		//ʿɾͤι⤤¤٤ֹʹܡˤ
		
		for (int i = 0; i < averageArray.length; i++){
			double maxAverage = averageArray[0];		//
			int maxNumber = 0;
			for (int j = 1; j <  averageArray.length; j++){		//ӤԤ
				if (maxAverage < averageArray[j]){
					maxAverage = averageArray[j];
					maxNumber = j;
				}
			}
			averageArray[maxNumber] = Double.NEGATIVE_INFINITY;	 //оݤϤ
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}
	
/**
* 粣õޤ
* @param levelArray ٥뤬ä
* @return 粣
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* ƥ٥ǤֽȤ֤ޤ
* @return ֽǼ
*/
	private int[] getWidePointArray(){
		int[] levelArray = new int[matrix.getRowLength()];
		System.arraycopy(getPaintLevel(), 0, levelArray, 0, matrix.getRowLength());
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* ٥õޤ
* @param levelArray ٥뤬ä
* @return ٥
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ꤷ٥βõޤ
* @param level ꤹ٥
* @param levelArray ٥뤬ä
* @return 
*/
	private int getColLevel(int level, int[] levelArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level){
				count++;
			}
		}
		
		return count;
	}
	
/**
* դݤƱ٥ǤΰֹȤ֤ޤ
* ͤΤۤɡΥ٥ǤϺԤޤ
* @return ֤Ǽ(礭Ԥܿ)
*/
	public int[] getPaintWideNumber(){
		paintWideNumber = new int[elementNumber];
		System.arraycopy(getWidePointArray(), 0, paintWideNumber, 0, elementNumber);
		return paintWideNumber;
	}
	
/**
* ƥ٥βݻ֤ޤ
* @return 
*/
	public int[] getPaintWide(){
		paintWide = new int[getRowMaxLevel(getPaintLevel())+1];
			for(int i = 0; i <= getRowMaxLevel(getPaintLevel()); i++){
				paintWide[i] = getColLevel(i, getPaintLevel());
		}
		return paintWide;
	}
	
}