
package jp.ac.takushoku_u.cs;
import java.util.Set;
import java.util.Iterator;
import java.util.TreeSet;

/**
* LFTAnalysis饹LFTʬϤԤΥ饹Ǥ<BR>
* ޤΥ饹Ѥܥޥȥꥯˤޤν٤䥰մ֤١١оݤǽ硢ͭ޽硢Ǥνн뤳ȤǤޤ
* @version 1.4.1
* @author ϸ (Kawahara Shinji)
*/
/*
* ǽ 2005ǯ1107
*/
public class LFTAnalysis{
	
/**
* ԤΥޥȥꥯݻޥȥꥯ
*/
	private BooleanMatrix teacherMatrix;
	
/**
* ؽԤΥޥȥꥯݻޥȥꥯ
*/
	private BooleanMatrix studentMatrix;
	
/**
* ͭޤɽ
*/
	private static final int LFT_EDGE_INT_TRUE = 1;
	
/**
* ͭޤɽ
*/
	private static final boolean LFT_EDGE_TRUE = true;
	
/**
* ͭޤɽ
*/
	private static final String LFT_EDGE_STRING_TRUE = "1";
	
/**
* ͭޤʤɽ
*/
	private static final int LFT_EDGE_INT_FALSE = 0;
	
/**
* ͭޤʤɽ
*/
	private static final boolean LFT_EDGE_FALSE = false;
	
/**
* ͭޤʤɽ
*/
	private static final String LFT_EDGE_STRING_FALSE = "0";
	
/**
* ˤޥȥꥯǶԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_EDGE_TEACHER = 3;
	
/**
* ˤޥȥꥯǶԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final String LFT_EDGE_STRING_TEACHER = "T";
	
/**
* ˤޥȥꥯǳؽԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_EDGE_STUDENT = 4;
	
/**
* ˤޥȥꥯǳؽԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final String LFT_EDGE_STRING_STUDENT = "S";
	
/**
* ޥȥꥯΥǥե
*/
        private static final int LFT_MATRIX_VALUE = 5;

/** 
*оݤǤȤоݤ̤ϩǤȤκ٤ɽ
*/
       public static final int LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_VERTEX     = 1;

/**
*оݤǤȤоݤ̤ϩλޤȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_EDGE       = 2;

/**
*оݤǤȤоݤ̤ϩλȽνФȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_ORDERPAIR   = 3;

/**
*оݤޤȤоݤ̤ϩǤȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_VERTEX       = 4;

/**
*оݤޤȤоݤ̤ϩλޤȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_EDGE	    = 5;

/**
*оݤޤȤоݤ̤ϩλȽνФȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_ORDERPAIR  = 6;
        
/**
*оݤǤνФȤоݤ̤ϩǤȤκ٤ɽ
*/
	public static final int LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_VERTEX   = 7;
       
/**
* оݤǤνФȤоݤ̤ϩλޤȤκ٤ɽ
*/	
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_EDGE    = 8;

/**
*оݤǤνФȤоݤ̤ϩλȽνФȤκ٤ɽ
*/
        public static final int LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_ORDERPAIR = 9;
        
/**
* оݤˤƲãǤ뤳Ȥɽ
*/
        public static final int LFT_PREVIOUS_STANDARD   = 0;

/**
* оݤˤԤȤʤ뤳Ȥɽ
*/
        public static final int LFT_REACHABLE_STANDARD = 1;
        
/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷޤ<BR>
* ԤȳؽξΥޥȥꥯǤ0Ȥʤޤ
*/
        public LFTAnalysis(){
        	BooleanMatrix baseTeacherMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
        	BooleanMatrix baseStudentMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		
        	//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix);
		
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param TeacherMatrix ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(BooleanMatrix TeacherMatrix){
		BooleanMatrix StudentMatrix =
		new BooleanMatrix(TeacherMatrix.getRowLength(), TeacherMatrix.getColLength(),
			TeacherMatrix.getRowNameArray(), TeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(TeacherMatrix);
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(StudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(BooleanMatrix baseTeacherMatrix, BooleanMatrix baseStudentMatrix){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix);
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param TeacherMatrix ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(ArithmeticMatrix TeacherMatrix){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(TeacherMatrix.getRowLength(), TeacherMatrix.getColLength(),
			TeacherMatrix.getRowNameArray(), TeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(TeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param TeacherMatrix ԤΥޥȥꥯ
* @param StudentMatrix ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(ArithmeticMatrix TeacherMatrix, ArithmeticMatrix StudentMatrix){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(TeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(StudentMatrix.toBooleanMatrix());
	}
	
/**
* BooleanѴݤΤͤȶԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param TeacherMatrix ԤΥޥȥꥯ
* @param value BooleanMatrixѴݤΤ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(ArithmeticMatrix TeacherMatrix, double value){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(TeacherMatrix.getRowLength(), TeacherMatrix.getColLength(),
			TeacherMatrix.getRowNameArray(), TeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(TeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(baseStudentMatrix);
	}
	
/**
* BooleanѴݤΤͤȶԤΥޥȥꥯؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param TeacherMatrix ԤΥޥȥꥯ
* @param StudentMatrix ؽԤΥޥȥꥯ
* @param value BooleanMatrixѴݤΤ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(ArithmeticMatrix TeacherMatrix, ArithmeticMatrix StudentMatrix, double value){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(TeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setMatrixOfStudent(StudentMatrix.toBooleanMatrix());
	}

/**
*ܥޥȥꥯ򸵤ˡvjоݤȤvjˤԤޤϲãǤͭޤνޤ
*@param Matrix Ĵ٤ܥޥȥꥯ
*@param vj оݤȤ
*@param LFT_SET_STANDARD ɽ
*@return vjоݤȤͭޤԤޤϲã
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public EdgeSet getEdgeSet(BooleanMatrix matrix, Vertex vj,int LFT_STANDARD){
    	if(matrix.isSquare()){
    		int lft = LFT_STANDARD;
    		if(lft == 0){	
				//ãޥȥꥯ
				BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),matrix.getRowNameArray(), matrix.getColNameArray());
				lookMatrix.matrixCopy(matrix.getReachMatrix());
				
				EdgeSet edgeHash = new EdgeSet();
				int v = vj.getVertex();
				int x = 0;	  
				for(int i=0; i<lookMatrix.getRowLength(); i++){
					for(int j=0; j<lookMatrix.getColLength(); j++){
						if(lookMatrix.getCell(i, v) == LFT_EDGE_FALSE){
							lookMatrix.setCell(i,j,false);
						}
					}
				}
				for(int i=0; i<lookMatrix.getRowLength(); i++){
					for(int j=0; j<lookMatrix.getColLength(); j++){
						if(lookMatrix.getCell(i, v) == LFT_EDGE_FALSE){
							lookMatrix.setCell(j,i,false);
						}
					}
				}
	    
				for(int i=0; i<lookMatrix.getRowLength(); i++){
					if(lookMatrix.getCell(i,v) == LFT_EDGE_FALSE){
						lookMatrix.setCell(v,i,false);
					}
				}		   
				//ܥޥȥꥯȲãޥȥꥯޤ
				for(int i=0; i<lookMatrix.getRowLength(); i++){
					for(int j=0; j<lookMatrix.getColLength(); j++){
						if(matrix.getCell(i,j) && lookMatrix.getCell(i,j) == LFT_EDGE_TRUE){
							edgeHash.add(new Edge(i,j));
						} 
					}
				}
				return edgeHash;
    		}
    		
    		else if(lft==1){
				//ãޥȥꥯ
				BooleanMatrix look2Matrix = new BooleanMatrix(matrix.getRowLength(),matrix.getColLength(),matrix.getRowNameArray(),matrix.getColNameArray());
				look2Matrix.matrixCopy(matrix.getReachMatrix());
    
				EdgeSet edge2Hash = new EdgeSet();
				int v2 = vj.getVertex();
				for(int i=0; i<look2Matrix.getColLength(); i++){
					for(int j=0; j<look2Matrix.getRowLength(); j++){
						if(look2Matrix.getCell(v2,i) == LFT_EDGE_FALSE){
							look2Matrix.setCell(i,j,false);
						}
					}
				}    	    
				for(int i=0; i<look2Matrix.getRowLength(); i++){
					for(int j=0; j<look2Matrix.getColLength(); j++){
						if(look2Matrix.getCell(i,j) && matrix.getCell(i,j) == LFT_EDGE_TRUE){
							edge2Hash.add(new Edge(i,j));
						}
					}	
				}
				return edge2Hash;
				
			}
    	}
    	else{
    		throw new NotSquareMatrixException();
    	}
		return null;
    }
	//	return null;
    


    
    
    
    
    
/**
*ܥޥȥꥯ򸵤ˡͭedоݤȤedˤԤޤϲãǤͭޤνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param ed оݤȤͭ
*@param LFT_STANDARD ɽ
*@return ͭޤоݤȤͭޤν
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public EdgeSet getEdgeSet(BooleanMatrix matrix, Edge ed, int LFT_STANDARD){
    	if(matrix.isSquare()){
    		int lft = LFT_STANDARD;
    		if(lft == 0){
    			EdgeSet edgeHash = new EdgeSet();
    			if(matrix.getCell(ed.getBegin(), ed.getEnd()) == LFT_EDGE_TRUE){
    				edgeHash = getEdgeSet(matrix, new Vertex(ed.getEnd()),1);		
    			}
    			return edgeHash;	    
    		}
    		else if(lft == 1){	
    			EdgeSet edHash = new EdgeSet();
    			if(matrix.getCell(ed.getBegin(), ed.getEnd()) == LFT_EDGE_TRUE){
    				edHash = getEdgeSet(matrix,new Vertex(ed.getBegin()),0);
    			}
    			return edHash;
    		}
    	}

    	else{
    		throw new NotSquareMatrixException();
    	}
		return null;
    }
    
    

/**
*ܥޥȥꥯ򸵤ˤǤ̲᤹ϩν˴ޤޤͭޤνޤ
*@param baseMatrix Ĵ٤ܥޥȥꥯ
*@param vi ̲᤹
*@return ϩν˴ޤޤޤν
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    private EdgeSet passElementGetEdgeSet(BooleanMatrix baseMatrix, Vertex vi){
       	if(baseMatrix.isSquare()){
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(baseMatrix.getRowLength(),baseMatrix.getColLength(),baseMatrix.getRowNameArray(),baseMatrix.getColNameArray());
	    lookMatrix.matrixCopy(baseMatrix.getReachMatrix());
	    
	    EdgeSet edgeHash = new EdgeSet();
	    int v = vi.getVertex();
	    int count1 = 0;
	    int count2 = 0;
	    for(int i=0; i<baseMatrix.getRowLength(); i++){
		for(int j=0; j<baseMatrix.getColLength(); j++){
		    if(baseMatrix.getCell(i,v) == LFT_EDGE_TRUE){
			count1++;
			if(v!=j){
			    baseMatrix.setCell(i,j,false);
			}
		    }	
		}
	    }
	    for(int i=0; i<baseMatrix.getRowLength(); i++){
		for(int j=0; j<baseMatrix.getColLength(); j++){
		    if(baseMatrix.getCell(v,i) == LFT_EDGE_TRUE){
			count2++;
			if(v!=j){
			    baseMatrix.setCell(j,i,false);
			}
		    }
		}
	    }
	    if(count1>0 && count2>0){
		for(int i=0; i<lookMatrix.getRowLength(); i++){
		    for(int j=0; j<lookMatrix.getColLength(); j++){
			if(lookMatrix.getCell(i,j) && baseMatrix.getCell(i,j) == LFT_EDGE_TRUE){
			    edgeHash.add(new Edge(i,j));
			}
		    }
		}
	    }     	
	    return edgeHash;
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }

/**
*ܥޥȥꥯ򸵤ˡоݤvjȤvjˤԤޤϲãǤǤνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param vj оݤȤʤ
*@param LFT_STANDARD ɽ
*@exception NotSquareMatrixException ꤷޥȥꥯǤʤ
*/
    public VertexSet getVertexSet(BooleanMatrix matrix, Vertex vj, int LFT_STANDARD){
    	if(matrix.isSquare()){
    		int lft = LFT_STANDARD;
    		if(lft == 0){
    			//ãޥȥꥯ
    			BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(),matrix.getColLength(),matrix.getRowNameArray(),matrix.getColNameArray());
    			lookMatrix.matrixCopy(matrix.getReachMatrix());
	    
    			VertexSet treeSet = new VertexSet();
    			int v = vj.getVertex();
    			for(int i=0; i<lookMatrix.getRowLength(); i++){
    				if(lookMatrix.getCell(i,v) == LFT_EDGE_TRUE){
    					if(i!=v){
    						treeSet.add(new Vertex(i));
    					}
    				}
    			}
    			return treeSet;
    		}
    		else if(lft == 1){
    			//ãޥȥꥯ
    			BooleanMatrix look2Matrix = new BooleanMatrix(matrix.getRowLength(),matrix.getColLength(),matrix.getRowNameArray(),matrix.getColNameArray());
    			look2Matrix.matrixCopy(matrix.getReachMatrix());
	   
    			VertexSet ptreeSet = new VertexSet();
    			int v1 = vj.getVertex();
    			for(int i=0; i<look2Matrix.getRowLength(); i++){
    				if(look2Matrix.getCell(v1,i) == LFT_EDGE_TRUE){
    					if(i!=v1){
    						ptreeSet.add(new Vertex(i));
    					}
    				}
    			}
    			return ptreeSet;
    		}
    	}
    	else{
    		throw new NotSquareMatrixException();
    	}
		return null;
    }
    
    
    
    
    
    
/**
*ܥޥȥꥯ򸵤ˡоݤͭedȤedˤԤޤϲãǤǤνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param ed оݤȤͭ
*@param LFT_STANDARD ɽ
*@return ͭޤоݤȤϩ˴ޤޤǤν
*@exception NotSquareMatrixException ꤷޥȥꥯǤʤ
*/ 
    public VertexSet getVertexSet(BooleanMatrix matrix, Edge ed, int LFT_STANDARD){
    	if(matrix.isSquare()){
    		int lft = LFT_STANDARD;
    		if(lft == 0){
    			VertexSet treeSet = new VertexSet();
    			if(matrix.getCell(ed.getBegin(), ed.getEnd()) == LFT_EDGE_TRUE){
    				treeSet = getVertexSet(matrix,new Vertex(ed.getBegin()),0);
    			}
    			return treeSet;
    		}
       	
    		else if(lft == 1){
    			VertexSet ptreeSet = new VertexSet();
    			if(matrix.getCell(ed.getBegin(), ed.getEnd()) == LFT_EDGE_TRUE){
    				ptreeSet = getVertexSet(matrix, new Vertex(ed.getEnd()),1);
    			}
    			return ptreeSet;
    		}
    	}
    	else{
    		throw new NotSquareMatrixException();
    	}
		return null;
    }

/**
*ܥޥȥꥯ򸵤ˡǤνopоݤȤopηϩν˴ޤޤǤνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param op оݤȤ
*@return ǤνФ˴ޤޤǤν
*@exception  NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public VertexSet getVertexSet(BooleanMatrix matrix, OrderPair op){
	if(matrix.isSquare()){
	    VertexSet treeSet = new VertexSet();
	    VertexSet iSet = new VertexSet();
	    VertexSet jSet = new VertexSet();
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(), matrix.getColNameArray());
	    lookMatrix.matrixCopy(matrix.getReachMatrix());
	    
	    if(lookMatrix.getCell(op.getBegin(), op.getEnd()) == LFT_EDGE_TRUE){
		for(int i=0; i<lookMatrix.getColLength(); i++){
		    if(lookMatrix.getCell(op.getBegin(), i) == LFT_EDGE_TRUE){
			iSet.add(new Double(i));
		    }   			
		}
		for(int j=0; j<lookMatrix.getRowLength(); j++){
		    if(lookMatrix.getCell(j, op.getEnd()) == LFT_EDGE_TRUE){
			jSet.add(new Double(j));
		    }
		}
		Iterator it = jSet.iterator();
		while(it.hasNext()){
		    Double dy = (Double)it.next();
		    if(iSet.contains(dy) == true){
			treeSet.add(dy);
		    }
		}
		treeSet.remove(new Double(op.getBegin()));
		treeSet.remove(new Double(op.getEnd()));
	    }	
	    return treeSet;
       	}
       	else{
	    throw new NotSquareMatrixException();
       	}
    }
       
/**
*ܥޥȥꥯ򸵤ˡvkоݤȤvk̲᤹ϩν˴ޤޤǤνޤ
*@param nextMatrix Ĵ٤ܥޥȥꥯ
*@param vk ͭޤ̲
*@return ϩν˴ޤޤǤν
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    private Set passElementGetElementSet(BooleanMatrix nextMatrix, int vk){
       	if(nextMatrix.isSquare()){
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(nextMatrix.getRowLength(),nextMatrix.getColLength(),nextMatrix.getRowNameArray(),nextMatrix.getColNameArray());
	    lookMatrix.matrixCopy(nextMatrix.getReachMatrix());
	    Set treeSet = new TreeSet();
	    int v = vk;
	    int count1 = 0;
	    int count2 = 0;
	    for(int i=0; i<lookMatrix.getRowLength(); i++){
		if(lookMatrix.getCell(v,i) == LFT_EDGE_TRUE){
		    treeSet.add(new Double(i));  						
		    if(v!=i){
			count1++;
		    }
		}
	    }
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(i,v) == LFT_EDGE_TRUE){
		    treeSet.add(new Double(i)); 
		    if(v!=i){
			count2++;
		    }
		}
	    }
	    if(count1==0 || count2==0){
		treeSet.clear();
	    }
	    return treeSet;
       	}
       	else{
	    throw new NotSquareMatrixException();
       	}
    }
       
/**
*ܥޥȥꥯ򸵤ˡvоݤȤv̲᤹ǤνФνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param vͭޤ̲
*@return v̲᤹Ǥνн
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/       
    public OrderPairSet getOrderPairSet(BooleanMatrix matrix, Vertex v){
       	if(matrix.isSquare()){
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(),matrix.getColLength(),matrix.getRowNameArray(),matrix.getColNameArray());
	    lookMatrix.matrixCopy(matrix.getReachMatrix());
	    int vk = v.getVertex();
	    OrderPairSet edgeHash = new OrderPairSet();
	    int count1=0;
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(vk,i) == LFT_EDGE_TRUE){
		    if(vk!=i){
			count1++;	       		
		    }
		}
	    }
	    int[] cou1 = new int[count1];        		
	    
	    int x=0;   
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(vk,i) == LFT_EDGE_TRUE){
		    if(vk!=i){
			cou1[x] = i;
			x++;
		    }
		}
	    }
       
	    int count2=0;
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(i,vk) == LFT_EDGE_TRUE){
		    if(vk!=i){
			count2++;	       					
		    }
		}
	    }
	    int[] cou2 = new int[count2];        		
	    
	    int y=0;   
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(i,vk) == LFT_EDGE_TRUE){
		    if(vk!=i){
			cou2[y] = i;
			y++;
		    }
		}
	    }
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(vk,i)==true){
		    if(i!=vk){
			edgeHash.add(new Edge(vk,i));
		    }
		}
	    }
	    for(int j=0; j<lookMatrix.getRowLength(); j++){
		if(lookMatrix.getCell(j,vk) == true){
		    if(j!=vk){
			edgeHash.add(new Edge(j,vk));
		    }
		}
	    }

	    for(int i=0; i<count1; i++){
		for(int j=0; j<count2; j++){
		    edgeHash.add(new Edge(cou1[i],cou2[j]));
		}
	    }     		
	    return edgeHash;
       	}
       	else{
	    throw new NotSquareMatrixException();
       	}
    }
       
/**
*ܥޥȥꥯ򸵤ˡǤνopоݤȤopηϩ˴ޤޤͭޤνޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param op оݤȤǤν
*@return ϩ˴ޤޤͭޤν 
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public EdgeSet getEdgeSet(BooleanMatrix matrix, OrderPair op){
       	if(matrix.isSquare()){
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(), matrix.getColNameArray());
	    lookMatrix.matrixCopy(matrix.getReachMatrix());
       	    
	    EdgeSet edgeHash = new EdgeSet();
	    //λ޽
	    for(int j=0; j<lookMatrix.getColLength(); j++){
		if(lookMatrix.getCell(op.getBegin(),j) == LFT_EDGE_FALSE){
		    for(int s=0; s<lookMatrix.getColLength(); s++){
			lookMatrix.setCell(j,s,false);
		    }
		}
	    }
	    //λ޽
	    for(int j=0; j<lookMatrix.getColLength(); j++){
		if(lookMatrix.getCell(op.getEnd(),j) == LFT_EDGE_TRUE){
		    for(int s=0; s<lookMatrix.getColLength(); s++){
			lookMatrix.setCell(j,s,false);
		    }
		}
	    }
	    for(int i=0; i<lookMatrix.getRowLength(); i++){
		if(lookMatrix.getCell(i,op.getEnd()) == LFT_EDGE_FALSE){
		    if(i!=op.getEnd()){
			for(int s=0; s<lookMatrix.getColLength(); s++){
			    lookMatrix.setCell(i,s,false);
			    lookMatrix.setCell(s,i,false);
			}
		    }
		}
	    }
	    //ޤ¸ߤ뤫ɤ
	    for(int i=0; i<matrix.getRowLength(); i++){
		for(int j=0; j<matrix.getColLength(); j++){
		    if(matrix.getCell(i,j) && lookMatrix.getCell(i,j) == LFT_EDGE_TRUE){ 
			edgeHash.add(new Edge(i,j));
		    }
		}
	    }
	    return edgeHash;
       	}
       	else{
	    throw new NotSquareMatrixException();
       	}
    }       

/**ܥޥȥꥯ򸵤ˡǤνopоݤȤopηϩ˴ޤޤǤνнޤ
*@param matrix Ĵ٤ܥޥȥꥯ
*@param op оݤȤǤν
*@return ϩ˴ޤޤǤνн(O<vivj>) 
*@exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public OrderPairSet getOrderPairSet(BooleanMatrix matrix, OrderPair op){
	if(matrix.isSquare()){
	    
	    //ãޥȥꥯ
	    BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(), matrix.getColNameArray());
	    lookMatrix.matrixCopy(matrix.getReachMatrix());
	    
	    OrderPairSet edgeHash = new OrderPairSet();
	    
	    //
	    for(int j=0; j<lookMatrix.getColLength(); j++){
		if(lookMatrix.getCell(op.getBegin(),j) == LFT_EDGE_FALSE){
		    for(int s=0; s<lookMatrix.getColLength(); s++){
			lookMatrix.setCell(j,s,false);
			lookMatrix.setCell(s,j,false);
		    }
		}
	    }
	    //
	    for(int i=0; i<lookMatrix.getColLength(); i++){
		if(lookMatrix.getCell(i,op.getEnd()) == LFT_EDGE_FALSE){
		    for(int s=0; s<lookMatrix.getColLength(); s++){
			lookMatrix.setCell(i,s,false);
			lookMatrix.setCell(s,i,false);
		    }
		}
		lookMatrix.setCell(op.getEnd(),i,false);
	    }
	    
	    for(int i=0; i<lookMatrix.getRowLength(); i++){
		for(int j=0; j<lookMatrix.getColLength(); j++){
		    if(i==j){
			lookMatrix.setCell(i,j,false);
		    }
		}
	    }
	    
	    for(int i=0; i<lookMatrix.getRowLength(); i++){
		for(int j=0; j<lookMatrix.getColLength(); j++){
		    if(lookMatrix.getCell(i,j) == LFT_EDGE_TRUE){ 
			edgeHash.add(new Edge(i,j));
		    }
		}
	    }
	    return edgeHash;
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }         
       
/**ꤷоݤȴˤƤκ٤֤ޤ
*@param LFT_DIFFERENCE_INDEX оݤȴɽ
*@return 
*/
    public double getDifferenceIndex(int LFT_DIFFERENCE_INDEX){
    	int lft = LFT_DIFFERENCE_INDEX;
    	if(lft == LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_VERTEX){
    		lft = LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_EDGE;
    	}
    	if(lft == LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_VERTEX){
    		lft = LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_ORDERPAIR; 	    		
    	}
    	
    	
    	switch(lft)
		{    	
		case LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_VERTEX:
			double denominator = 0.0; //ʬ
			double numerator = 0.0; //ʬ
			VertexSet teach1Set = new VertexSet();
			VertexSet stude1Set = new VertexSet();
			VertexSet teach2Set = new VertexSet();
			VertexSet stude2Set = new VertexSet();
			VertexSet in1Set = new VertexSet();
			VertexSet out1Set = new VertexSet();
			VertexSet in2Set = new VertexSet();
			VertexSet out2Set = new VertexSet();
	
			for(int i=0; i<teacherMatrix.getRowLength(); i++){
				double ns = 0;
				double ds = 0;
				teach1Set = getVertexSet(teacherMatrix, new Vertex(i),  0);
				stude1Set = getVertexSet(studentMatrix, new Vertex(i),  0);
				teach2Set = getVertexSet(teacherMatrix, new Vertex(i),  1);
				stude2Set = getVertexSet(studentMatrix, new Vertex(i),  1);
				//ʬ
				in1Set = nablaSet(teach1Set,stude1Set);
				out1Set = nablaSet(teach2Set,stude2Set);
				ns = (double)orSetSize(in1Set, out1Set);
				numerator = ns + numerator;
				//ʬ
				in2Set = orSet(teach1Set, stude1Set);
				out2Set = orSet(teach2Set, stude2Set);
				ds = (double)orSetSize(in2Set, out2Set);
	 
				denominator = ds + denominator;
				teach1Set.clear();
				stude1Set.clear();
				teach2Set.clear();
				stude2Set.clear();
				in1Set.clear();
				out1Set.clear();
				in2Set.clear();
				out2Set.clear();
			}
			return numerator/denominator;
    
   
	 
			
		case LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_EDGE: 	
			double denominator2 = 0.0; //ʬ
			double numerator2 = 0.0; //ʬ
			EdgeSet teach21Set = new EdgeSet();
			EdgeSet stude21Set = new EdgeSet();
			EdgeSet in21Set = new EdgeSet();
			EdgeSet teach22Set = new EdgeSet();
			EdgeSet stude22Set = new EdgeSet();
			EdgeSet out21Set = new EdgeSet();
			EdgeSet in22Set = new EdgeSet();
			EdgeSet out22Set = new EdgeSet();
	
			for(int i=0; i<teacherMatrix.getRowLength(); i++){
				double ns = 0;
				double ds = 0;
				//ʬ
				teach21Set = getEdgeSet(teacherMatrix, new Vertex(i),0);
				stude21Set = getEdgeSet(studentMatrix, new Vertex(i),0);
				in21Set = nablaEdgeSet(teach21Set, stude21Set);
				teach22Set = getEdgeSet(teacherMatrix, new Vertex(i),1);
				stude22Set = getEdgeSet(studentMatrix, new Vertex(i),1);
				out21Set = nablaEdgeSet(teach22Set, stude22Set);
				ns = (double)orEdgeSetSize(in21Set,out21Set);
				numerator2 = ns + numerator2;	
				//ʬ
				in22Set = orEdgeSet(teach21Set, stude21Set);
				out22Set = orEdgeSet(teach22Set, stude22Set);
	    
				ds = (double)orEdgeSetSize(in22Set,out22Set);		
				denominator2 = ds + denominator2;			
				teach21Set.clear();
				teach22Set.clear();
				stude21Set.clear();
				stude22Set.clear();
				in21Set.clear();
				out21Set.clear();
				in22Set.clear();
				out22Set.clear();			
			}	
			return numerator2/denominator2;
			
			
			
			
		case LFT_DIFFERENCE_INDEX_OBJECT_VERTEX_STANDARD_ORDERPAIR: 	
			double denominator3 = 0.0; //ʬ
			double numerator3 = 0.0; //ʬ
			OrderPairSet tedge = new OrderPairSet();
			OrderPairSet sedge = new OrderPairSet();
			OrderPairSet sameedge = new OrderPairSet(); 
			
			for(int i=0; i<teacherMatrix.getRowLength(); i++){
				double t = 0;
				double s = 0;
				double ts = 0;       
				double nume = 0;
				double deno = 0;
				Vertex ver = new Vertex(i);
				tedge = getOrderPairSet(teacherMatrix, ver);
				sedge = getOrderPairSet(studentMatrix, ver);
				t = tedge.size();
				s = sedge.size();	
		    
				Iterator ite = sedge.iterator();
				while(ite.hasNext()){
					Edge ed = (Edge)ite.next(); 
					if(tedge.contains(ed) == true){
						sameedge.add(ed);
					}
				}
				ts = sameedge.size();
				nume = t - ts + s - ts;
				numerator3 = nume + numerator3;
				deno = t + s -ts;
				denominator3 = deno + denominator3;
				tedge.clear();
				sedge.clear();
				sameedge.clear(); 
	       		}
			return numerator3/denominator3;
		
	
		
		
		
		case LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_EDGE:
			double denominator5 = 0.0; //ʬ
	       	double numerator5 = 0.0; //ʬ
	     	EdgeSet teach51Set = new EdgeSet();
	       	EdgeSet stude51Set = new EdgeSet();
	       	EdgeSet teach52Set = new EdgeSet();
	       	EdgeSet stude52Set = new EdgeSet();
	       	EdgeSet in51Set = new EdgeSet();
	       	EdgeSet out51Set = new EdgeSet();
	       	EdgeSet in52Set = new EdgeSet();
	       	EdgeSet out52Set = new EdgeSet();
	       	
	       	for(int i=0; i<teacherMatrix.getRowLength(); i++){
	       		for(int j=0; j<teacherMatrix.getRowLength(); j++){
	       			double ns = 0;	
	       			double ds = 0;
	       			teach51Set = getEdgeSet(teacherMatrix, new Edge(i,j),0);
	       			stude51Set = getEdgeSet(studentMatrix, new Edge(i,j),0);
	       			teach52Set = getEdgeSet(teacherMatrix, new Edge(i,j),1);
	       			stude52Set = getEdgeSet(studentMatrix, new Edge(i,j),1);
	       			//ʬ
	       			in51Set = nablaEdgeSet(teach51Set, stude51Set);
	       			out51Set = nablaEdgeSet(teach52Set, stude52Set);
	       			ns = (double)orEdgeSetSize(in51Set, out51Set);
	       			//ʬ
	       			in52Set = orEdgeSet(teach51Set, stude51Set);
	       			out52Set = orEdgeSet(teach52Set, stude52Set);
	       			ds = (double)orEdgeSetSize(in52Set, out52Set);
	       			numerator5 = ns + numerator5;
	       			denominator5 = ds + denominator5;
	       			teach51Set.clear();
	       			teach52Set.clear();
	       			stude51Set.clear();
	       			stude52Set.clear();
	       			in51Set.clear();
	       			in52Set.clear();
	       			out51Set.clear();
	       			out52Set.clear();
	       		}
	       	}
	       	return numerator5/denominator5;	
			
			
			
	       	
		case LFT_DIFFERENCE_INDEX_OBJECT_EDGE_STANDARD_ORDERPAIR:
			double denominator6 = 0.0; //ʬ 
			double numerator6 = 0.0; //ʬ
			EdgeSet teach6Set = new EdgeSet();
			EdgeSet stude6Set = new EdgeSet();
			for(int i=0; i<teacherMatrix.getRowLength(); i++){
			    for(int j=0; j<teacherMatrix.getRowLength(); j++){
			    	double ns = 0;	
			    	double ds = 0;
			    	teach6Set = getVertexPairSet(teacherMatrix, i, j);
			    	stude6Set = getVertexPairSet(studentMatrix, i, j);
			    	//ʬ
			    	ns = (double)nablaEdgeSetSize(teach6Set, stude6Set);
			    	//ʬ
			    	ds = (double)orEdgeSetSize(teach6Set, stude6Set);
			    	numerator6 = ns + numerator6;
			    	denominator6 = ds + denominator6;
			    	teach6Set.clear();
			    	stude6Set.clear();
			    }
			}
			return numerator6/denominator6;
			
			
			
					
		case LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_EDGE:
			double denominator8 = 0.0; //ʬ 
			double numerator8 = 0.0;  //ʬ
		       	EdgeSet teach8Set = new EdgeSet();
		       	EdgeSet stude8Set = new EdgeSet();
		       	
		       	for(int i=0; i<teacherMatrix.getRowLength(); i++){
		       		for(int j=0; j<teacherMatrix.getRowLength(); j++){
		       			double ns = 0;	
		       			double ds = 0;
		       			//ʬ
		       			teach8Set = getEdgeSet(teacherMatrix, new OrderPair(i,j));
		       			stude8Set = getEdgeSet(studentMatrix, new OrderPair(i,j));
		       			ns = (double)nablaEdgeSetSize(teach8Set, stude8Set);		
		       			//ʬ
		       			ds = (double)orEdgeSetSize(teach8Set, stude8Set);
				
		       			numerator8 = ns + numerator8;
		       			denominator8 = ds + denominator8;
		       			teach8Set.clear();
		       			stude8Set.clear();
		       		}
		       	}
		       	return numerator8/denominator8;
		
		       	
		       	
		       	
		case LFT_DIFFERENCE_INDEX_OBJECT_ORDERPAIR_STANDARD_ORDERPAIR:
		 	double denominator9 = 0.0; //ʬ
	       	double numerator9 = 0.0; //ʬ
	       	OrderPairSet teach9Set = new OrderPairSet();
	       	OrderPairSet stude9Set = new OrderPairSet();
		for(int i=0; i<teacherMatrix.getRowLength(); i++){
		    for(int j=0; j<teacherMatrix.getRowLength(); j++){
			double ns = 0;	
			double ds = 0;
			//ʬ
			teach9Set = getOrderPairSet(teacherMatrix, new OrderPair(i,j));
			stude9Set = getOrderPairSet(studentMatrix, new OrderPair(i,j));
			ns = (double)nablaOrderPairSetSize(teach9Set, stude9Set);		
			//ʬ
			ds = (double)orOrderPairSetSize(teach9Set, stude9Set);
			
			numerator9 = ns + numerator9;
			denominator9 = ds + denominator9;
			teach9Set.clear();
			stude9Set.clear();
		    }
	       	}
	       	return numerator9/denominator9;
		
		}
		return LFT_DIFFERENCE_INDEX;
	 }

/**쥯SetбƤ2Ĥν礫Set֤ޤ  
*@return ν       
*/     
    private VertexSet nablaSet(VertexSet teacherSet, VertexSet studentSet){
	VertexSet sameSet = new VertexSet();
	Iterator it = teacherSet.iterator();
	while(it.hasNext()){
	    Vertex dy = (Vertex)it.next();
	    if(studentSet.contains(dy) == true){
		sameSet.add(dy);
	    }
	    studentSet.add(dy);
	}
	studentSet.removeAll(sameSet);
	return studentSet;
    }
          
/**쥯SetбƤ2Ĥν礫nabla礭֤ޤ
*@return ླྀΥ
*/ 
    private int nablaSetSize(VertexSet teacherSet, VertexSet studentSet){
      	int size = 0;
      	Set nablaSet = new TreeSet();
      	nablaSet = nablaSet(teacherSet, studentSet);
      	size = nablaSet.size();
      	return size;
    }
      
/**쥯SetбƤ룲Ĥν礫orSet֤ޤ
*@return orν
*/       
    private VertexSet orSet(VertexSet beforeSet, VertexSet afterSet){
      	Iterator ite = beforeSet.iterator();
      	while(ite.hasNext()){
	    Vertex dy = (Vertex)ite.next();
	    afterSet.add(dy);
      	}
      	return afterSet;
    }
      
/**쥯SetбƤ룲Ĥν礫¤礭֤ޤ 
*@return orΥ
*/       
    private int orSetSize(VertexSet beforeSet, VertexSet afterSet){
      	int size = 0;
      	Set orSet = new TreeSet();
      	orSet = orSet(beforeSet, afterSet);
      	size = orSet.size();
      	return size;
    }
   
/**EdgeSetбƤ2Ĥν礫Set֤ޤ
*@return ν
*/  
    private EdgeSet nablaEdgeSet(EdgeSet teacherSet, EdgeSet studentSet){
	EdgeSet sameEdgeSet = new EdgeSet();
	Iterator it = teacherSet.iterator();
	while(it.hasNext()){
	    Edge ed = (Edge)it.next();
	    if(studentSet.contains(ed) == true){
		sameEdgeSet.add(ed);
	    }
	    studentSet.add(ed);
	}
	Iterator it2 = sameEdgeSet.iterator();
	while(it2.hasNext()){
	    Edge ed = (Edge)it2.next();
	    studentSet.remove(ed);
	}
	return studentSet;
    }
      
/**EdgeSetбƤ2Ĥν礫礭֤ޤ
*@return ླྀΥ
*/ 
    private int nablaEdgeSetSize(EdgeSet teacherEdgeSet, EdgeSet studentEdgeSet){
      	int size = 0;
      	EdgeSet lEdgeSet = new EdgeSet();
      	lEdgeSet = nablaEdgeSet(teacherEdgeSet, studentEdgeSet);
      	size = lEdgeSet.size();
      	return size;
    }
/**EdgeSetбƤ룲Ĥν礫orSet֤ޤ
*@return orν
*/       
    private EdgeSet orEdgeSet(EdgeSet beforeEdgeSet, EdgeSet afterEdgeSet){
      	Iterator ite = beforeEdgeSet.iterator();
      	while(ite.hasNext()){
	    Edge ed = (Edge)ite.next();
	    afterEdgeSet.add(ed);
      	}
      	return afterEdgeSet;
    }
      
/**EdgeSetбƤ룲Ĥν礫¤礭֤ޤ 
*@return orΥ
*/       
    private int orEdgeSetSize(EdgeSet beforeEdgeSet, EdgeSet afterEdgeSet){
      	int size = 0;
      	EdgeSet oEdgeSet = new EdgeSet();
      	oEdgeSet = orEdgeSet(beforeEdgeSet, afterEdgeSet);
      	size = oEdgeSet.size();
      	return size;
    }
	
    
    
    /**OrderPairSetбƤ2Ĥν礫Set֤ޤ
    *@return ν
    */  
        private OrderPairSet nablaOrderPairSet(OrderPairSet teacherSet, OrderPairSet studentSet){
    	OrderPairSet sameEdgeSet = new OrderPairSet();
    	Iterator it = teacherSet.iterator();
    	while(it.hasNext()){
    	    Edge op = (Edge)it.next();
    	    if(studentSet.contains(op) == true){
    		sameEdgeSet.add(op);
    	    }
    	    studentSet.add(op);
    	}    	
    	Iterator it2 = sameEdgeSet.iterator();
    	while(it2.hasNext()){
    	    Edge ed = (Edge)it2.next();
    	    studentSet.remove(ed);
    	}
    	return studentSet;
        }
          
    /**OrderPairSetбƤ2Ĥν礫礭֤ޤ
    *@return ླྀΥ
    */ 
        private int nablaOrderPairSetSize(OrderPairSet teacherEdgeSet, OrderPairSet studentEdgeSet){
          	int size = 0;
          	OrderPairSet lEdgeSet = new OrderPairSet();
          	lEdgeSet = nablaOrderPairSet(teacherEdgeSet, studentEdgeSet);
          	size = lEdgeSet.size();
          	return size;
        }
    /**OrderPairSetбƤ룲Ĥν礫orSet֤ޤ
    *@return orν
    */       
        private OrderPairSet orOrderPairSet(OrderPairSet beforeEdgeSet, OrderPairSet afterEdgeSet){
          	Iterator ite = beforeEdgeSet.iterator();
          	while(ite.hasNext()){
    	    Edge ed = (Edge)ite.next();
    	    afterEdgeSet.add(ed);
          	}
          	return afterEdgeSet;
        }
          
    /**OrderPairSetбƤ룲Ĥν礫¤礭֤ޤ 
    *@return orΥ
    */       
        private int orOrderPairSetSize(OrderPairSet beforeEdgeSet, OrderPairSet afterEdgeSet){
          	int size = 0;
          	OrderPairSet oEdgeSet = new OrderPairSet();
          	oEdgeSet = orOrderPairSet(beforeEdgeSet, afterEdgeSet);
          	size = oEdgeSet.size();
          	return size;
        }  
    
    
    
/**
* ٤֤ޤ
* @return 
*/
    public double getSimilarityIndex(){
	double denominator = 0.0; //ʬ(OR)
	double numerator = 0.0; //ʬ(AND)
	
	//Фޥȥꥯ
	BooleanMatrix pairTeacherMatrix = new BooleanMatrix(getVertexCount(), getVertexCount());
	BooleanMatrix pairStudentMatrix = new BooleanMatrix(getVertexCount(), getVertexCount());
	
	//ãޥȥꥯ
	BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
	reachTeacherMatrix.matrixCopy(getReachableMatrixOfTeacher());
	BooleanMatrix reachStudentMatrix = new BooleanMatrix();
	reachStudentMatrix.matrixCopy(getReachableMatrixOfStudent());
	
	//׻ǻѤޥȥꥯ
	BooleanMatrix resultMatrix = new BooleanMatrix(getVertexCount(), getVertexCount());
	for (int i = 0; i < getVertexCount(); i++){
	    for (int j = 0; j < getVertexCount(); j++){
		
		//ԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
		if (teacherMatrix.getCell(i, j) == true){
		    pairTeacherMatrix.matrixCopy(getPairMatrix(reachTeacherMatrix, i, j));
		}
		
		//ޤʤн϶
		else{
		    pairTeacherMatrix.clearMatrix();
		}
		
		//ؽԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
		if (studentMatrix.getCell(i, j) == true){
		    pairStudentMatrix.matrixCopy(getPairMatrix(reachStudentMatrix, i, j));
		}
		
		//ޤʤн϶
		else{
		    pairStudentMatrix.clearMatrix();
		}
		
		//ʬη׻
		resultMatrix.matrixCopy(pairTeacherMatrix.getOrMatrix(pairStudentMatrix));
		denominator = resultMatrix.getElement() + denominator;
		
		//ʬҤη׻
		resultMatrix.matrixCopy(pairTeacherMatrix.getAndMatrix(pairStudentMatrix));
		numerator = resultMatrix.getElement() + numerator;
	    }
	}
	
	return numerator / denominator;
    }
	
/**
* ã٤֤ޤ
* @return ã
*/
    public double getAttainmentIndex(){
	return Math.sqrt(getSimilarityIndex()) * 100;
    }
    
/**
* 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ޤξ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getBlendMatrix()
*/
    private int getBlendEdge(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik){
	if(baseMatrix.isSquare() && compareMatrix.isSquare()){
	    if (baseMatrix.isSameMatrixSize(compareMatrix)){
		int value;
		if (baseMatrix.isMatrixEntityPoint(Ij, Ik) && compareMatrix.isMatrixEntityPoint(Ij, Ik)){
		    if (baseMatrix.getCell(Ij, Ik) == compareMatrix.getCell(Ij, Ik)){
			if(baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
			    value = LFT_EDGE_INT_TRUE;
			}
			else{
			    value = LFT_EDGE_INT_FALSE;
			}
		    }
		    else if (baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE &&
			     compareMatrix.getCell(Ij, Ik) == LFT_EDGE_FALSE){
			value = LFT_EDGE_TEACHER;
		    }
		    else{
			value = LFT_EDGE_STUDENT;
		    }
		    return value;
		}
		else{
		    throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	    }
	    else{
		throw new DisagreementMatrixSizeException();
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤT
* ؽԤΥޥȥꥯΤߤ˻ޤSޤ
* @param matrix1 ӸΥޥȥꥯ
* @param matrix2 Ӥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ޤξ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getBlendStringMatrix()
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
    public String getStateOfEdge(BooleanMatrix matrix1, BooleanMatrix matrix2, int Ij, int Ik){
	if(matrix1.isSquare() && matrix2.isSquare()){
	    if (matrix1.isSameMatrixSize(matrix2)){
		String st;
		if (matrix1.isMatrixEntityPoint(Ij, Ik) && matrix2.isMatrixEntityPoint(Ij, Ik)){
		    if (matrix1.getCell(Ij,Ik) == matrix2.getCell(Ij, Ik)){
			if(matrix1.getCell(Ij,Ik) == LFT_EDGE_TRUE){
			    st = LFT_EDGE_STRING_TRUE;
			}
			else{
			    st = LFT_EDGE_STRING_FALSE;
			}
		    }
		    else if (matrix1.getCell(Ij,Ik) == LFT_EDGE_TRUE &&
			     matrix2.getCell(Ij,Ik) == LFT_EDGE_FALSE){
			st = LFT_EDGE_STRING_TEACHER;
		    }
		    else{
			st = LFT_EDGE_STRING_STUDENT;
		    }
		    return st;
		}
		else{
		    throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	    }
	    else{
		throw new DisagreementMatrixSizeException();
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
    
    /**
    * 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
    * ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤT
    * ؽԤΥޥȥꥯΤߤ˻ޤSޤ
    * @param matrix1 ӸΥޥȥꥯ
    * @param matrix2 Ӥޥȥꥯ
    * @param v1 ͭޤλ
    * @param v2 ͭޤν
    * @return ޤξ
    * @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
    * @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
    * @exception NotElementException ꤷֹ椬¸ߤʤ
    * @see #getBlendStringMatrix()
    * @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
    */
        public String getStateOfEdge(BooleanMatrix matrix1, BooleanMatrix matrix2, Vertex v1, Vertex v2){
    int Ij = v1.getVertex(v1);
    int Ik = v2.getVertex(v2);
        	if(matrix1.isSquare() && matrix2.isSquare()){
    	    if (matrix1.isSameMatrixSize(matrix2)){
    		String st;
    		if (matrix1.isMatrixEntityPoint(Ij, Ik) && matrix2.isMatrixEntityPoint(Ij, Ik)){
    		    if (matrix1.getCell(Ij,Ik) == matrix2.getCell(Ij, Ik)){
    			if(matrix1.getCell(Ij,Ik) == LFT_EDGE_TRUE){
    			    st = LFT_EDGE_STRING_TRUE;
    			}
    			else{
    			    st = LFT_EDGE_STRING_FALSE;
    			}
    		    }
    		    else if (matrix1.getCell(Ij,Ik) == LFT_EDGE_TRUE &&
    			     matrix2.getCell(Ij,Ik) == LFT_EDGE_FALSE){
    			st = LFT_EDGE_STRING_TEACHER;
    		    }
    		    else{
    			st = LFT_EDGE_STRING_STUDENT;
    		    }
    		    return st;
    		}
    		else{
    		    throw new NotElementException("point(" + Ij + "," + Ik + ")");
    		}
    	    }
    	    else{
    		throw new DisagreementMatrixSizeException();
    	    }
    	}
    	else{
    	    throw new NotSquareMatrixException();
    	}
        }
    
/**
* ꤷ2Ĥܥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1baseMatrixǻꤷޥȥꥯΤߤ˻ޤ3
* compareMatrixǻꤷޥȥꥯˤΤߤ˻ޤ4ޤ
* ˤޥȥꥯι̾̾baseMatrixǻꤷޥȥꥯƱˤʤޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @return ˤޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
*/
    private ArithmeticMatrix getBlendMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix){
	if(baseMatrix.isSquare() && compareMatrix.isSquare()){
	    if (baseMatrix.isSameMatrixSize(compareMatrix)){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getVertexCount(), getVertexCount(),
								     baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
		
		for (int i = 0; i < getVertexCount(); i++){
		    for (int j = 0; j < getVertexCount(); j++){
			returnMatrix.setCell(i, j, getBlendEdge(baseMatrix, compareMatrix, i ,j));
		    }
		}
		return returnMatrix;
	    }
	    else{
		throw new DisagreementMatrixSizeException();
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ꤷ2Ĥܥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1baseMatrixǻꤷޥȥꥯΤߤ˻ޤT
* compareMatrixǻꤷޥȥꥯˤΤߤ˻ޤSޤ
* ˤޥȥꥯι̾̾baseMatrixǻꤷޥȥꥯƱˤʤޤ
* @param matrix1 ӸΥޥȥꥯ
* @param matrix2 Ӥޥȥꥯ
* @return ˤޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix()
*/
    public StringMatrix getStateOfEdgeStringMatrix(BooleanMatrix matrix1, BooleanMatrix matrix2){
	if(matrix1.isSquare() && matrix2.isSquare()){
	    if (matrix1.isSameMatrixSize(matrix2)){
		StringMatrix returnMatrix = new StringMatrix(getVertexCount(), getVertexCount(),
							     matrix1.getRowNameArray(), matrix1.getColNameArray());
		
		for (int i = 0; i < getVertexCount(); i++){
		    for (int j = 0; j < getVertexCount(); j++){
			returnMatrix.setCell(i, j, getStateOfEdge(matrix1, matrix2, i, j));
		    }
		}
		return returnMatrix;
	    }
	    else{
		throw new DisagreementMatrixSizeException();
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* ˤޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @return ˤޥȥꥯ
*/
    private ArithmeticMatrix getBlendMatrix(){
	return getBlendMatrix(teacherMatrix, studentMatrix);
    }
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤT
* ؽԤΥޥȥꥯΤߤ˻ޤSޤ
* ˤޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @return ˤޥȥꥯ
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
    public StringMatrix getStateOfEdgeStringMatrix(){
	return getStateOfEdgeStringMatrix(teacherMatrix, studentMatrix);
    }
	
/**
* ܥޥȥꥯ򸵤ˤǴ֤нޤ
* @param matrix Ĵ٤ܥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ɤǴ֤Фޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
    private BooleanMatrix getVertexPairMatrix(BooleanMatrix matrix, int Ij, int Ik){
	if(matrix.isSquare()){
	    if (matrix.isMatrixEntityPoint(Ij, Ik)){
		
		//ãޥȥꥯ
		BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),
							     matrix.getRowNameArray(), matrix.getColNameArray());
		lookMatrix.matrixCopy(matrix.getReachMatrix());
		
		BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(), lookMatrix.getColLength(), 
							       lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
		
		//ޤ¸ߤ뤫ɤ
		if (matrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
		    returnMatrix.matrixCopy(getPairMatrix(lookMatrix, Ij, Ik));
		}
		return returnMatrix;
	    }
	    else{
		throw new NotElementException("point(" + Ij + "," + Ik + ")");
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ܥޥȥꥯ򸵤ˤǴ֤нޤ
* @param matrix Ĵ٤ܥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return нȤʤޤν
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
    public OrderPairSet getOrderPairSet(BooleanMatrix matrix,Edge ed){
    	OrderPairSet o = new OrderPairSet();
    	return o;
    }
    
    private EdgeSet getVertexPairSet(BooleanMatrix matrix, int Ij, int Ik){
	if(matrix.isSquare()){
	    if (matrix.isMatrixEntityPoint(Ij, Ik)){
		
		//ãޥȥꥯ
		BooleanMatrix lookMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),
							     matrix.getRowNameArray(), matrix.getColNameArray());
		lookMatrix.matrixCopy(matrix.getReachMatrix());
		
		EdgeSet edgeHash = new EdgeSet();
		
		//ޤ¸ߤ뤫ɤ
		if (matrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
		    for (int i = 0; i < lookMatrix.getRowLength(); i++){
			for (int j = 0; j < lookMatrix.getColLength(); j++){
			    if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
				edgeHash.add(new Edge(i,j));
			    }
			}
		    }
		}
		return edgeHash;
	    }
	    else{
		throw new NotElementException("point(" + Ij + "," + Ik + ")");
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ãޥȥꥯ򸵤ˤǴ֤нޤ<BR>
* ܥޥȥꥯΤ١2Ǵ֤ܤƤ뤫ݾڤʤᡢ
* Υ᥽åɤѤϤǴƱΤܤƤ뤳Ȥåɬפޤ
* @param lookMatrix Ĵ٤ãޥȥꥯ
* @param Ij ͭޤθֹ
* @param Ik ͭޤֹ
* @return ɤǴ֤Фޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
    private BooleanMatrix getPairMatrix(BooleanMatrix lookMatrix, int Ij, int Ik){
	if(lookMatrix.isSquare()){
	    if (lookMatrix.isMatrixEntityPoint(Ij, Ik)){
		BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(),lookMatrix.getColLength(), 
							       lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
		for (int i = 0; i < lookMatrix.getRowLength(); i++){
		    for (int j = 0; j < lookMatrix.getColLength(); j++){
			if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
			    returnMatrix.setCell(i, j, LFT_EDGE_TRUE);
			}
			else{
			    returnMatrix.setCell(i, j, LFT_EDGE_FALSE);
			}
		    }
		}
		return returnMatrix;
	    }
	    else{
		throw new NotElementException("point(" + Ij + "," + Ik + ")");
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ޥȥꥯ¸ߤޤν٤ޤ
* @param matrix ٤оݤܥޥȥꥯ
* @return ޤν٤Ǽޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public ArithmeticMatrix getImportantEdgeMatrix(BooleanMatrix matrix){
	if(matrix.isSquare()){
	    ArithmeticMatrix returnMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
								 matrix.getRowNameArray(), matrix.getColNameArray());
	    
	    for (int i = 0;i < matrix.getRowLength(); i++){
		for (int j = 0; j < matrix.getColLength(); j++){
		    returnMatrix.setCell(i, j, getImportantIndex(matrix, i, j));
		}
	    }
	    return returnMatrix;
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ޥȥꥯ2ܴ֤λޤν٤֤ޤ
* @param matrix ٤ޥȥꥯ
* @param Ij ͭޤλȤʤIj
* @param Ik ͭޤνȤʤIk
* @return ꤷܴ֤ν
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
    public double getImportantIndex(BooleanMatrix matrix, int Ij, int Ik){
	if(matrix.isSquare()){
	    BooleanMatrix temporaryMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength());
	    double cont = Math.floor(getVertexCount() / 2) * Math.floor((getVertexCount() + 1) / 2);
	    double value = 0.0;
	    
	    //ޤ¸ߤ뤫ɤ
	    if (matrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
		temporaryMatrix.matrixCopy(getVertexPairMatrix(matrix, Ij, Ik));
		value = temporaryMatrix.getElement();
		value = value / cont;
	    }
	    return value;
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
    /**
    * ޥȥꥯ2ܴ֤λޤν٤֤ޤ
    * @param matrix ٤ޥȥꥯ
    * @param ed ͭ
    * @return ꤷܴ֤ν
    * @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
    */
        public double getImportantIndex(BooleanMatrix matrix, Edge ed){
        	int Ij = ed.getBegin();
        	int Ik = ed.getEnd();
    	if(matrix.isSquare()){
    	    BooleanMatrix temporaryMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength());
    	    double cont = Math.floor(getVertexCount() / 2) * Math.floor((getVertexCount() + 1) / 2);
    	    double value = 0.0;
    	    
    	    //ޤ¸ߤ뤫ɤ
    	    if (matrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
    		temporaryMatrix.matrixCopy(getVertexPairMatrix(matrix, Ij, Ik));
    		value = temporaryMatrix.getElement();
    		value = value / cont;
    	    }
    	    return value;
    	}
    	else{
    	    throw new NotSquareMatrixException();
    	}
        }
    
    
/**
* ԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getImportantEdgeStudent(int Ij, int Ik)
* @see #getEdgeTeacherMatrix()
*/
    public double getImportantEdgeTeacher(int Ij, int Ik){
	if (teacherMatrix.isMatrixEntityPoint(Ij, Ik)){
	    return getImportantIndex(teacherMatrix, Ij, Ik);
	}
	else{
	    throw new NotElementException("point(" + Ij + "," + Ik + ")");
	}
    }
	
    /**
    * ԤΥޥȥꥯˤꤷޤν٤֤ޤ
    * @param ed ͭ
    * @return 
    * @exception NotElementException ꤷֹ椬¸ߤʤ
    * @see #getImportantEdgeStudent(int Ij, int Ik)
    * @see #getEdgeTeacherMatrix()
    */
        public double getImportantEdgeTeacher(Edge ed){
        	int Ij = ed.getBegin();
        	int Ik = ed.getEnd();
    	if (teacherMatrix.isMatrixEntityPoint(Ij, Ik)){
    	    return getImportantIndex(teacherMatrix, Ij, Ik);
    	}
    	else{
    	    throw new NotElementException("point(" + Ij + "," + Ik + ")");
    	}
        }  
    
/**
* Ԥλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
    public ArithmeticMatrix getImportantIndexOfTeacher(){
	return getImportantEdgeMatrix(teacherMatrix);
    }
	
/**
* ؽԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getEdgeTeacherMatrix()
* @see #getImportantEdgeStudent(int Ij, int Ik)
*/
    public double getImportantEdgeStudent(int Ij, int Ik){
	if (studentMatrix.isMatrixEntityPoint(Ij, Ik)){
	    return getImportantIndex(studentMatrix, Ij, Ik);
	}
	else{
	    throw new NotElementException("point(" + Ij + "," + Ik + ")");
	}
    }
    
    /**
    * ؽԤΥޥȥꥯˤꤷޤν٤֤ޤ
    * @param ed ͭ
    * @return 
    * @exception NotElementException ꤷֹ椬¸ߤʤ
    * @see #getEdgeTeacherMatrix()
    * @see #getImportantEdgeStudent(int Ij, int Ik)
    */
        public double getImportantEdgeStudent(Edge ed){
        	int Ij = ed.getBegin();
        	int Ik = ed.getEnd();
    	if (studentMatrix.isMatrixEntityPoint(Ij, Ik)){
    	    return getImportantIndex(studentMatrix, Ij, Ik);
    	}
    	else{
    	    throw new NotElementException("point(" + Ij + "," + Ik + ")");
    	}
        }   
	
/**
* ؽԤλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
    public ArithmeticMatrix getImportantIndexOfStudent(){
	return getImportantEdgeMatrix(studentMatrix);
    }
	
/**
* Ԥܥޥȥꥯ֤ޤ
* @return ԤΥޥȥꥯ
* @see #getAdjacencyMatrixOfStudent()
*/
    public BooleanMatrix getAdjancencyMatrixOfTeacher(){
	return teacherMatrix;
    }
	
/**
* ؽԤܥޥȥꥯ֤ޤ
* @return ؽԤΥޥȥꥯ
* @see #getAdjacencyMatrixOfTeacher()
*/
    public BooleanMatrix getAdjacencyMatrixOfStudent(){
	return studentMatrix;
    }
	
/**
* Ԥβãޥȥꥯ֤ޤ
* @return Ԥβãޥȥꥯ
* @see #getReachableMatrixOfStudent()
*/
    public BooleanMatrix getReachableMatrixOfTeacher(){
	BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
	reachTeacherMatrix.matrixCopy(teacherMatrix.getReachMatrix());
	return reachTeacherMatrix;
    }
	
/**
* ؽԤβãޥȥꥯ֤ޤ
* @return ؽԤβãޥȥꥯ
* @see #getReachableMatrixOfTeacher()
*/
    public BooleanMatrix getReachableMatrixOfStudent(){
	BooleanMatrix reachStudentMatrix = new BooleanMatrix();
	reachStudentMatrix.matrixCopy(studentMatrix.getReachMatrix());
	return reachStudentMatrix;
    }
	
/**
* ԤΥޥȥꥯˤǿ(Ԥޤ)֤ޤ
* @return ǿ
*/
    public int getVertexCount(){
	return teacherMatrix.getRowLength();
    }
	
/**
* ԤΥޥȥꥯˤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
    public int getEdgeCountOfTeacher(){
	return teacherMatrix.getElement();
    }
	
/**
* ؽԤΥޥȥꥯˤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
    public int getEdgeCountOfStudent(){
	return studentMatrix.getElement();
    }
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯΤɤ餫ˤǤ¸ߤͭޤο֤ޤ
* @return ɤ餫ˤǤ⤢ͭޤο
* @see #getAccordEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
    public int getEitherOneEdgeCount(){
	ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getVertexCount(), getVertexCount());
	mixMatrix.matrixCopy(getBlendMatrix());
	return mixMatrix.getElement();
    }
	
/**
* ԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
    public int getOnlyEdgeCountOfTeacher(){
	int count = 0;
	ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getVertexCount(), getVertexCount());
	mixMatrix.matrixCopy(getBlendMatrix());
	for (int i = 0; i < mixMatrix.getRowLength(); i++){
	    for (int j = 0; j < mixMatrix.getColLength(); j++){
		if (mixMatrix.getCell(i, j) == LFT_EDGE_TEACHER){
		    count = count + 1;
		}
	    }
	}
	return count;
    }
	
/**
* ؽԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
    public int getOnlyEdgeCountOfStudent(){
	int count = 0;
	ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getVertexCount(), getVertexCount());
	mixMatrix.matrixCopy(getBlendMatrix());
	for (int i = 0; i < mixMatrix.getRowLength(); i++){
	    for (int j = 0; j < mixMatrix.getColLength(); j++){
		if (mixMatrix.getCell(i, j) == LFT_EDGE_STUDENT){
		    count = count + 1;
		}
	    }
	}
	return count;
    }
	
/**
* ԤΥޥȥꥯˤؽԤΥޥȥꥯˤ¸ߤͭޤο֤ޤ
* @return ξԤˤͭޤο
* @see #getTotelEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
    public int getAccordEdgeCount(){
	int count = 0;
	ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getVertexCount(), getVertexCount());
	mixMatrix.matrixCopy(getBlendMatrix());
	for (int i = 0; i < mixMatrix.getRowLength(); i++){
	    for (int j = 0; j < mixMatrix.getColLength(); j++){
		if (mixMatrix.getCell(i, j) == LFT_EDGE_INT_TRUE){
		    count = count + 1;
		}
	    }
	}
	return count;
    }
	
/**
* ԤΥޥȥꥯꤷޤ
* @param baseTeacherMatrix 򤹤붵ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
    private void setTeacherMatrix(BooleanMatrix baseTeacherMatrix){
	if (baseTeacherMatrix.isSquare()){
	    teacherMatrix = new BooleanMatrix();
	    teacherMatrix.matrixCopy(baseTeacherMatrix);
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
/**
* ؽԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯǤꡢԤΥޥȥꥯȥפɬפޤ
* @param baseStudentMatrix 򤹤ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
    public void setMatrixOfStudent(BooleanMatrix StudentMatrix){
	if (StudentMatrix.isSquare()){
	    if (teacherMatrix.isSameMatrixSize(StudentMatrix)){
		studentMatrix = new BooleanMatrix();
		studentMatrix.matrixCopy(StudentMatrix);
	    }
	    else{
		throw new DisagreementMatrixSizeException();
	    }
	}
	else{
	    throw new NotSquareMatrixException();
	}
    }
	
}
