package jp.ac.takushoku_u.cs;

/**
* LFGpoint饹LFG褹ݤ֥٥ꤹ륯饹Ǥ
* Ʊ٥ǤֽϡֹξΤ˺֤ޤ
* ΤᡢΥ饹ѤԤäͭޤθ򺹤礬ޤ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0301
*/
public class LFGPoint{
	
/**
* ܥޥȥꥯ
*/
	private BooleanMatrix matrix;
	
/**
* 롼ȤȤ
*/
	private int rootItem = -1;

/**
* ǤΤʤܥޥȥꥯꤷޤ
*/
	public LFGPoint(){
		matrix = new BooleanMatrix();
	}
	
/**
* ܥޥȥꥯ饰դΥ٥(ġ)ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤʤ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ܥޥȥꥯ饰դΥ٥(ġ)ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @param top 롼Ȥ
* @exception NotSquareMatrixException ꤷޥȥꥯǤʤ
* @exception NegativeValueException 롼ȤǤꤷ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix, int top){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			if(top < 0){
				matrix.matrixCopy(adjacencyMatrix);
				top = rootItem;
			}
			else{
				throw new NegativeValueException("top("+top+")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ܥޥȥꥯȽļ󤫤饰դΥ٥Υ롼()ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @param averageArray ļ
* @exception NotSquareMatrixException ꤷޥȥꥯǤʤ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix, double[] averageArray){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			
			double max = Double.NEGATIVE_INFINITY;
			int item = -1;
			for(int i = 0; i < averageArray.length; i++){
				if(averageArray[i] > max){
					max = averageArray[i];
					item = i;
				}
			}
			rootItem = item;
			
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
/**
* դݤΥ٥Ȥ֤ޤ
* @return ٥Ǽ
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//ν
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//롼Ȥ
		if(rootItem == -1){
			for(int i = 0; i < returnArray.length; i++){
				if(matrix.getRowSum(i) == 0){
					returnArray[i] = 0;
				}
			}
		}
		else{
			returnArray[rootItem] = 0;
		}
		
		boolean flag = true;
		
		//٥Ǽ
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//٥뤬ꤷƤʤ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//ޤǤϥ٥뤬ꤷƤ뤫
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//롼Ȥΰ֤ѹ
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* ƥ٥ǤֽȤ֤ޤ
* @return ֽǼ
*/
	public int[] getPaintWideNumber(){
		int[] levelArray = new int[matrix.getRowLength()];
		System.arraycopy(getPaintLevel(), 0, levelArray, 0, matrix.getRowLength());
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* ƥ٥ǤֽȤ֤ޤ
* @param levelArray ٥Ǽ
* @return ֽǼ
*/
	public int[] getPaintWideNumber(int[] levelArray){
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* ٥õޤ
* @param levelArray ٥뤬ä
* @return ٥
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ꤵ줿ļ󤫤ޤ
* @param averageArray ļ
* @return Ǥ夫˹ֹ¤ؤ
*/
	private int[] getGraphArray(double[] averageArray){
		int[] returnArray = new int[matrix.getColLength()];		//ʿɾͤι⤤¤٤ֹʹܡˤ
		
		for (int i = 0; i < averageArray.length; i++){
			double maxAverage = averageArray[0];		//
			int maxNumber = 0;
			for (int j = 1; j <  averageArray.length; j++){		//ӤԤ
				if (maxAverage < averageArray[j]){
					maxAverage = averageArray[j];
					maxNumber = j;
				}
			}
			averageArray[maxNumber] = Double.NEGATIVE_INFINITY;	 //оݤϤ
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}
}