package jp.ac.takushoku_u.cs;


/**
* ClusterAnalysis饹ϥ饹ʬϤ򤹤뤿Υ饹Ǥ<BR>
* 2ĤnޤǤоݤȤ1nޤǤ°ͤ򸵤ʬϤԤޤ
* @version 1.2.1
* @author ϸ (Kawahara Shinji)
*/
/**
*ǽ 2005ǯ1209
*/
public class ClusterAnalysis{

/**
* ʬϤԤǡޥȥꥯ
*/
    private ArithmeticMatrix dataMatrix;

/**
* UPGMA饹ˡɽǤ	
*/    
    public static final int CLUSTERING_UPGMA = 0;
    
/**
* SLINK饹ˡɽǤ
*/
    public static final int CLUSTERING_SLINK = 1;
    
/**
* CLINK饹ˡɽǤ
*/ 
    public static final int CLUSTERING_CLINK = 2;
    
/**
* ٷɽǤ
*/
    public static final int SIMILARITY_COEFFICIENT = 0;
/**
* ٷɽǤ
*/
	public static final int DISSIMILARITY_COEFFICIENT = 1;
	
/**
* ޥȥꥯΥǥե
*/
    private static final int CLUSTER_MATRIX_VALUE = 5;

    private static double max;
    	    
    private final static double MAX_VALUE = max;
    
/**
* ʬϤԤޥȥꥯȤ0оݤꤷޤ
*/
    public ClusterAnalysis(){
	ArithmeticMatrix baseMatrix = new ArithmeticMatrix(CLUSTER_MATRIX_VALUE, CLUSTER_MATRIX_VALUE);
	setMatrix(baseMatrix);
    }	

/**
* оݥǡ򸵤ʬϤԤޥȥꥯꤷޤ<BR>
* @param object ֥ȿ
*/
    public ClusterAnalysis(int object){
    	ArithmeticMatrix baseMatrix = new ArithmeticMatrix(object, CLUSTER_MATRIX_VALUE);
    	setMatrix(baseMatrix);
    }

/**
* 򸵤ʬϤԤޥȥꥯꤷޤ<BR>
* @param matrix ʬϤԤޥȥꥯ
*/
    public ClusterAnalysis(ArithmeticMatrix matrix){
       
	//ǡޥȥꥯꤹ
	setMatrix(matrix);
    }

/**
* ʬϤԤޥȥꥯɸಽԤޤ
* @return ɸಽޥȥꥯ
*/
    public ArithmeticMatrix getStandardizedMatrix(){
    	double[][] element = new double[dataMatrix.getRowLength()][dataMatrix.getColLength()];
    	for(int i=0; i<dataMatrix.getRowLength(); i++){
    		for(int j=0; j<dataMatrix.getColLength(); j++){
    			element[i][j] = getStandard(i, j);
    		}
    	}
    	ArithmeticMatrix mat = new ArithmeticMatrix(element);
    	return mat;
    }
    
/**
* ꤷޥȥꥯɸಽԤޤ
* @param matrix ꤷޥȥꥯ
* @return ɸಽޥȥꥯ
*/
    public ArithmeticMatrix getStandardizedMatrix(ArithmeticMatrix matrix){
    	double[][] element = new double[matrix.getRowLength()][matrix.getColLength()];
    	for(int i=0; i<matrix.getRowLength(); i++){
    		for(int j=0; j<matrix.getColLength(); j++){
    			element[i][j] = getStandard(matrix,i,j);
    		}
    	}
    	ArithmeticMatrix mat = new ArithmeticMatrix(element);
    	return mat;
    }

/**
* ٷޤٷоݤȤ֤ޥȥꥯޤ
* @param RESEMBLANCE_COEFFICIENT 
* @return ޥȥꥯ
*/
    public ArithmeticMatrix getResemblanceMatrix(int RESEMBLANCE_COEFFICIENT){
    	int resem = RESEMBLANCE_COEFFICIENT;
    	ArithmeticMatrix ruiji = new ArithmeticMatrix();
    	if(resem == SIMILARITY_COEFFICIENT){
    		ruiji.matrixCopy(getSimilarityCoefficientMatrix());
    	}
    	if(resem == DISSIMILARITY_COEFFICIENT){
    		ruiji.matrixCopy(getNonResemblanceMatrix());
    	}
    	return ruiji;
    }
    
/**   
* ꤷޥȥꥯ򸵤ˡٷޤٷоݤȤ֤ޥȥꥯޤ
* @param matrix ꤷޥȥꥯ
* @param RESEMBLANCE_COEFFICIENT 
* @return ޥȥꥯ
*/     
    public ArithmeticMatrix getResemblanceMatrix(ArithmeticMatrix matrix, int RESEMBLANCE_COEFFICIENT){
    	int resem = RESEMBLANCE_COEFFICIENT;
    	ArithmeticMatrix ruiji = new ArithmeticMatrix();
    	if(resem == SIMILARITY_COEFFICIENT){
    		ruiji.matrixCopy(getSimilarityCoefficientMatrix(matrix));
    	}
    	if(resem == DISSIMILARITY_COEFFICIENT){
    		ruiji.matrixCopy(getNonResemblanceMatrix(matrix));
    	}
    	return ruiji;
    }
    
/**
* ٷоݤȤߤˤĤ֤ޥȥꥯޤ
* @return ޥȥꥯ
*/
    private ArithmeticMatrix getSimilarityCoefficientMatrix(){
    	ArithmeticMatrix mat = new ArithmeticMatrix(dataMatrix.getColLength(),dataMatrix.getColLength());
    	for(int i=0; i<dataMatrix.getColLength(); i++){
    		for(int j=0; j<dataMatrix.getColLength(); j++){
    			if(i!=j){
    				mat.setCell(i,j,getSimilarityCoefficient(i, j));
    				mat.setCell(j,i,getSimilarityCoefficient(i, j));
    			}
    			else{
    				mat.setCell(i,i,0);
    			}
    		}
    	}
    	return mat;
    }
    
/**
* ꤷޥȥꥯ򸵤ˡٷоݤȤߤˤĤ֤ޥȥꥯޤ
* @param matrix ꤷޥȥꥯ
* @return ޥȥꥯ
*/
    private ArithmeticMatrix getSimilarityCoefficientMatrix(ArithmeticMatrix matrix){
    	ArithmeticMatrix mat = new ArithmeticMatrix(matrix.getColLength(),matrix.getColLength(),matrix.getColNameArray(),matrix.getColNameArray());
        for(int i=0; i<matrix.getColLength(); i++){
        	for(int j=0; j<matrix.getColLength(); j++){
        		if(i!=j){
        			mat.setCell(i,j,getSimilarityCoefficient(matrix, i ,j));
        			mat.setCell(j,i,getSimilarityCoefficient(matrix, i, j));
        		}
        		else{
        			mat.setCell(i, i ,0);
        		}
        	}
        }
        return mat;
        }

/**
* ٷоݤȤߤˤĤ֤ޥȥꥯޤ
* @return ޥȥꥯ
*/
    private ArithmeticMatrix getNonResemblanceMatrix(){
    	ArithmeticMatrix mat = new ArithmeticMatrix(dataMatrix.getColLength(),dataMatrix.getColLength());
    	for(int i=0; i<dataMatrix.getColLength(); i++){
    		for(int j=0; j<dataMatrix.getColLength(); j++){
    			if(i!=j){
    				mat.setCell(i,j,getDissimilarityCoefficient(i, j));
    				mat.setCell(j,i,getDissimilarityCoefficient(i, j));
    			}
    			else{
    				mat.setCell(i,i,0);
    			}
    		}
    	}
    	return mat;
    }
    
/**
* ꤷޥȥꥯ򸵤ˡٷоݤȤߤˤĤ֤ޥȥꥯޤ
* @param matrix ꤷޥȥꥯ
* @return ޥȥꥯ
*/
    private ArithmeticMatrix getNonResemblanceMatrix(ArithmeticMatrix matrix){
    	int size = matrix.getColLength();
    	ArithmeticMatrix mat = new ArithmeticMatrix(size,size,matrix.getColNameArray(),matrix.getColNameArray());
    	for(int i=0; i<size; i++){
    		for(int j=0; j<size; j++){
    			if(i!=j){
    				mat.setCell(i,j,getDissimilarityCoefficient(matrix, i ,j));
    				mat.setCell(j,i,getDissimilarityCoefficient(matrix, i, j));
    			}
    			else{
    				mat.setCell(i, i ,0);
    			}
    		}
    	}
    	return mat;
    }

/**
* ꤷоݤˤ뤢°ɸಽԤޤ
* @param attribute ꤷ°ֹ
* @param object ꤷоֹ
* @exception NotAttributeException ꤷ°¸ߤʤ
* @exception NotObjectException ꤷоݤ¸ߤʤ
* @return ɸಽоݤ°
*/
    public double getStandard(int attribute, int object){
    	if(attribute <= dataMatrix.getRowLength()){
    		if(object <= dataMatrix.getColLength()){
    			ArithmeticMatrix mat = new ArithmeticMatrix();
    			mat.matrixCopy(dataMatrix);
    			double sum = 0;
    			double ave = 0;
    			double hensa = 0;
    			double sth = 0;
    			double data = 0;
    			double sa = 0;
    			double sa2 = 0;
    			/*ʿ*/
    			for(int i=0; i<dataMatrix.getColLength(); i++){
    				data = 0;
    				data = mat.getCell(attribute, i);
    				sum = data + sum;
    			}
    			ave = sum/dataMatrix.getColLength();
    			/*ɸк*/
    			for(int i=0; i<dataMatrix.getColLength(); i++){
    				data = 0;
    				sa = 0;
    				sa2 = 0;
    				data = mat.getCell(attribute, i);
    				sa = data - ave;
    				sa2 = sa * sa;
    				hensa = sa2 + hensa;
    			}
    			sth = Math.sqrt(hensa/(mat.getColLength()-1));
    			
    			return (mat.getCell(attribute, object) - ave)/sth;
    		}
    		else{
    			throw new NotAttributeException("attribute("+ attribute +")");
    		}
    	}
    	else{
    			throw new NotObjectException("object("+ object +")");
    	}
    }
    

/**
* ꤷޥȥꥯ򸵤ˡꤷоݤˤ뤢°ɸಽԤޤ
* @param matrix ꤷޥȥꥯ
* @param attribute ꤷ°ֹ
* @param object ꤷоֹ
* @exception NotAttributeException ꤷ°¸ߤʤ
* @exception NotObjectException ꤷоݤ¸ߤʤ
* @return ɸಽоݤ°
*/
    public double getStandard(ArithmeticMatrix matrix, int attribute, int object){
    	if(attribute <= dataMatrix.getRowLength()){
    		if(object <= dataMatrix.getColLength()){
    			ArithmeticMatrix mat = new ArithmeticMatrix();
    			mat.matrixCopy(matrix);
    			double sum = 0;
    			double ave = 0;
    			double hensa = 0;
    			double sth = 0;
    			double data = 0;
    			double sa = 0;
    			double sa2 = 0;
    			/*ʿ*/
    			for(int i=0; i<matrix.getColLength(); i++){
    				data = 0;
    				data = mat.getCell(attribute, i);
    				sum = data + sum;
    			}
    			ave = sum/matrix.getColLength();
    			/*ɸк*/
    			for(int i=0; i<matrix.getColLength(); i++){
    				data = 0;
    				sa = 0;
    				sa2 = 0;
    				data = mat.getCell(attribute, i);
    				sa = data - ave;
    				sa2 = sa * sa;
    				hensa = sa2 + hensa;
    			}
    			sth = Math.sqrt(hensa/(mat.getColLength()-1));
    			
    			return (mat.getCell(attribute, object) - ave)/sth;
    		}
    		else{
    			throw new NotAttributeException("attribute("+ attribute +")");
    		}
    	}
    	else{
    		throw new NotObjectException("object("+ object +")");
    	}
    }
    
/**
* 2Ĥоݤٷޤ
* @param object1 ꤷ1ܤоֹ
* @param object2 ꤷ2ܤоֹ
* @exception NotObjectException ꤷоݤ¸ߤʤ
* @return ٷ 
*/
    public double getSimilarityCoefficient(int object1, int object2){
    	if(object1 <= dataMatrix.getColLength() && object2 <= dataMatrix.getColLength()){
    		double sum1 = 0;
    		double data1 = 0;
    		double data2 = 0;
    		double[] ave = dataMatrix.getRowAverageArray();
    		double sqr1 = 0;
    		double sqr2 = 0;
    		double nume = 0;
    		double deno = 0;
    	
    		for(int i=0; i<dataMatrix.getRowLength(); i++){
    			sum1 = 0;
    			data1 = 0;
    			data2 = 0;
    			sum1 = (dataMatrix.getCell(i,object1)-ave[i]) * (dataMatrix.getCell(i,object2)-ave[i]);
    			nume = sum1 + nume;
    		
    			data1 = (dataMatrix.getCell(i,object1) - ave[i]) * (dataMatrix.getCell(i,object1) - ave[i]);
    			sqr1 = data1 + sqr1;
    		
    			data2 = (dataMatrix.getCell(i,object2) - ave[i]) * (dataMatrix.getCell(i,object2) - ave[i]);
    			sqr2 = data2 + sqr2;
    		}
    		deno = Math.sqrt(sqr1) * Math.sqrt(sqr2);
    	
    		return nume/deno;
    	}
    	else{
    		throw new NotObjectException("object("+ object1 +","+object2+")");
    	}
    }
/**
* ꤵ줿ޥȥꥯ򸵤ˡ룲Ĥоݤٷޤ
* @param matrix ʬϤԤޥȥꥯ
* @param object1 ꤷ1ܤоֹ
* @param object2 ꤷ2ܤоֹ
* @return ٷ 
*/
    public double getSimilarityCoefficient(ArithmeticMatrix matrix, int object1, int object2){
    	if(object1 <= dataMatrix.getColLength() && object2 <= dataMatrix.getColLength()){
    		double sum1 = 0;
    		double data1 = 0;
    		double data2 = 0;
    		double[] ave = matrix.getRowAverageArray();
    		double sqr1 = 0;
    		double sqr2 = 0;
    		double nume = 0;
    		double deno = 0;
   
    	
    		for(int i=0; i<matrix.getRowLength(); i++){
    			sum1 = 0;
    			data1 = 0;
    			data2 = 0;
    			sum1 = (matrix.getCell(i,object1)-ave[i]) * (matrix.getCell(i,object2)-ave[i]);
    			nume = sum1 + nume;
    		
    			data1 = (matrix.getCell(i,object1) - ave[i]) * (matrix.getCell(i,object1) - ave[i]);
    			sqr1 = data1 + sqr1;
    			data2 = (matrix.getCell(i,object2) - ave[i]) * (matrix.getCell(i,object2) - ave[i]);
    			sqr2 = data2 + sqr2;
    		}
    		deno = Math.sqrt(sqr1) * Math.sqrt(sqr2);
    	
    		return nume/deno;
    	}
    	else{
    		throw new NotObjectException("object("+ object1 +","+object2+")");
    	}
    }


/**
* ꤷĤоݤٷޤ
* @param object1 ꤷ1ܤоֹ
* @param object2 ꤷ2ܤоֹ
* @return ٷ
*/
    public double getDissimilarityCoefficient(int object1, int object2){
    	if(object1 <= dataMatrix.getColLength() && object2 <= dataMatrix.getColLength()){
    		ArithmeticMatrix mat = new ArithmeticMatrix();
    		mat.matrixCopy(dataMatrix);
    		double data1 = 0; 
    		double data2 = 0;
    		double sub = 0;
    		double squ = 0;
    		double sum = 0;
    	
    		for(int i=0; i<dataMatrix.getRowLength(); i++){
    			data1 = 0;
    			data2 = 0;
    			sub = 0;
    			squ = 0;
    			data1 = mat.getCell(i,object1);
    			data2 = mat.getCell(i,object2);
    			sub = data1 - data2;
    			squ = sub * sub;
    			sum = sum + squ;
    		}
    		return Math.sqrt(sum);
    	}
    	else{
    		throw new NotObjectException("object("+ object1 +","+object2+")");
    	}
    }
    	
    /**
    * ꤷޥȥꥯ򸵤ˡ룲ĤоݤˤƤٷޤ
    * @param matrix ʬϤԤޥȥꥯ
    * @param object1 ꤷ1ܤоֹ
    * @param object2 ꤷ2ܤоֹ
    * @return ٷ
    */
        public double getDissimilarityCoefficient(ArithmeticMatrix matrix, int object1, int object2){
        	if(object1 <= dataMatrix.getColLength() && object2 <= dataMatrix.getColLength()){
        		ArithmeticMatrix mat = new ArithmeticMatrix();
        		mat.matrixCopy(matrix);
        		double data1 = 0;
        		double data2 = 0;
        		double sub = 0;
        		double squ = 0;
        		double sum = 0;
        	
        		for(int i=0; i<mat.getRowLength(); i++){       		
        			data1 = 0;
        			data2 = 0;
        			sub = 0;
        			squ = 0;
        			data1 = mat.getCell(i,object1);
        			data2 = mat.getCell(i,object2);
        			sub = data1 - data2;
        			squ = sub * sub;
        			sum = sum + squ;
        		}
        		return Math.sqrt(sum);
        	}
        	else{
        		throw new NotObjectException("object("+ object1 +","+object2+")");
        	}
        }
    
/**
* ꤷǡޥȥꥯ򤵤줿饹ˡ򸵤ˡեޥȥꥯѴޤ 
* @param matrix ǡޥȥꥯ
* @param CLUSTERING_METHOD 饹ˡɽ
* @param RESEMBLANCE_COEFFICIENT ɽ
* @return եޥȥꥯ
*/
   public ArithmeticMatrix getCorfeneticMatrix(ArithmeticMatrix matrix, int CLUSTERING_METHOD,int RESEMBLANCE_COEFFICIENT){
   	    int meth = CLUSTERING_METHOD;
   	    int re =RESEMBLANCE_COEFFICIENT;
   	    ArithmeticMatrix corfen = new ArithmeticMatrix();
   	    switch(meth){
		case CLUSTERING_UPGMA:
			if(re == SIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getUpgmaCorfeneticMatrix(matrix,re));	
			}
			if(re == DISSIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getUpgmaCorfeneticMatrix(matrix,re));
			}
			break;
   	    
		case CLUSTERING_SLINK:
			if(re == SIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getSlinkCorfeneticMatrix(matrix,re));
			}
			if(re == DISSIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getSlinkCorfeneticMatrix(matrix,re));
			}
			break;
			
		case CLUSTERING_CLINK:
			if(re == SIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getClinkCorfeneticMatrix(matrix,re));
			}
			if(re == DISSIMILARITY_COEFFICIENT){
				corfen.matrixCopy(getClinkCorfeneticMatrix(matrix,re));
			}
			break;
   	    }	
		return corfen;
   }
   
   /**
   * ǡޥȥꥯ򤵤줿饹ˡ򸵤ˡեޥȥꥯѴޤ 
   * @param CLUSTERING_METHOD 饹ˡɽ
   * @param RESEMBLANCE_COEFFICIENT ɽ
   * @return եޥȥꥯ
   */
      public ArithmeticMatrix getCorfeneticMatrix(int CLUSTERING_METHOD,int RESEMBLANCE_COEFFICIENT){
      	    int meth = CLUSTERING_METHOD;
      	    int re =RESEMBLANCE_COEFFICIENT;
      	    ArithmeticMatrix corfen = new ArithmeticMatrix();
      	    switch(meth){
   		case CLUSTERING_UPGMA:
   			if(re == SIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getUpgmaCorfeneticMatrix(dataMatrix,re));	
   			}
   			if(re == DISSIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getUpgmaCorfeneticMatrix(dataMatrix,re));
   			}
   			break;
      	    
   		case CLUSTERING_SLINK:
   			if(re == SIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getSlinkCorfeneticMatrix(dataMatrix,re));
   			}
   			if(re == DISSIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getSlinkCorfeneticMatrix(dataMatrix,re));
   			}
   			break;
   			
   		case CLUSTERING_CLINK:
   			if(re == SIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getClinkCorfeneticMatrix(dataMatrix,re));
   			}
   			if(re == DISSIMILARITY_COEFFICIENT){
   				corfen.matrixCopy(getClinkCorfeneticMatrix(dataMatrix,re));
   			}
   			break;
      	    }	
   		return corfen;
      }
      
    
/**
* ǡޥȥꥯ򥳡ե󷸿ޥȥꥯѴޤ
* @param matrix ޥȥꥯ
* @param resemcoef ɽ
* @return եޥȥꥯ
*/
    private ArithmeticMatrix getUpgmaCorfeneticMatrix(ArithmeticMatrix matrix, int resemcoef){
    	int re = resemcoef;
    	if(re == DISSIMILARITY_COEFFICIENT){
    	int size = matrix.getColLength();
    	//ޥȥꥯ
    	ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
    	//ޥȥꥯ̾
    	String[] name = new String[matrix.getColLength()];
    	for(int i=0; i<size; i++){
    		name[i] = String.valueOf(i+",");
    	}
    	ruijiMatrix.matrixCopy(getNonResemblanceMatrix(matrix));
    	ruijiMatrix.nameColCopy(name);
    	ruijiMatrix.nameRowCopy(name);
    	
    		//եޥȥꥯ
    	ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
    	corfen.nameColCopy(matrix.getColNameArray());
    	corfen.nameRowCopy(matrix.getColNameArray());
    
    	//ѥޥȥꥯ
    	ArithmeticMatrix umat = new ArithmeticMatrix();
    	umat.matrixCopy(ruijiMatrix);
    	//Ǿ	
    	int[] rowcol = minRowCol(umat);
    	int row = rowcol[0];
    	int col = rowcol[1];
    
    	int count = size - 2;  //ޥȥꥯκβ
    	
    	//1ܤκ
    	corfen.setCell(row,col,umat.getCell(row,col));
    	corfen.setCell(col,row,umat.getCell(col,row));
    	umat.matrixCopy(getUpgmaObjectUniteMatrix(row,col,ruijiMatrix,umat));
    	//2ܰʹߤΥ饹
    	String rn;
    	String rname[];
    	String cn;
    	String cname[];
		int rs=0;
		int cs=0;
    	int rc[] = new int[2];
    	if(size>3){
    		for(int i=0; i<count; i++){
    			rc = minRowCol(umat);
    			row = rc[0];
    			rn = umat.getRowName(row);
    			rname = rn.split(",");
    			rs = rname.length;
    			col = rc[1];
    			cn = umat.getColName(col);
    			cname = cn.split(",");
    			cs = cname.length;
    	
    		//	outputDoubleMatrix(umat);
    			for(int j=0; j<rs; j++){
    				for(int k=0; k<cs; k++){
    					corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMinCell(umat));
    					corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMinCell(umat));
    				}
    			}
    			umat.matrixCopy(getUpgmaObjectUniteMatrix(row,col,ruijiMatrix,umat));
    	
    		}
    	}
    	
    	return corfen;
    	}
    	if(re == SIMILARITY_COEFFICIENT){
    		int size = matrix.getColLength();
        	//ޥȥꥯ
        	ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
        	//ޥȥꥯ̾
        	String[] name = new String[matrix.getColLength()];
        	for(int i=0; i<size; i++){
        		name[i] = String.valueOf(i+",");
        	}
        	ruijiMatrix.matrixCopy(getSimilarityCoefficientMatrix(matrix));
        	ruijiMatrix.nameColCopy(name);
        	ruijiMatrix.nameRowCopy(name);
        	
        		//եޥȥꥯ
        	ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
        	corfen.nameColCopy(matrix.getColNameArray());
        	corfen.nameRowCopy(matrix.getColNameArray());
        
        	//ѥޥȥꥯ
        	ArithmeticMatrix umat = new ArithmeticMatrix();
        	umat.matrixCopy(ruijiMatrix);
        	//Ǿ	
        	int[] rowcol = maxRowCol(umat);
        	int row = rowcol[0];
        	int col = rowcol[1];
        
        	int count = size - 2;  //ޥȥꥯκβ
        	
        	//1ܤκ
        	corfen.setCell(row,col,umat.getCell(row,col));
        	corfen.setCell(col,row,umat.getCell(col,row));
        	umat.matrixCopy(getUpgmaObjectUniteMatrix(row,col,ruijiMatrix,umat));
        	//2ܰʹߤΥ饹
        	String rn;
        	String rname[];
        	String cn;
        	String cname[];
    		int rs=0;
    		int cs=0;
        	int rc[] = new int[2];
        	if(size>3){
        		for(int i=0; i<count; i++){
        			rc = maxRowCol(umat);
        			row = rc[0];
        			rn = umat.getRowName(row);
        			rname = rn.split(",");
        			rs = rname.length;
        			col = rc[1];
        			cn = umat.getColName(col);
        			cname = cn.split(",");
        			cs = cname.length;
        	
        		//	outputDoubleMatrix(umat);
        			for(int j=0; j<rs; j++){
        				for(int k=0; k<cs; k++){
        					corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMaxCell(umat));
        					corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMaxCell(umat));
        				}
        			}
        			umat.matrixCopy(getUpgmaObjectUniteMatrix(row,col,ruijiMatrix,umat));
        	
        		}
        	}
        	
        	return corfen;
    		
    	}
		return null;
    }


    
    /**
    * ǡޥȥꥯ򥳡ե󷸿ޥȥꥯѴޤ
    * @param matrix ޥȥꥯ
    * @param resecoef ɽ
    * @return եޥȥꥯ
    */
        private ArithmeticMatrix getSlinkCorfeneticMatrix(ArithmeticMatrix matrix, int resecoef ){
        	int re = resecoef;
        	if(re == DISSIMILARITY_COEFFICIENT){
        	int size = matrix.getColLength();
        	//ޥȥꥯ
        	ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
        	//ޥȥꥯ̾
        	String[] name = new String[matrix.getColLength()];
        	for(int i=0; i<size; i++){
        		name[i] = String.valueOf(i+",");
        	}
        	ruijiMatrix.matrixCopy(getNonResemblanceMatrix(matrix));
        	ruijiMatrix.nameColCopy(name);
        	ruijiMatrix.nameRowCopy(name);
        	
        		//եޥȥꥯ
        	ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
        	corfen.nameColCopy(matrix.getColNameArray());
        	corfen.nameRowCopy(matrix.getColNameArray());
        
        	//ѥޥȥꥯ
        	ArithmeticMatrix umat = new ArithmeticMatrix();
        	umat.matrixCopy(ruijiMatrix);
        	//Ǿ	
        	int[] rowcol = minRowCol(umat);
        	int row = rowcol[0];
        	int col = rowcol[1];
        
        	int count = size - 2;  //ޥȥꥯκβ
        	
        	//1ܤκ
        	corfen.setCell(row,col,umat.getCell(row,col));
        	corfen.setCell(col,row,umat.getCell(col,row));
        	umat.matrixCopy(getSlinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
        	//2ܰʹߤΥ饹
        	String rn;
        	String rname[];
        	String cn;
        	String cname[];
    		int rs=0;
    		int cs=0;
        	int rc[] = new int[2];
        	if(size>3){
        		for(int i=0; i<count; i++){
        			rc = minRowCol(umat);
        			row = rc[0];
        			rn = umat.getRowName(row);
        			rname = rn.split(",");
        			rs = rname.length;
        			col = rc[1];
        			cn = umat.getColName(col);
        			cname = cn.split(",");
        			cs = cname.length;
        	
        		//	outputDoubleMatrix(umat);
        			for(int j=0; j<rs; j++){
        				for(int k=0; k<cs; k++){
        					corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMinCell(umat));
        					corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMinCell(umat));
        				}
        			}
        			umat.matrixCopy(getSlinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
        	
        		}
        	}
        
        	return corfen;
        	}
        	if(re == SIMILARITY_COEFFICIENT){
        		int size = matrix.getColLength();
            	//ޥȥꥯ
            	ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
            	//ޥȥꥯ̾
            	String[] name = new String[matrix.getColLength()];
            	for(int i=0; i<size; i++){
            		name[i] = String.valueOf(i+",");
            	}
            	ruijiMatrix.matrixCopy(getNonResemblanceMatrix(matrix));
            	ruijiMatrix.nameColCopy(name);
            	ruijiMatrix.nameRowCopy(name);
            	
            		//եޥȥꥯ
            	ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
            	corfen.nameColCopy(matrix.getColNameArray());
            	corfen.nameRowCopy(matrix.getColNameArray());
            
            	//ѥޥȥꥯ
            	ArithmeticMatrix umat = new ArithmeticMatrix();
            	umat.matrixCopy(ruijiMatrix);
            	//Ǿ	
            	int[] rowcol = maxRowCol(umat);
            	int row = rowcol[0];
            	int col = rowcol[1];
            
            	int count = size - 2;  //ޥȥꥯκβ
            	
            	//1ܤκ
            	corfen.setCell(row,col,umat.getCell(row,col));
            	corfen.setCell(col,row,umat.getCell(col,row));
            	umat.matrixCopy(getClinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
            	//2ܰʹߤΥ饹
            	String rn;
            	String rname[];
            	String cn;
            	String cname[];
        		int rs=0;
        		int cs=0;
            	int rc[] = new int[2];
            	if(size>3){
            		for(int i=0; i<count; i++){
            			rc = maxRowCol(umat);
            			row = rc[0];
            			rn = umat.getRowName(row);
            			rname = rn.split(",");
            			rs = rname.length;
            			col = rc[1];
            			cn = umat.getColName(col);
            			cname = cn.split(",");
            			cs = cname.length;
            	
            		//	outputDoubleMatrix(umat);
            			for(int j=0; j<rs; j++){
            				for(int k=0; k<cs; k++){
            					corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMaxCell(umat));
            					corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMaxCell(umat));
            				}
            			}
            			umat.matrixCopy(getClinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
            	
            		}
            	}
            
            	return corfen;
        		
        	}
			return null;
        }
        
        /**
         * ǡޥȥꥯ򥳡ե󷸿ޥȥꥯѴޤ
         * @param matrix ޥȥꥯ
         * @param resecoef
         * @return եޥȥꥯ
         */
             private ArithmeticMatrix getClinkCorfeneticMatrix(ArithmeticMatrix matrix,int resecoef){
             	int re = resecoef;
             	if(re == DISSIMILARITY_COEFFICIENT){
             		int size = matrix.getColLength();
             		//ޥȥꥯ
             		ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
             		//ޥȥꥯ̾
             		String[] name = new String[matrix.getColLength()];
             		for(int i=0; i<size; i++){
             			name[i] = String.valueOf(i+",");
             		}
             		ruijiMatrix.matrixCopy(getNonResemblanceMatrix(matrix));
             		ruijiMatrix.nameColCopy(name);
             		ruijiMatrix.nameRowCopy(name);
             	
             			//եޥȥꥯ
             		ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
             		corfen.nameColCopy(matrix.getColNameArray());
             		corfen.nameRowCopy(matrix.getColNameArray());
             
             		//ѥޥȥꥯ
             		ArithmeticMatrix umat = new ArithmeticMatrix();
             		umat.matrixCopy(ruijiMatrix);
             		//Ǿ	
             		int[] rowcol = minRowCol(umat);
             		int row = rowcol[0];
             		int col = rowcol[1];
             
             		int count = size - 2;  //ޥȥꥯκβ
             	
             		//1ܤκ
             		corfen.setCell(row,col,umat.getCell(row,col));
             		corfen.setCell(col,row,umat.getCell(col,row));
             		umat.matrixCopy(getClinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
             		//2ܰʹߤΥ饹
             		String rn;
             		String rname[];
             		String cn;
             		String cname[];
             		int rs=0;
             		int cs=0;
             		int rc[] = new int[2];
             		if(size>3){
             			for(int i=0; i<count; i++){
             				rc = minRowCol(umat);
             				row = rc[0];
             				rn = umat.getRowName(row);
             				rname = rn.split(",");
             				rs = rname.length;
             				col = rc[1];
             				cn = umat.getColName(col);
             				cname = cn.split(",");
             				cs = cname.length;
             	
             		//	outputDoubleMatrix(umat);
             				for(int j=0; j<rs; j++){
             					for(int k=0; k<cs; k++){
             						corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMinCell(umat));
             						corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMinCell(umat));
             					}
             				}
             				umat.matrixCopy(getClinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
             			}
             		}
             
             		return corfen;
             	}
             	
             	if(re == SIMILARITY_COEFFICIENT){
             		int size = matrix.getColLength();
             		//ޥȥꥯ
             		ArithmeticMatrix ruijiMatrix = new ArithmeticMatrix();
             		//ޥȥꥯ̾
             		String[] name = new String[matrix.getColLength()];
             		for(int i=0; i<size; i++){
             			name[i] = String.valueOf(i+",");
             		}
             		ruijiMatrix.matrixCopy(getNonResemblanceMatrix(matrix));
             		ruijiMatrix.nameColCopy(name);
             		ruijiMatrix.nameRowCopy(name);
                     	
             		//եޥȥꥯ
             		ArithmeticMatrix corfen = new ArithmeticMatrix(size,size);
             		corfen.nameColCopy(matrix.getColNameArray());
             		corfen.nameRowCopy(matrix.getColNameArray());
             		
             		//ѥޥȥꥯ
             		ArithmeticMatrix umat = new ArithmeticMatrix();
             		umat.matrixCopy(ruijiMatrix);
             		//Ǿ	
             		int[] rowcol = maxRowCol(umat);
             		int row = rowcol[0];
             		int col = rowcol[1];
             		
             		int count = size - 2;  //ޥȥꥯκβ
                     	
             		//1ܤκ
             		corfen.setCell(row,col,umat.getCell(row,col));
             		corfen.setCell(col,row,umat.getCell(col,row));
             		umat.matrixCopy(getSlinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
             		//2ܰʹߤΥ饹
             		String rn;
             		String rname[];
             		String cn;
             		String cname[];
             		int rs=0;
             		int cs=0;
             		int rc[] = new int[2];
             		if(size>3){
             			for(int i=0; i<count; i++){
             				rc = maxRowCol(umat);
             				row = rc[0];
             				rn = umat.getRowName(row);
             				rname = rn.split(",");
             				rs = rname.length;
             				col = rc[1];
             				cn = umat.getColName(col);
             				cname = cn.split(",");
             				cs = cname.length;
             				
             				//	outputDoubleMatrix(umat);
             				for(int j=0; j<rs; j++){
             					for(int k=0; k<cs; k++){
             						corfen.setCell(Integer.parseInt(rname[j]),Integer.parseInt(cname[k]),getMaxCell(umat));
             						corfen.setCell(Integer.parseInt(cname[k]),Integer.parseInt(rname[j]),getMaxCell(umat));
             					}
             				}
             				umat.matrixCopy(getSlinkObjectUniteMatrix(row,col,ruijiMatrix,umat));
                     	
             			}
             		}
             		return corfen;
             	}
             	return null;
             }

/**
* 2ĤоݤͻԤäޥȥꥯ֤ޤ
* @param object1 ͻԤ1ܤоֹ
* @param object2 ͻԤ2ܤоֹ
* @return ͻԤäޥȥꥯ 
*/
    private ArithmeticMatrix getUpgmaObjectUniteMatrix(int object1, int object2, ArithmeticMatrix ruijiMatrix,ArithmeticMatrix uniteMatrix){
   	
    	int size = ruijiMatrix.getColLength();
        //ͻΥޥȥꥯ
    	int usize = uniteMatrix.getColLength();
    	ArithmeticMatrix umat = new ArithmeticMatrix(usize-1,usize-1);
    	
    	//ޥȥꥯ
    	ArithmeticMatrix ruimat = new ArithmeticMatrix();
    	ruimat.matrixCopy(ruijiMatrix);
    	//̾
    	String o1 = uniteMatrix.getColName(object1);
    	String o2 = uniteMatrix.getColName(object2);
    	String st = o1+o2;
    	String str[];
    	str = st.split(",");
    	int si = str.length;
    	
    	int[] num = new int[usize-1];
    	int count=0;
    	//ͻ礵ʤֹ֥
    	for(int i=0; i<usize; i++){
    		if(i!=object1 && i!=object2){
    			num[count]=i;
    			count++;
    		}
    	}
    	//ͻˤϴطΤʤǡ
    	for(int j=0; j<usize-2; j++){
    		for(int k=0; k<usize-2; k++){
    			umat.setCell(j,k,uniteMatrix.getCell(num[j],num[k]));
    			umat.setCell(k,j,uniteMatrix.getCell(num[k],num[j]));
    		}
    	} 
        double wadata=0;
        int data1;
        String sdata;
        double data2;
        int count2 = count;
        count2 = 0;
        int sri = 0;
        int sd = 0;
        int s = 0;
        //ͻ˴طΤǡ
        for(int k=0; k<count; k++){
        	for(int i=0; i<si; i++){
        		data1 = Integer.parseInt(str[i]);
        		sdata = uniteMatrix.getColName(num[k]);
        		String sr[] = sdata.split(",");
        		sri = sr.length;
        		for(int j=0; j<sri; j++){
        			sd = Integer.parseInt(sr[j]);
        			data2 = ruimat.getCell(data1,sd); 
        			wadata = wadata + data2;
        			s++;
        		}
        	}
        	wadata = wadata/s;
        	s = 0;
        	//ͻ˴طobjectޥȥꥯ
     		umat.setCell(usize-2,count2,wadata);
     		umat.setCell(count2,usize-2,wadata);
     		data1 = 0;
     		data2 = 0;
     		wadata = 0;
     		count2++;
        }
        
        //umat̾
        String[] ar = new String[usize-1];
        int z=0;
        for(int i=0; i<usize; i++){
        	if(i!=object1 && i!=object2){
        		ar[z] = uniteMatrix.getColName(i);
        		z++;
        	}
        }
        ar[usize-2] = st;
        umat.nameColCopy(ar);
        umat.nameRowCopy(ar);
        return umat;
    }

    /**
    * 2ĤоݤͻԤäޥȥꥯ֤ޤ
    * @param object1 ͻԤ1ܤоֹ
    * @param object2 ͻԤ2ܤоֹ
    * @return ͻԤäޥȥꥯ 
    */
        private ArithmeticMatrix getSlinkObjectUniteMatrix(int object1, int object2, ArithmeticMatrix ruijiMatrix,ArithmeticMatrix uniteMatrix){
       	
        	int size = ruijiMatrix.getColLength();
            //ͻΥޥȥꥯ
        	int usize = uniteMatrix.getColLength();
        	ArithmeticMatrix umat = new ArithmeticMatrix(usize-1,usize-1);
        	
        	//ޥȥꥯ
        	ArithmeticMatrix ruimat = new ArithmeticMatrix();
        	ruimat.matrixCopy(ruijiMatrix);
        	//̾
        	String o1 = uniteMatrix.getColName(object1);
        	String o2 = uniteMatrix.getColName(object2);
        	String st = o1+o2;
        	String str[];
        	str = st.split(",");
        	int si = str.length;
        	
        	int[] num = new int[usize-1];
        	int count=0;
        	//ͻ礵ʤֹ֥
        	for(int i=0; i<usize; i++){
        		if(i!=object1 && i!=object2){
        			num[count]=i;
        			count++;
        		}
        	}
        	//ͻˤϴطΤʤǡ
        	for(int j=0; j<usize-2; j++){
        		for(int k=0; k<usize-2; k++){
        			umat.setCell(j,k,uniteMatrix.getCell(num[j],num[k]));
        			umat.setCell(k,j,uniteMatrix.getCell(num[k],num[j]));
        		}
        	} 
            int data1;
            String sdata;
            double data2;
            int count2 = count;
            count2 = 0;
            int sri = 0;
            int sd = 0;
            double min = 1000000000;
            //ͻ˴طΤǡ
            for(int k=0; k<count; k++){
            	for(int i=0; i<si; i++){
            		data1 = Integer.parseInt(str[i]);
            		sdata = uniteMatrix.getColName(num[k]);
            		String sr[] = sdata.split(",");
            		sri = sr.length;
            		for(int j=0; j<sri; j++){
            			sd = Integer.parseInt(sr[j]);
            			data2 = ruimat.getCell(data1,sd);
            			if(data1 != sd){
            				if(min>data2){
            					min = data2;
            				
            				}
            			}
            		}
            	}
            	//ͻ˴طobjectޥȥꥯ
         		umat.setCell(usize-2,count2,min);
         		umat.setCell(count2,usize-2,min);
         		data1 = 0;
         		data2 = 0;
         		count2++;
         		min = 1000000000;
            }
            
            //umat̾
            String[] ar = new String[usize-1];
            int z=0;
            for(int i=0; i<usize; i++){
            	if(i!=object1 && i!=object2){
            		ar[z] = uniteMatrix.getColName(i);
            		z++;
            	}
            }
            ar[usize-2] = st;
            umat.nameColCopy(ar);
            umat.nameRowCopy(ar);
            return umat;
          }
    
    
        /**
         * 2ĤоݤͻԤäޥȥꥯ֤ޤ
         * @param object1 ͻԤ1ܤоֹ
         * @param object2 ͻԤ2ܤоֹ
         * @return ͻԤäޥȥꥯ 
         */
             private ArithmeticMatrix getClinkObjectUniteMatrix(int object1, int object2, ArithmeticMatrix ruijiMatrix,ArithmeticMatrix uniteMatrix){
            	
             	int size = ruijiMatrix.getColLength();
                 //ͻΥޥȥꥯ
             	int usize = uniteMatrix.getColLength();
             	ArithmeticMatrix umat = new ArithmeticMatrix(usize-1,usize-1);
             	
             	//ޥȥꥯ
             	ArithmeticMatrix ruimat = new ArithmeticMatrix();
             	ruimat.matrixCopy(ruijiMatrix);
             	//̾
             	String o1 = uniteMatrix.getColName(object1);
             	String o2 = uniteMatrix.getColName(object2);
             	String st = o1+o2;
             	String str[];
             	str = st.split(",");
             	int si = str.length;
             	
             	int[] num = new int[usize-1];
             	int count=0;
             	//ͻ礵ʤֹ֥
             	for(int i=0; i<usize; i++){
             		if(i!=object1 && i!=object2){
             			num[count]=i;
             			count++;
             		}
             	}
             	//ͻˤϴطΤʤǡ
             	for(int j=0; j<usize-2; j++){
             		for(int k=0; k<usize-2; k++){
             			umat.setCell(j,k,uniteMatrix.getCell(num[j],num[k]));
             			umat.setCell(k,j,uniteMatrix.getCell(num[k],num[j]));
             		}
             	} 
                 int data1;
                 String sdata;
                 double data2;
                 int count2 = count;
                 count2 = 0;
                 int sri = 0;
                 int sd = 0;
                 double max = 0;
                 //ͻ˴طΤǡ
                 for(int k=0; k<count; k++){
                 	for(int i=0; i<si; i++){
                 		data1 = Integer.parseInt(str[i]);
                 		sdata = uniteMatrix.getColName(num[k]);
                 		String sr[] = sdata.split(",");
                 		sri = sr.length;
                 		for(int j=0; j<sri; j++){
                 			sd = Integer.parseInt(sr[j]);
                 			data2 = ruimat.getCell(data1,sd);
                 			if(data1 != sd){
                 				if(max<data2){
                 					max = data2;
                 				
                 				}
                 			}
                 		}
                 	}
                 	//ͻ˴طobjectޥȥꥯ
              		umat.setCell(usize-2,count2,max);
              		umat.setCell(count2,usize-2,max);
              		data1 = 0;
              		data2 = 0;
              		count2++;
              		max = 0;
                 }
                 
                 //umat̾
                 String[] ar = new String[usize-1];
                 int z=0;
                 for(int i=0; i<usize; i++){
                 	if(i!=object1 && i!=object2){
                 		ar[z] = uniteMatrix.getColName(i);
                 		z++;
                 	}
                 }
                 ar[usize-2] = st;
                 umat.nameColCopy(ar);
                 umat.nameRowCopy(ar);
                 return umat;
               }
         
        
        
        
/**
* ǡޥȥꥯꤷޤ
* @param baseMatrix 򤹤ǡޥȥꥯ
*/
    private void setMatrix(ArithmeticMatrix baseMatrix){
    	dataMatrix = new ArithmeticMatrix();
    	dataMatrix.matrixCopy(baseMatrix);
    }
    //ͤιԤ֤
    private int[] maxRowCol(ArithmeticMatrix mat){
    	int row =0;
    	int col =0;
    	int rowcol[] = new int[2];
    	double maxValue;
    	maxValue = mat.getCell(0,1);
    	row =0;
    	col =1;
    	for(int i=0; i<mat.getRowLength(); i++){
    		for(int j=0; j<mat.getColLength();j++){
    			if(i!=j){	
    				if(maxValue < mat.getCell(i,j)){
    					maxValue = mat.getCell(i,j);			
    					row = i;
    					col = j;
    				}
    			}
    		}
    	}
    	rowcol[0]= row;
    	rowcol[1]= col;
    	return rowcol;
    }
 
    //ǾͤιԤ֤
    private int[] minRowCol(ArithmeticMatrix mat){
    	int row = 0;
    	int col = 0;
    	int rowcol[] = new int[2];
    	double minValue;
    	minValue = mat.getCell(0,1);
    	row = 0;
    	col = 1;
    	for(int i=0; i<mat.getRowLength(); i++){
    		for(int j=0; j<mat.getColLength();j++){
    			if(i!=j){	
    				if(minValue > mat.getCell(i,j)){
    					minValue = mat.getCell(i,j);			
    					row = i;
    					col = j;
    				}
    			}
    		}
    	}
    
    	rowcol[0]= row;
    	rowcol[1]= col;
    	return rowcol;
    }
    
    /**
     * ޥȥꥯǤˤͤǾ֤ͤޤ
     * @param ޥȥꥯ
     * @return ˤǾ
     */	
    	private double getMinCell(ArithmeticMatrix mat){
    		double minValue;
    		minValue = mat.getCell(0,1);
    		
    		for(int i=0; i<mat.getRowLength(); i++){
    			for(int j=0; j<mat.getColLength();j++){
    				if(i!=j){
    					if(minValue > mat.getCell(i,j)){
    						minValue = mat.getCell(i,j);				
    					}
    				}
    			}
    		}
    		return minValue;
    	}
    	
    	 /**
         * ޥȥꥯǤˤͤǾ֤ͤޤ
         * @param ޥȥꥯ
         * @return ˤǾ
         */	
        	private double getMaxCell(ArithmeticMatrix mat){
        		double maxValue;
        		maxValue = mat.getCell(0,1);
        		
        		for(int i=0; i<mat.getRowLength(); i++){
        			for(int j=0; j<mat.getColLength();j++){
        				if(i!=j){
        					if(maxValue < mat.getCell(i,j)){
        						maxValue = mat.getCell(i,j);				
        					}
        				}
        			}
        		}
        		return maxValue;
        	}
    	
}

