import jp.ac.takushoku_u.cs.*;

/**
* TaskTestクラスはTaskSequenceクラスのテスト用クラスです。
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日2005年01月08日
*/

class TaskTest{
	public static void main(String[] args){
		//サンプルデータ
		double test1[][] = {
			{0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{0,1,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0},
			{0,0,0,1,0,0,0,0},
			{0,0,0,1,1,0,0,0},
			{0,1,0,0,1,0,0,0}};
		
		//ダミーつきのサンプルデータ
		double test2[][] = {
			{0,0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0,0},
			{0,1,0,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0,0},
			{0,0,0,1,0,0,0,0,0},
			{0,0,0,1,1,0,0,0,0},
			{0,1,0,0,1,0,0,0,0},
			{0,0,0,0,0,1,1,1,0}};
		
		String[] name1 = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8"};
		String[] name2 = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8","要素9"};
		
		//分析データおよび出力用マトリクスの生成
		ArithmeticMatrix mat = new ArithmeticMatrix(test1, name1, name1);//ダミーなし
		//ArithmeticMatrix mat = new ArithmeticMatrix(test2, name2, name2);//ダミーをあらかじめ設定
		ArithmeticMatrix mat1 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat2 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat3 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat4 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat5 = new ArithmeticMatrix(test2, name2, name2);
		TaskSequence task = new TaskSequence(mat);
		
		//隣接マトリクスの出力
		System.out.println("隣接マトリクス");
		//マトリクスの出力
		outputMatrix(mat);
		
		//ダミーを付与した隣接マトリクスの出力
		System.out.println("ダミーを付与した隣接マトリクス");
		//ダミーを付与した隣接マトリクスの収得
		mat1.matrixCopy(task.getDummyMatrix());
		outputMatrix(mat1);
		
		//可到達マトリクスの出力
		System.out.println("可到達マトリクス");
		mat2.matrixCopy(task.getReachMatrix());
		outputMatrix(mat2);
		
		//合前提性マトリクスの出力
		System.out.println("合前提性マトリクス");
		mat3.matrixCopy(task.getFMatrix());
		outputDoubleMatrix(mat3);
		
		//合目標性マトリクスの出力
		System.out.println("合目標性マトリクス");
		mat4.matrixCopy(task.getGMatrix());
		outputDoubleMatrix(mat4);
		
		//指標のマトリクスの出力
		System.out.println("指標のマトリクス(α=0.5 β=0.5のとき)");
		mat5.matrixCopy(task.getCoherenceMatrix(0.5,0.5));
		outputDoubleMatrix(mat5);
		
		//系列結果の出力(配列出力)
		System.out.println("系列化順(配列で行番号を返す)");
		System.out.println("仮想項目を付与したか: "+ task.isDummy());
		int[] returnArray = new int[mat.getRowLength()];
		System.arraycopy(task.getTaskSequenceArray(0.5,0.5), 0, returnArray, 0, mat.getRowLength());
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(returnArray[i] + ",");
		}
		System.out.println();
		
		
		//系列結果の出力(Sequence出力)
		System.out.println("系列化順(α=0.5 β=0.5のとき)");//(Sequenceクラス利用)");
		System.out.println("仮想項目を付与したか: "+ task.isDummy());
		Sequence sq = new Sequence();
		//シーケンスの収得
		sq.sequenceCopy(task.getTaskSequence(0.5,0.5));
		System.out.print("行番号: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItem(i) + ",");
		}
		System.out.println();
		System.out.print("行名: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItemName(i) + ",");
		}
		System.out.println();
		
	}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("        ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.00");		//小数点以下2桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+"  ");
				}
			}
		}
		System.out.println();
	}
}