import jp.ac.takushoku_u.cs.*;
import java.util.Set;
import java.util.Iterator;
import java.util.TreeSet;

/**
* TaskPreTestクラスはTaskSequencePresumptionクラスのテスト用クラスです。
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日2005年01月10日
*/

class TaskPreTest{
	public static void main(String[] args){
		double test1[][] = {
			{0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{0,1,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0},
			{0,0,0,1,0,0,0,0},
			{0,0,0,1,1,0,0,0},
			{0,1,0,0,1,0,0,0}};
		
		String[] name1 = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8"};
		
		ArithmeticMatrix mat = new ArithmeticMatrix(test1, name1, name1);
		TaskSequence task = new TaskSequence(mat);
		
		//Sequenceの設定
		Sequence sq = new Sequence();
		sq.sequenceCopy(task.getTaskSequence(0.5,0.5));
		
		//系列化を行う系列の出力
		System.out.println("推定を行う系列");
		System.out.print("行番号: ");
		for(int i = 0; i < mat.getRowLength(); i++){
			System.out.print(sq.getItem(i) + ",");
		}
		System.out.println();
		System.out.print("行名: ");
		for(int i = 0; i < mat.getRowLength(); i++){
			System.out.print(sq.getItemName(i) + ",");
		}
		System.out.println();
		System.out.println();
		
		
		
		//ここからがテストプログラム
		TaskSequencePresumption tsp = new TaskSequencePresumption(sq, mat);
		
		int vi = 4;		//選択項目(注意：項目番号であるため要素番号-1を指定します）
		int vj = 5;		//選択項目に対する選択可能項目(選ばれなかった項目)
						//viとvjが適切に選択されていない場合は例外が発生します
		int k = 2;		//象限(1,2,3,4)
		
		//(1)式、(2)式、(2)式/(1)式の出力(アルファ)
		System.out.println("第"+k+"象限における 選択項目:"+mat.getRowName(vi)+" とその時の選択可能項目:"+mat.getRowName(vj) );
		System.out.println("αにおける(1)式、(2)式、(2)/(1)の値");
		System.out.println(tsp.getDiscriminantOneAlpha(vi,vj,k) + " , "
			+ tsp.getDiscriminantTwoAlpha(vi,vj,k) + " , " + tsp.getDiscriminantAlpha(vi,vj,k));
		
		//(1)式、(2)式、(2)式/(1)式の出力(ベータ)
		System.out.println("βにおける(1)式、(2)式、(2)/(1)の値");
		System.out.println(tsp.getDiscriminantOneBeta(vi,vj,k) + " , "
			+ tsp.getDiscriminantTwoBeta(vi,vj,k) + " , " + tsp.getDiscriminantBeta(vi,vj,k));
		
		System.out.println();
		System.out.println("第"+k+"象限における 選択項目:"+mat.getRowName(vi)+" とその時の選択可能項目:"+mat.getRowName(vj) );
		System.out.println("αの推定区間");
		
		//指定した項目、象限での求めた区間
		Range ra = new Range();
		ra.rangeCopy(tsp.getAlphaPresumptionRange(vi,vj,k));
		
		//αの出力
		//区間の出力
		System.out.println(ra.getMin() + " < α < " + ra.getMax());
		//区間の両端は含むかどうか出力 true ならば不等号は <=、false ならば < となる
		System.out.println("<=: "+ ra.hasMin() + " <=: " + ra.hasMax());
		//NaN(区間なし)の場合は true
		System.out.println("空集合か: "+ ra.isEmpty());
		
		//βの出力
		Range ran = new Range();
		System.out.println();
		System.out.println("βの推定区間");
		ran.rangeCopy(tsp.getBetaPresumptionRange(vi,vj,k));
		System.out.println(ran.getMin() + " < β < " + ran.getMax());
		System.out.println("<=: "+ ran.hasMin() + " <=: " + ran.hasMax());
		System.out.println("空集合か: "+ ran.isEmpty());
		
		
		//帰属度関数が1となる区間の出力
		System.out.println();
		System.out.println("第"+k+"象限のとき帰属度関数が1になる区間");
		ra.rangeCopy(tsp.getAlphaRange(k));
		System.out.println(ra.getMin() + " < α < " + ra.getMax());
		System.out.println("<=: "+ ra.hasMin() + " <=: " + ra.hasMax());
		System.out.println("空集合か: "+ ra.isEmpty());
		
		System.out.println();
		ra.rangeCopy(tsp.getBetaRange(k));
		System.out.println(ra.getMin() + " < β < " + ra.getMax());
		System.out.println("<=: "+ ra.hasMin() + " <=: " + ra.hasMax());
		System.out.println("空集合か: "+ ra.isEmpty());
		
		//αの取りうる範囲の集合を出力
		System.out.println();
		System.out.println("αの項目ごとの推定結果");
		RangeSet hashSet = new RangeSet(tsp.getAlphaRangeSet(k));
		Iterator i = hashSet.iterator();
    	while(i.hasNext()){
    		Range ed = (Range)i.next();
    		
    		System.out.println(ed.getMin() + " < α < " + ed.getMax());
			System.out.println("<=: "+ ed.hasMin() + " <=: " + ed.hasMax());
			System.out.println("空集合か: "+ ed.isEmpty());
    	}
		
		//帰属度関数の値の出力
		System.out.println();
		Set setx = new TreeSet(tsp.getAlphaAttributeSet(k));
		Iterator ix = setx.iterator();
		while(ix.hasNext()){
			Double dx = (Double)ix.next();
			double x = dx.doubleValue();
			if(Double.isNaN(x) == false){
				System.out.println(x + "のときの帰属度関数の値");
				System.out.println(tsp.getBetaAttribute(k,x));
			}
		}
		
		//ある値での帰属度関数の値と変化するαの値の集合
		System.out.println();
		System.out.println("α=0のときの帰属度関数: "+tsp.getAlphaAttribute(k,0));
		System.out.println("αの変化点: "+ tsp.getAlphaAttributeSet(k));
		
		//βの取りうる範囲の集合を出力
		System.out.println();
		System.out.println("βの項目ごとの推定結果");
		hashSet = new RangeSet(tsp.getBetaRangeSet(k));
		i = hashSet.iterator();
    	while(i.hasNext()){
    		Range ed = (Range)i.next();
    		
    		System.out.println(ed.getMin() + " < β < " + ed.getMax());
			System.out.println("<=: "+ ed.hasMin() + " <=: " + ed.hasMax());
			System.out.println("空集合か: "+ ed.isEmpty());
    	}
		
		//帰属度関数の値の出力
		System.out.println();
		Set sety = new TreeSet(tsp.getBetaAttributeSet(k));
		Iterator iy = sety.iterator();
		while(iy.hasNext()){
			Double dy = (Double)iy.next();
			double y = dy.doubleValue();
			if(Double.isNaN(y) == false){
				System.out.println(y + "のときの帰属度関数の値");
				System.out.println(tsp.getBetaAttribute(k,y));
			}
		}
		
		//ある値での帰属度関数の値と変化するβの値の集合
		System.out.println();
		System.out.println("β=0のときの帰属度関数: "+tsp.getBetaAttribute(k,0));
		System.out.println("βの変化点: "+ tsp.getBetaAttributeSet(k));
		
	}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("        ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.00");		//小数点以下2桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+"  ");
				}
			}
		}
		System.out.println();
	}
}