import jp.ac.takushoku_u.cs.*;
import java.util.*;

/**
* TaskMatrixTestクラスはTaskSequenceで行った系列結果をすべて出力させるためのクラスです。
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日2005年02月07日
*/

class TaskMatrixTest{
	public static void main(String[] args){
		
		//系列化を行うモデルデータ
		double test1[][] = {
			{0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0},
			{0,1,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0},
			{0,0,0,1,0,0,0,0},
			{0,0,0,1,1,0,0,0},
			{0,1,0,0,1,0,0,0}};
		
		//あらかじめ仮想項目を要素9に付けたデータ
		double test2[][] = {
			{0,0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0,0},
			{1,0,0,0,0,0,0,0,0},
			{0,1,0,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0,0},
			{0,0,0,1,0,0,0,0,0},
			{0,0,0,1,1,0,0,0,0},
			{0,1,0,0,1,0,0,0,0},
			{0,0,0,0,0,1,1,1,0}};
		
		String[] name1 = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8"};
		String[] name2 = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8","要素9"};
		
		//マトリクスの設定
		ArithmeticMatrix mat = new ArithmeticMatrix(test1, name1, name1);//ダミーなし
		//ArithmeticMatrix mat = new ArithmeticMatrix(test2, name2, name2);//ダミーをあらかじめ設定
		ArithmeticMatrix mat1 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat2 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat3 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat4 = new ArithmeticMatrix(test2, name2, name2);
		ArithmeticMatrix mat5 = new ArithmeticMatrix(test2, name2, name2);
		
		
		//マトリクスをファイル読み込みにする場合は、
		//try-catchのコメントをはずす
		/*
		try{
			mat.matrixCopy(MatrixReader.getArithmeticMatrixReader(args[0]));
		}
		catch(Exception e){
			System.out.println(e);
		}
		*/
		
		TaskSequence task = new TaskSequence(mat);
		
/************************************************************************************************/
		//基本的に以下のalpha,beta,arの3つの値だけ変えればよい
		//αとβの設定
		double alpha = -1;
		double beta = 0;
		
		//系列に優先を付ける
		int[] ar = {5,7,4,3};
		
		//項目番号を設定(要素番号-1)
		//ar = {6,5}とすると要素6を選択する際に要素7も選べたとすると、
		//要素6よりも要素7を優先して選択を行う。
		//配列の前にある要素の方をより優先して選択を行う。
		
		
/**************************************************************************************************/
		//以下は出力用
		//基本的に変えなくても良い
		//隣接マトリクスの出力
		System.out.println("隣接マトリクス");
		outputMatrix(mat);
		
		//ダミーを付与した隣接マトリクスの出力
		System.out.println("ダミーを付与した隣接マトリクス");
		mat1.matrixCopy(task.getDummyMatrix());
		outputMatrix(mat1);
		
		//可到達マトリクスの出力
		System.out.println("可到達マトリクス");
		mat2.matrixCopy(task.getReachMatrix());
		outputMatrix(mat2);
		
		//合前提性マトリクスの出力
		System.out.println("合前提性マトリクス");
		mat3.matrixCopy(task.getFMatrix());
		outputDoubleMatrix(mat3);
		
		//合目標性マトリクスの出力
		System.out.println("合目標性マトリクス");
		mat4.matrixCopy(task.getGMatrix());
		outputDoubleMatrix(mat4);
		
		//指標のマトリクスの出力
		System.out.println("指標のマトリクス(α="+alpha+" β="+beta+"のとき)");
		mat5.matrixCopy(task.getCoherenceMatrix(alpha,beta));
		outputDoubleMatrix(mat5);
		
		
		
		//系列結果の出力(配列出力)
		System.out.println("系列化順(配列で行番号を返す)");
		System.out.println("仮想項目を付与したか: "+ task.isDummy());
		int[] returnArray = new int[mat.getRowLength()];
		System.arraycopy(task.getTaskSequenceArray(alpha,beta), 0, returnArray, 0, mat.getRowLength());
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(returnArray[i] + ",");
		}
		System.out.println();
		
		
		//系列結果の出力(Sequence出力)
		System.out.println("系列化順(α="+alpha+" β="+beta+"のとき)");//(Sequenceクラス利用)
		System.out.println("仮想項目を付与したか: "+ task.isDummy());
		Sequence sq = new Sequence();
		sq.sequenceCopy(task.getTaskSequence(alpha,beta));
		System.out.print("行番号: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItem(i) + ",");
		}
		System.out.println();
		System.out.print("行名: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItemName(i) + ",");
		}
		System.out.println();
		System.out.println();
		
		//系列に分岐点はあったか
		//例として、行:要素4、列:要素5がtrueであった場合
		//要素4を選択する際に要素5も選択することができることを示す。
		outputMatrix(task.getDivergenceMatrix());
		
		
		
		
		//系列結果の出力(Sequence出力)
		//優先配列を有効にしたもの
		System.out.println("優先を付けた系列化順(α="+alpha+" β="+beta+"のとき)");//(Sequenceクラス利用)
		
		//優先配列を使用
		task.setPriorityOrder(ar);
		
		System.out.println("仮想項目を付与したか: "+ task.isDummy());
		sq.sequenceCopy(task.getTaskSequence(alpha,beta));
		System.out.print("行番号: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItem(i) + ",");
		}
		System.out.println();
		System.out.print("行名: ");
		for(int i = 0; i < returnArray.length; i++){
			System.out.print(sq.getItemName(i) + ",");
		}
		System.out.println();
		System.out.println();
		
		//系列に分岐点はあったか
		outputMatrix(task.getDivergenceMatrix());
		
		
		
		//系列結果を全て出力
		
		//マトリクスの要素は隣接マトリクスの列番号
		System.out.println("全ての系列結果:マトリクスの要素は列番号");
		outputMatrix(TaskSequenceMatrix.getTaskMatrix(mat, alpha, beta));
		
		//マトリクスの要素は隣接マトリクスの列名
		System.out.println("全ての系列結果:マトリクスの要素は列名");
		outputMatrix(TaskSequenceMatrix.getTaskStringMatrix(mat, alpha, beta));
		
		
		
	}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("        ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			}
			else if(i == 9 && outMatrix.getRowName(i).length() == 1){
				System.out.print(outMatrix.getRowName(i) + "  ");
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.00");		//小数点以下2桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+"  ");
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをboolean型で標準出力に出力します。
*/
	private static void outputMatrix(BooleanMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
					if(outMatrix.getCell(i, j)){
						System.out.print(" ");
					}
				}
			}
		}
		System.out.println();
	}
	
/**
* StringMatrixを標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(StringMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 10){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
}