import jp.ac.takushoku_u.cs.*;

/**
* SSAnalysisクラスのテスト用クラス
* @version 1.1
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年01月11日
*/
class SSAnalysisTest{

public static void main(String[] args){
	
	//アンケートデータ
	//このアンケートは1から5までの5段階評定で、
	//項目数が5つあるアンケートを10人に取ったというものです
	double[][] sampleData = {
		{5,5,4,5,4},
		{5,4,5,2,5},
		{5,3,5,2,5},
		{5,5,2,4,2},
		{5,5,2,3,1},
		{4,4,2,3,1},
		{4,2,4,2,1},
		{3,2,3,2,1},
		{3,3,1,2,1},
		{3,1,2,1,1}};
	
	//アンケートデータをMatrixへ格納
	ArithmeticMatrix dataMatrix = new ArithmeticMatrix(sampleData);
	
	//行名の命名
	for(int i = 1; i <= sampleData.length; i++){
		dataMatrix.setRowName(i-1,"学習者" + i);
	}
	
	//列名の命名
	for(int i = 1; i <= sampleData[0].length; i++){
		dataMatrix.setColName(i-1,"項目" + i);
	}
	
	//SS分析を行う
	SSAnalysis result = new SSAnalysis(dataMatrix);
	
	//計算結果である
	//順序性係数マトリクスを求める
	ArithmeticMatrix outCofficient = new ArithmeticMatrix(5,5);
	outCofficient.matrixCopy(result.getCoefficientMatrix());	//結果をArithmeticMatrixで収得
	System.out.println("順序性係数マトリクス");
	outputDoubleMatrix(outCofficient);		//出力
	
	//分析結果である
	//SSマトリクスを求める
	ArithmeticMatrix outSSMatrix = new ArithmeticMatrix(5,5);
	outSSMatrix.matrixCopy(result.getSSMatrix());	//結果をArithmeticMatrixで収得
	System.out.println("SSマトリクス");
	outputMatrix(outSSMatrix);		//出力
	
	//分析結果を図示化する
	//スケルトンマトリクスを求める
	ArithmeticMatrix outSkeletonMatrix = new ArithmeticMatrix(5,5);
	outSkeletonMatrix.matrixCopy(result.getSkeletonMatrix());	//結果をArithmeticMatrixで収得
	System.out.println("スケルトンマトリクス");
	outputMatrix(outSkeletonMatrix);		//出力
}
	
/**
* マトリクスをint型で標準出力に出力します。
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//小数点以下3桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	
}
