import jp.ac.takushoku_u.cs.*;

/**
* SPTableクラスのテスト用クラス
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年01月08日
*/
class SPTableTest{

public static void main(String[] args){

	double[][] sampleData = { //SP表データ
	
		{1,1,1,1,0,1},
		{1,0,0,1,0,1},
		{1,0,0,1,1,0},
		{1,0,1,1,0,0},
		{1,1,1,1,0,0},
		{1,1,0,0,0,0},
		{1,0,1,0,1,1}};

	//分析対象のマトリクスを生成
	ArithmeticMatrix dataMatrix = new ArithmeticMatrix(sampleData);
	
	//マトリクスに行名と列名を付ける
	for(int i = 1; i <= sampleData.length; i++){
		dataMatrix.setRowName(i-1,"生徒" + i + " ");
	}
	for(int i = 1; i <= sampleData[0].length; i++){
		dataMatrix.setColName(i-1,"問" + i + " ");
	}
	
	//SP表作成を行う
	SPTable result = new SPTable(dataMatrix);
	
	ArithmeticMatrix outMatrix = new ArithmeticMatrix();
	outMatrix.matrixCopy(result.getBaseSPMatrix());
	System.out.println("元のマトリクス");
	outputMatrix(outMatrix);
	
	ArithmeticMatrix outSPMatrix = new ArithmeticMatrix();
	outSPMatrix.matrixCopy(result.getSPMatrix());
	System.out.println("SPマトリクス");
	outputMatrix(outSPMatrix);
	
	ArithmeticMatrix outSPFullMatrix = new ArithmeticMatrix();
	outSPFullMatrix.matrixCopy(result.getSPFullMatrix());
	System.out.println("SPマトリクス-完全版");
	outputDoubleMatrix(outSPFullMatrix);
	
	int[] row = new int[sampleData.length];
	int[] col = new int[sampleData[0].length];
	System.arraycopy(result.getSArray(), 0, row, 0, row.length);
	System.arraycopy(result.getPArray(), 0, col, 0, col.length);
	System.out.print("S曲線: ");
	for(int i = 0; i < row.length; i++){
		System.out.print((row[i]) + ", ");
	}
	System.out.println();
	System.out.print("P曲線: ");
	for(int i = 0; i < col.length; i++){
		System.out.print((col[i]) + ", ");
	}
	System.out.println();
	
}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("            ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + "  ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* S-P表のマトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.00");		//小数点以下2桁まで出力
		System.out.print("            ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + "  ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			if(i < outMatrix.getRowLength() - 4 || i == outMatrix.getRowLength() - 3){
				System.out.print("    ");
			}
			else if(i == outMatrix.getRowLength() - 4 || i == outMatrix.getRowLength() - 2){
				System.out.print("  ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+"  ");
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをString型で標準出力に出力します。
*/
	private static void outputMatrix(StringMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
}
