import jp.ac.takushoku_u.cs.*;

/**
* ReadTestクラスはMatrixReaderクラスのテスト用クラスです。
* 本クラスの実行には、マトリクスを生成するテキストファイルが必要です。<BR>
* 実行コマンド例<BR>
* java ReadTest Ga.txt
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日2005年01月08日
*/

class ReadTest{
	public static void main(String[] args){
		
		try{
			//実行時に指定されたテキストファイルを読みArithmeticMatrixを生成します
			//そしてそのマトリクスをoutputMatrixによって出力します
			outputMatrix(MatrixReader.getArithmeticMatrixReader(args[0]));
			
			//実行時に指定されたテキストファイルを読みBooleanMatrixを生成します
			//そしてそのマトリクスをoutputMatrixによって出力します
			outputMatrix(MatrixReader.getBooleanMatrixReader(args[0]));
		}
		catch(Exception e){
			System.out.println(e);
		}
		
	}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("     ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			if(j < 9){
			System.out.print(outMatrix.getColName(j) + "  ");
			}
			else{
				System.out.print(outMatrix.getColName(j) + " ");
			}
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("  "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("  "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.00");		//小数点以下2桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+"  ");
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをboolean型で標準出力に出力します。
*/
	private static void outputMatrix(BooleanMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
					if(outMatrix.getCell(i, j)){
						System.out.print(" ");
					}
				}
			}
		}
		System.out.println();
	}
}