import jp.ac.takushoku_u.cs.*;

/**
* MathEdgeクラスのテストクラス<br>
* 実行にはLFTAnalysisクラスが必要です。
* @version 1.1
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年01月10日
*/
class MathEdgeTest{

public static void main(String[] args){

	boolean[][] sampleData = { //教授者のマトリクスデータ
		    {false,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{false,true,true,true,false,false,false,false,false},
			{false,false,false,false,true,false,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,true,true,false}};
	
		boolean[][] sampleData2 = { //学習者のマトリクスデータ (7,6)がない
		    {false,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{false,true,true,true,false,false,false,false,false},
			{false,false,false,false,true,false,false,false,false},
			{false,false,false,false,false,false,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,true,true,false}};
	
	String[] name = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8","要素9"};
	
	//マトリクスの生成
	BooleanMatrix dataMatrix = new BooleanMatrix(sampleData, name, name);
	BooleanMatrix dataMatrix2 = new BooleanMatrix(sampleData2, name, name);
	
	//LFT分析を行う
	LFTAnalysis result = new LFTAnalysis(dataMatrix, dataMatrix2);
	
	//マトリクスの(6,5)の要素対集合を集合として出力する(setA)
	EdgeSet hashSet = new EdgeSet();
	hashSet = result.getElementPairSet(dataMatrix, 
		dataMatrix.getRowNumber("要素6"), dataMatrix.getColNumber("要素5"));
	Object o[] = new Object[hashSet.size()];
	Edge d[] = new Edge[hashSet.size()];
	o = hashSet.toArray();
	System.out.println("setA:枝(6,5)の要素対集合");
	//要素の出力
    for(int i = 0; i < hashSet.size(); i++){
    	d[i] = (Edge)o[i];
    	System.out.print("("+(d[i].getBegin()+1)+","+(d[i].getEnd()+1)+"),");
    }
	
	System.out.println();
	System.out.println("その要素数: "+hashSet.size());
	System.out.println();
	
	//マトリクスの(5,4)の要素対集合を集合として出力する(setB)
	EdgeSet hSet = new EdgeSet();
	hSet = result.getElementPairSet(dataMatrix, 
		dataMatrix.getRowNumber("要素5"), dataMatrix.getColNumber("要素4"));
	Object op[] = new Object[hSet.size()];
	Edge de[] = new Edge[hSet.size()];
	op = hSet.toArray();
	System.out.println("setB:枝(5,4)の要素対集合");
    for(int i = 0; i < hSet.size(); i++){
    	de[i] = (Edge)op[i];
    	System.out.print("("+(de[i].getBegin()+1)+","+(de[i].getEnd()+1)+"),");
    }
	
	System.out.println();
	System.out.println("その要素数: "+hSet.size());
	System.out.println();
	
	
	//論理積を求める
	EdgeSet rSet = MathEdge.getAndEdge(hashSet, hSet);
	Object p[] = new Object[rSet.size()];
	Edge e[] = new Edge[rSet.size()];
	p = rSet.toArray();
	System.out.println("積集合");
	//要素の出力
    for(int i = 0; i < rSet.size(); i++){
    	e[i] = (Edge)p[i];
    	System.out.print("("+(e[i].getBegin()+1)+","+(e[i].getEnd()+1)+"),");
    }
	System.out.println();
	//要素数の出力
	System.out.println("その要素数: "+rSet.size());
	System.out.println();
	
	//論理和を求める
	EdgeSet sSet = MathEdge.getOrEdge(hashSet, hSet);
	Object q[] = new Object[sSet.size()];
	Edge f[] = new Edge[sSet.size()];
	q = sSet.toArray();
	System.out.println("和集合");
    for(int i = 0; i < sSet.size(); i++){
    	f[i] = (Edge)q[i];
    	System.out.print("("+(f[i].getBegin()+1)+","+(f[i].getEnd()+1)+"),");
    }
	System.out.println();
	System.out.println("その要素数: "+sSet.size());
	System.out.println();
	
	//差を求める(setA - setB)
	EdgeSet tSet = MathEdge.getSubEdge(hashSet, hSet);
	Object r[] = new Object[tSet.size()];
	Edge g[] = new Edge[tSet.size()];
	r = tSet.toArray();
	System.out.println("setAの差集合");
    for(int i = 0; i < tSet.size(); i++){
    	g[i] = (Edge)r[i];
    	System.out.print("("+(g[i].getBegin()+1)+","+(g[i].getEnd()+1)+"),");
    }
	System.out.println();
	System.out.println("その要素数: "+tSet.size());
	System.out.println();
	
	//差を求める(setB - setA)
	EdgeSet tbSet = MathEdge.getSubEdge(hSet, hashSet);
	Object rb[] = new Object[tSet.size()];
	Edge gb[] = new Edge[tSet.size()];
	rb = tbSet.toArray();
	System.out.println("setBの差集合");
    for(int i = 0; i < tbSet.size(); i++){
    	gb[i] = (Edge)rb[i];
    	System.out.print("("+(gb[i].getBegin()+1)+","+(gb[i].getEnd()+1)+"),");
    }
	System.out.println();
	System.out.println("その要素数: "+tbSet.size());
	System.out.println();
	
	//排他的論理和を求める
	EdgeSet uSet = MathEdge.getXOrEdge(hashSet, hSet);
	Object s[] = new Object[uSet.size()];
	Edge h[] = new Edge[uSet.size()];
	s = uSet.toArray();
	System.out.println("排他的論理和");
    for(int i = 0; i < uSet.size(); i++){
    	h[i] = (Edge)s[i];
    	System.out.print("("+(h[i].getBegin()+1)+","+(h[i].getEnd()+1)+"),");
    }
	System.out.println();
	System.out.println("その要素数: "+uSet.size());
	System.out.println();
	
}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//小数点以下3桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをboolean型で標準出力に出力します。
*/
	private static void outputMatrix(BooleanMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
					if(outMatrix.getCell(i, j)){
						System.out.print(" ");
					}
				}
			}
		}
		System.out.println();
	}
	
/**
* StringMatrixを標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(StringMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
}
