import jp.ac.takushoku_u.cs.*;

/**
* LFTAnalysisクラスのテスト用クラス
* @version 1.3
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年01月08日
*/
class LFTAnalysisTest{

public static void main(String[] args){

	boolean[][] sampleData = { //教授者のマトリクスデータ
		    {false,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{false,true,true,true,false,false,false,false,false},
			{false,false,false,false,true,false,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,true,true,false}};
	
		boolean[][] sampleData2 = { //学習者のマトリクスデータ 教授者に比べ(7,6)がない
		    {false,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{true,false,false,false,false,false,false,false,false},
			{false,true,true,true,false,false,false,false,false},
			{false,false,false,false,true,false,false,false,false},
			{false,false,false,false,false,false,false,false,false},
			{false,false,false,false,false,true,false,false,false},
			{false,false,false,false,false,true,true,true,false}};
	
	String[] name = {"要素1","要素2","要素3","要素4","要素5","要素6","要素7","要素8","要素9"};
	
	//マトリクスの生成
	BooleanMatrix dataMatrix = new BooleanMatrix(sampleData, name, name);
	BooleanMatrix dataMatrix2 = new BooleanMatrix(sampleData2, name, name);
	
	//LFT分析を行う
	LFTAnalysis result = new LFTAnalysis(dataMatrix, dataMatrix2);
	
	//教授者のマトリクスを出力する
	BooleanMatrix outTeacherMatrix = new BooleanMatrix(5,5);
	//教授者のマトリクスの収得
	outTeacherMatrix.matrixCopy(result.getTeacherMatrix());
	System.out.println("教授者のマトリクス");
	//マトリクスの出力
	outputMatrix(outTeacherMatrix);
	
	//教授者のマトリクスと学習者のマトリクスを1つにし出力する
	StringMatrix outBlendStringMatrix = new StringMatrix(9,9);
	outBlendStringMatrix.matrixCopy(result.getBlendStringMatrix());
	System.out.println("教授者のマトリクスと学習者のマトリクスを一緒に表したマトリクス");
	System.out.println("両者なし = 0, 両者あり = 1, 教授者のみ = T, 学習者のみ = S");
	outputMatrix(outBlendStringMatrix);
	
	//教授者のマトリクスにある枝の重要度を出力する
	ArithmeticMatrix outEdgeMatrix = new ArithmeticMatrix(9,9);
	outEdgeMatrix.matrixCopy(result.getEdgeTeacherMatrix());
	System.out.println("教授者の枝の重要度を表したマトリクス");
	outputDoubleMatrix(outEdgeMatrix);
	
	//教授者の可到達マトリクスを出力する
	BooleanMatrix outReachMatrix = new BooleanMatrix(9,9);
	outReachMatrix.matrixCopy(result.getReachTeacherMatrix());
	System.out.println("教授者の可到達マトリクス");
	outputMatrix(outReachMatrix);
	
	//教授者マトリクスの(6,5)の要素対集合を出力する
	BooleanMatrix outPairMatrix = new BooleanMatrix(9,9);
	outPairMatrix.matrixCopy(result.getElementPairMatrix(dataMatrix, 
		dataMatrix.getRowNumber("要素6"), dataMatrix.getColNumber("要素5")));
	System.out.println("教授者のマトリクスにおいて、枝(6,5)の要素対集合マトリクス");
	outputMatrix(outPairMatrix);
	
	System.out.println("要素対の要素数 = " + outPairMatrix.getElement());
	System.out.println();
	
	//計算で求められた値
	System.out.println("類似度= " + result.getResemble());
	System.out.println("到達度= " + result.getAttainment());
	System.out.println("教授者の枝= " + result.getTeacherEdge());
	System.out.println("学習者の枝= " + result.getStudentEdge());
	System.out.println("一致枝= " + result.getAccordEdge());
	System.out.println("一方にでもある枝= " + result.getTotelEdge());
	System.out.println("学習者のみの枝= " + result.getStudentOnlyEdge());
	System.out.println("教授者のみの枝= " + result.getTeacherOnlyEdge());
}
	
/**
* マトリクスをint型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//小数点以下3桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをboolean型で標準出力に出力します。
*/
	private static void outputMatrix(BooleanMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(" "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print(" "+outMatrix.getCell(i, j));
					if(outMatrix.getCell(i, j)){
						System.out.print(" ");
					}
				}
			}
		}
		System.out.println();
	}
	
/**
* StringMatrixを標準出力に出力します。
* @param outMatrix 出力すべきマトリクス
*/
	private static void outputMatrix(StringMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
}
