import jp.ac.takushoku_u.cs.*;

/**
* LFGを描画するクラスに関するのテスト用クラス
* 本クラスを実行する際にはマトリクスを生成するためのテキストファイルが必要です。
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年03月07日
*/
class LFGTest{

public static void main(String[] args){

	//マトリクスの生成
	BooleanMatrix dataMatrix = new BooleanMatrix();
	
	//生成したマトリクスにデータを入れる。
	//テキストファイルの読み込み
	try{
		dataMatrix.matrixCopy(MatrixReader.getBooleanMatrixReader(args[0]));
	}
	catch(Exception e){
		System.out.println(e);
	}
	
	
	//配置を決定する
	//IM法を利用しない場合
	//ArrangePoint ar = new ArrangePoint(dataMatrix);
	
	//IM法を利用する場合
	IMMethod im = new IMMethod(dataMatrix);
	ArrangePoint ar = new ArrangePoint(dataMatrix, im.getPaintLevel(), im.getPaintWideNumber());
	
	
	//実際の描画
	GraphPaint p = new GraphPaint(dataMatrix, ar.getPointArray());

}
	
}
