import jp.ac.takushoku_u.cs.*;

/**
* IRSAnalysisクラスのテスト用クラス
* @version 1.0
* @author 笠島 裕史(Kasajima Hiroshi)
*/
/*
* 最終更新日 2005年01月08日
*/
class IRSAnalysisTest{

public static void main(String[] args){

	double[][] sampleData = {
		{1,1,1,1,1,1},
		{1,1,1,1,1,1},
		{0,1,1,0,0,0},
		{0,1,1,0,0,0},
		{0,1,1,0,1,1},
		{0,0,1,0,1,1},
		{0,0,1,1,1,1},
		{0,0,0,1,1,1},
		{0,0,0,0,0,0},
		{0,0,0,0,0,0}};
	
	String[] rowName = {"生徒1","生徒2","生徒3","生徒4","生徒5",
		"生徒6","生徒7","生徒8","生徒9","生徒10"};
	String[] colName = {"項目1","項目2","項目3","項目4","項目5","項目6"};
	
	//分析を行うマトリクスの生成
	ArithmeticMatrix dataMatrix = new ArithmeticMatrix(sampleData, rowName, colName);
	
	//分析を行う
	IRSAnalysis result = new IRSAnalysis(dataMatrix);
	
	//しきい値の設定
	result.setThreshold(0.5);
	
	//分析対象のマトリクスの出力
	
	//出力用マトリクスの生成
	ArithmeticMatrix outMatrix = new ArithmeticMatrix(10,6);
	System.out.println("元のマトリクス");
	//マトリクスを収得
	outMatrix.matrixCopy(result.getMatrix());
	//マトリクスの出力
	outputMatrix(outMatrix);
	
	//順序性係数マトリクスの出力
	ArithmeticMatrix outCofficient = new ArithmeticMatrix(6,6);
	outCofficient.matrixCopy(result.getCoefficientMatrix());
	System.out.println("順序性係数マトリクス");
	outputDoubleMatrix(outCofficient);
	
	//分析結果であるIRSマトリクスの出力
	ArithmeticMatrix outIRSMatrix = new ArithmeticMatrix(6,6);
	outIRSMatrix.matrixCopy(result.getIRSMatrix());
	System.out.println("IRSマトリクス");
	outputMatrix(outIRSMatrix);
	
	//スケルトンマトリクスの出力
	ArithmeticMatrix outSkeletonMatrix = new ArithmeticMatrix(6,6);
	outSkeletonMatrix.matrixCopy(result.getSkeletonMatrix());
	System.out.println("スケルトンマトリクス");
	outputMatrix(outSkeletonMatrix);
	
	//枝の各順番の出力
	//出力は0から始まる要素番号で出力されます
	int[] col = new int[sampleData[0].length];
	System.arraycopy(result.getGraphElementArray(), 0, col, 0, col.length);
	System.out.print("枝を書く順: ");
	for(int i = 0; i < col.length; i++){
		System.out.print((col[i]) + ", ");
	}
}
	
/**
* マトリクスをint型で標準出力に出力します。
*/
	private static void outputMatrix(ArithmeticMatrix outMatrix){
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){		//列名出力
			System.out.print(outMatrix.getColName(j) + " ");
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			if(i < 9){
			System.out.print(outMatrix.getRowName(i) + " ");		//行名出力
			}
			else{
				System.out.print(outMatrix.getRowName(i) + " ");
			}
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println("     "+(int)outMatrix.getCell(i, j));
				}
				else{
					System.out.print("     "+(int)outMatrix.getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* マトリクスをdouble型で標準出力に出力します。
*/
	private static void outputDoubleMatrix(ArithmeticMatrix outMatrix){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//小数点以下3桁まで出力
		System.out.print("       ");
		for(int j = 0; j < outMatrix.getColLength(); j++){
			System.out.print(outMatrix.getColName(j) + " ");		//列名出力
		}
		System.out.println();
		for(int i = 0 ; i < outMatrix.getRowLength(); i++){
			System.out.print(outMatrix.getRowName(i) + "  ");		//行名出力
			for(int j = 0; j < outMatrix.getColLength(); j++){		//要素出力
				if(j == (outMatrix.getColLength() - 1)){
					System.out.println(df.format(outMatrix.getCell(i, j)));
				}
				else{
					System.out.print(df.format(outMatrix.getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	
}
