package jp.ac.takushoku_u.cs;

/**
* SPTable饹S-PɽԤ饹Ǥ
* @version 1.1.1
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1206
*/
public class SPTable{
	
/**
* SPɽΥǡݻޥȥꥯ
*/
	private ArithmeticMatrix matrix;
	
/**
* ¤ؤ塢ιԤϸϲܤǤäֹݻ
*/
	private int[] baseRow;
	
/**
* ¤ؤ塢ϸϲܤǤäֹݻ
*/
	private int[] baseCol;
	
/** 
* եޡɽѤǡեޡϤΨȽ͡
*/
	private static final double SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 = 0.85;
	
/**
* եޡɽѤǡեޡ``!''ϤʤФʤʤշͤɽ
*/
	private static final double SPTABLE_CAUTION_MARK_CAUTION_VALUE1 = 0.5;
	
/**
* եޡɽѤǡեޡ``!!''ϤʤФʤʤշͤɽ
*/
	private static final double SPTABLE_CAUTION_MARK_CAUTION_VALUE2 = 0.75;
	
/**
* եޡɽʤ򼨤ɽ
*/
	private static final int SPTABLE_CAUTION_MARK_NON = 0;
	
/**
* եޡɽʤɽ
*/
	private static final String SPTABLE_CAUTION_MARK_NONSTRING = "";
	
/**
* եޡ``!''򼨤ɽ
*/
	private static final int SPTABLE_CAUTION_MARK_ONE = 1;
	
/**
* եޡ``!''ɽɽ
*/
	private static final String SPTABLE_CAUTION_MARK_ONESTRING = "!";
	
/**
* եޡ''!!``򼨤ɽ
*/
	private static final int SPTABLE_CAUTION_MARK_TWO = 2;
	
/**
* եޡ''!!``ɽɽ
*/
	private static final String SPTABLE_CAUTION_MARK_TWOSTRING = "!!";
	
/**
* ޥȥꥯΥǥե͡
*/
	private static final int SPTABLE_MATRIX_VALUE = 5;
	
	
/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷʬϤԤޤ<BR>
* ޥȥꥯǤ0Ȥʤޤ
*/
	public SPTable(){
		ArithmeticMatrix baseMatrix = new ArithmeticMatrix(SPTABLE_MATRIX_VALUE, SPTABLE_MATRIX_VALUE);
		setSPMatrix(baseMatrix);
	}
	
/**
* S-PɽޥȥꥯꤷʬϤԤޤ
* @param baseMatrix SPɽޥȥꥯ
*/
	public SPTable(ArithmeticMatrix baseMatrix){
		setSPMatrix(baseMatrix);
	}
	
/**
* S-Pɽ֤ޤ
* @return S-Pɽ
* @see #getSPFullMatrix()
*/
	public ArithmeticMatrix getSPMatrix(){
		baseRow = arrangeArray(matrix.getRowSumArray());
		baseCol = arrangeArray(matrix.getColSumArray());
		
		ArithmeticMatrix changeMatrix = new ArithmeticMatrix();
		changeMatrix.matrixCopy(matrix);
		changeMatrix.matrixCopy(getStudentChangeMatrix(matrix, baseRow));
		changeMatrix.matrixCopy(getProblemChangeMatrix(changeMatrix, baseCol));
		
		//¤ؤ̤S-Pɽɲ
		for (int i = 0; i < changeMatrix.getRowLength(); i++){
			changeMatrix.setRowName(i, matrix.getRowName(baseRow[i]));
		}
		for (int j = 0; j < changeMatrix.getColLength(); j++){
			changeMatrix.setColName(j, matrix.getColName(baseCol[j]));
		}
		
		return changeMatrix;
	}
		
/**
* շͤޤ᤿S-Pɽ֤ޤ<BR>
* ޥȥꥯԿΨշ͡եޡޤޤޤ
* S-PɽΥޥȥꥯ٥4ԡ4ʬ礭ʤäƤޤ
* եޡϿɽ졢`!'`1'`!!'`2'Ȥʤޤ
* @return շͤޤ᤿S-Pɽ
* @see #getSPMatrix()
* @see #getSPStringMatrix()
*/
	public ArithmeticMatrix getSPFullMatrix(){
		String rowName[] = new String[matrix.getRowLength()+4];
		String colName[] = new String[matrix.getColLength()+4];
		
		System.arraycopy(matrix.getRowNameArray(), 0, rowName, 0, matrix.getRowLength());
		System.arraycopy(matrix.getColNameArray(), 0, colName, 0, matrix.getColLength());
		rowName[matrix.getRowLength()] = "Կ";
		rowName[matrix.getRowLength()+1] = "Ψ";
		rowName[matrix.getRowLength()+2] = "շ";
		rowName[matrix.getRowLength()+3] = "եޡ";
		
		colName[matrix.getColLength()] = "";
		colName[matrix.getColLength()+1] = "Ψ";
		colName[matrix.getColLength()+2] = "շ";
		colName[matrix.getColLength()+3] = "եޡ";
		
		ArithmeticMatrix spFullMatrix = new ArithmeticMatrix(matrix.getRowLength()+4,matrix.getColLength()+4, rowName, colName);
		ArithmeticMatrix spMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength());
		spMatrix.matrixCopy(getSPMatrix());
		
		//S-PɽΥԡ
		spFullMatrix.matrixCopy(spMatrix, 0, 0, 0, 0, spMatrix.getRowLength(), spMatrix.getColLength());
		
		//¦ν
		for(int i = 0; i < spMatrix.getRowLength(); i++){
			spFullMatrix.setRowName(i, spMatrix.getRowName(i));		//̾ԡ
			spFullMatrix.setCell(i,matrix.getColLength(),getStudentSum(getBaseRow(i)));		//
			spFullMatrix.setCell(i,matrix.getColLength()+1,getStudentAverage(getBaseRow(i)));		//ʿΨ
			spFullMatrix.setCell(i,matrix.getColLength()+2,getStudentAttentionCoefficient(getBaseRow(i)));		//շ
			spFullMatrix.setCell(i,matrix.getColLength()+3, getStudentAttentionNumber(getBaseRow(i)));		//եޡ
		}
		
		//¦ν
		for(int j = 0; j < spMatrix.getColLength(); j++){
			spFullMatrix.setColName(j, spMatrix.getColName(j));		//̾ԡ
			spFullMatrix.setCell(matrix.getRowLength(), j,getProblemSum(getBaseCol(j)));		//Կ
			spFullMatrix.setCell(matrix.getRowLength()+1, j,getProblemAverage(getBaseCol(j)));		//ʿΨ
			spFullMatrix.setCell(matrix.getRowLength()+2, j,getProblemAttentionCoefficient(getBaseCol(j)));		//շ
			spFullMatrix.setCell(matrix.getRowLength()+3, j,getProblemAttentionNumber(getBaseCol(j)));		//եޡ
		}
		
		//ΤʿΨɲ
		spFullMatrix.setCell(getStudentNumber()+1, getProblemNumber()+1, getAverage());
		return spFullMatrix;
	}
	
/**
* շͤޤ᤿S-Pɽ֤ޤ<BR>
* ޥȥꥯԿΨշ͡եޡޤޤޤ
* S-PɽΥޥȥꥯ٥4ԡ4ʬ礭ʤäƤޤ
* եޡ`!'`!!'ɽޤ
* @return շͤޤ᤿S-Pɽ
* @see #getSPMatrix()
* @see #getSPFullMatrix()
*/
	public StringMatrix getSPStringMatrix(){
		String rowName[] = new String[matrix.getRowLength()+4];
		String colName[] = new String[matrix.getColLength()+4];
		
		System.arraycopy(matrix.getRowNameArray(), 0, rowName, 0, matrix.getRowLength());
		System.arraycopy(matrix.getColNameArray(), 0, colName, 0, matrix.getColLength());
		rowName[matrix.getRowLength()] = "Կ";
		rowName[matrix.getRowLength()+1] = "Ψ";
		rowName[matrix.getRowLength()+2] = "շ";
		rowName[matrix.getRowLength()+3] = "եޡ";
		
		colName[matrix.getColLength()] = "";
		colName[matrix.getColLength()+1] = "Ψ";
		colName[matrix.getColLength()+2] = "շ";
		colName[matrix.getColLength()+3] = "եޡ";
		
		StringMatrix spFullMatrix = new StringMatrix(matrix.getRowLength()+4,matrix.getColLength()+4, rowName, colName);
		ArithmeticMatrix spMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength());
		spMatrix.matrixCopy(getSPMatrix());
		
		//S-PɽΥԡ
		spFullMatrix.matrixCopy(spMatrix.toStringMatrix(), 0, 0, 0, 0, spMatrix.getRowLength(), spMatrix.getColLength());
		
		//¦ν
		for(int i = 0; i < spMatrix.getRowLength(); i++){
			spFullMatrix.setRowName(i, spMatrix.getRowName(i));		//̾ԡ
			spFullMatrix.setCell(i,matrix.getColLength(),getStudentSum(getBaseRow(i))+"");		//
			spFullMatrix.setCell(i,matrix.getColLength()+1,getStudentAverage(getBaseRow(i))+"");		//ʿΨ
			spFullMatrix.setCell(i,matrix.getColLength()+2,getStudentAttentionCoefficient(getBaseRow(i))+"");		//շ
			spFullMatrix.setCell(i,matrix.getColLength()+3, getStudentAttentionMark(getBaseRow(i)));		//եޡ
		}
		
		//¦ν
		for(int j = 0; j < spMatrix.getColLength(); j++){
			spFullMatrix.setColName(j, spMatrix.getColName(j));		//̾ԡ
			spFullMatrix.setCell(matrix.getRowLength(), j,getProblemSum(getBaseCol(j))+"");		//Կ
			spFullMatrix.setCell(matrix.getRowLength()+1, j,getProblemAverage(getBaseCol(j))+"");		//ʿΨ
			spFullMatrix.setCell(matrix.getRowLength()+2, j,getProblemAttentionCoefficient(getBaseCol(j))+"");		//շ
			spFullMatrix.setCell(matrix.getRowLength()+3, j,getProblemAttentionMark(getBaseCol(j)));		//եޡ
		}
		
		//ΤʿΨɲ
		spFullMatrix.setCell(getStudentNumber()+1, getProblemNumber()+1, getAverage()+"");
		return spFullMatrix;
	}
	
/**
* (ޤԿ)¿¤ؤޤ
* @param totalArray ()줿
* @return ¤ؤϸβܤˤä򼨤ޤ
*/
	private int[] arrangeArray(double[] totalArray){
		int number; //ιֹݻ
		int[] returnArray = new int[totalArray.length];
		
		//ñˡǥ
		for (int i = 0; i < totalArray.length; i++){
			number = i;
			for (int j = 0; j < totalArray.length; j++){ 
				if (totalArray[number] < (int)totalArray[j]){
					number = j;
				}
			}
			totalArray[number] = -1;
			returnArray[i] = number;
		}
		return returnArray;
	}
	
/**
* ¿¤ؤޥȥꥯ֤ޤ
* @param baseMatrix ʬϸΥޥȥꥯ
* @param row ֹ¿¤ؤ
* @return ¤ؤޥȥꥯ
*/
	private ArithmeticMatrix getStudentChangeMatrix(ArithmeticMatrix baseMatrix,int[] row){
		ArithmeticMatrix rowChangeMatrix = new ArithmeticMatrix();
		rowChangeMatrix.matrixCopy(baseMatrix);
		int max = (int) baseMatrix.getRowSum(row[0]); //λ(ǼκǾ)
		max++;
		int roop = 1; //Ʊ³Ƥ뤫
		for (int i = 0; i < baseMatrix.getRowLength(); i++){
			
			//ǤγǼ
			for (int j = 0; j < baseMatrix.getColLength(); j++){
				rowChangeMatrix.setCell(i, j, baseMatrix.getCell(row[i], j));
			}
			
			//ǼƱ̤ʤ
			if (max > baseMatrix.getRowSum(row[i])){
				roop = 1;
				max = (int)baseMatrix.getRowSum(row[i]);
			}
			//Ʊ
			else{
				roop++;
				int compareI = i; //Ӥݤi
				for (int k = 1; k < roop; k++){
					//2ԤӤTureξϸ򴹤Ԥ
					if (compareStudent(baseMatrix, row[compareI-1], row[compareI])){
						//ιֹǼθ
						int temp = row[compareI];
						row[compareI] = row[compareI-1];
						row[compareI-1] = temp;
						
						//Ǥθ
						for (int m = 0; m < baseMatrix.getColLength(); m++){
							rowChangeMatrix.setCell(compareI-1, m, baseMatrix.getCell(row[compareI-1], m));
							rowChangeMatrix.setCell(compareI, m, baseMatrix.getCell(row[compareI], m));
						}
						compareI--;
					}
					else{
						//롼פȴ
						k = roop;
					}
				}
			}
		}
		return rowChangeMatrix;
	}
	
/**
* Կ¿¤ؤޥȥꥯ֤ޤ
* @param baseMatrix Ԥ¿¤ؤäޥȥꥯ
* @param col ֹԿ¿¤ؤ
* @return ¤ؤޥȥꥯ
*/
	private ArithmeticMatrix getProblemChangeMatrix(ArithmeticMatrix baseMatrix,int[] col){
		ArithmeticMatrix colChangeMatrix = new ArithmeticMatrix();
		colChangeMatrix.matrixCopy(baseMatrix);
		int max = (int) baseMatrix.getColSum(col[0]); //λ(ǼκǾ)
		max++;
		int roop = 1; //Ʊ³Ƥ뤫
		for (int i = 0; i < baseMatrix.getColLength(); i++){
			
			//ǤγǼ
			for (int j = 0; j < baseMatrix.getRowLength(); j++){
				colChangeMatrix.setCell(j, i, baseMatrix.getCell(j, col[i]));
			}
			
			//ǼƱԿ꤬ʤ
			if (max > baseMatrix.getColSum(col[i])){
				roop = 1;
				max = (int) baseMatrix.getColSum(col[i]);
			}
			//ƱԿ
			else{
				roop++;
				int compareI = i; //Ӥݤi
				for (int k = 1; k < roop; k++){
					//2ԤӤTureξϸ򴹤Ԥ
					if (compareProblem(baseMatrix, col[compareI-1], col[compareI])){
						//ιֹǼθ
						int temp = col[compareI];
						col[compareI] = col[compareI-1];
						col[compareI-1] = temp;
						
						//Ǥθ
						for (int m = 0; m < baseMatrix.getRowLength(); m++){
							colChangeMatrix.setCell(m, compareI-1, baseMatrix.getCell(m, col[compareI-1]));
							colChangeMatrix.setCell(m, compareI, baseMatrix.getCell(m, col[compareI]));
						}
						compareI--;
					}
					else{
						//롼פȴ
						k = roop;
					}
				}
			}
		}
		return colChangeMatrix;
	}
	
/**
* ƱƱΤӤޤ
* @param baseMatrix ؤԤΥޥȥꥯ
* @param studentA Ӥֹ1
* @param studentB Ӥֹ2
* @return ӷ̤ 1 < 2 λ True  1 >= 2 λ False ֤ޤ
*/
	private boolean compareStudent(ArithmeticMatrix baseMatrix, int studentA, int studentB){
		int studentATotal = 0; //̤
		int studentBTotal = 0;
		for (int i = 0; i < baseMatrix.getColLength(); i++){
			studentATotal = (int) baseMatrix.getCell(studentA, i) * 
				(int) baseMatrix.getColSum(i) + studentATotal;
			studentBTotal = (int) baseMatrix.getCell(studentB, i) * 
				(int) baseMatrix.getColSum(i) + studentBTotal;
		}
		return studentATotal < studentBTotal;
	}
/**
* ƱԿƱΤӤޤ
* @param baseMatrix ؤԤΥޥȥꥯ
* @param problemA Ӥֹ1
* @param problemB Ӥֹ2
* @return ӷ̤ 1 < 2 λ True  1 >= 2 λ False ֤ޤ
*/
	private boolean compareProblem(ArithmeticMatrix baseMatrix, int problemA, int problemB){
		int problemATotal = 0; //ƤԿ
		int problemBTotal = 0;
		for (int i = 0; i < baseMatrix.getRowLength(); i++){
			problemATotal = (int) baseMatrix.getCell(i, problemA) * 
				(int) baseMatrix.getRowSum(i) + problemATotal;
			problemBTotal = (int) baseMatrix.getCell(i, problemB) * 
				(int) baseMatrix.getRowSum(i) + problemBTotal;
		}
		return problemATotal < problemBTotal;
	}
	
/**
* ꤷؽ()֤ޤ
* @param row ꤷؽԤ¤ؤιֹ
* @return ꤷؽԤ
* @exception NotItemException ꤷؽԤ¸ߤʤ
* @see #getProblemSum(int col)

*/
	public int getStudentSum(int row){
		if (matrix.isRowNumber(row)){
			return (int)matrix.getRowSum(row);
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* ꤷ()Կ֤ޤ
* ꤹ¤ؤֹ
* @return ꤷԿ
* @exception NotItemException ꤷ꤬¸ߤʤ
* @see #getStudentSum(int row)
*/
	public int getProblemSum(int col){
		if (matrix.isColNumber(col)){
			return (int)matrix.getColSum(col);
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* S֤ޤ
* ֹ椬S-PɽˤֹбƤޤ
* Ǽ줿ͤSΤֹ򼨤ޤ
* @return S
* @see #getPArray()
*/
	public int[] getSArray(){
		int sArray[] = new int[getStudentNumber()];
		for (int i = 0; i < getStudentNumber(); i++){
			sArray[i] = (int) matrix.getRowSum(getBaseRow(i));
		}
		return sArray;
	}
	
/**
* P֤ޤ
* ֹ椬S-PɽˤֹбƤޤ
* Ǽ줿ͤPľιֹ򼨤ޤ
* @return P
* @see #getSArray()
*/
	public int[] getPArray(){
		int pArray[] = new int[getProblemNumber()];
		for (int i = 0; i < getProblemNumber(); i++){
			pArray[i] = (int) matrix.getColSum(getBaseCol(i));
		}
		return pArray;
	}
	
/**
* ꤷؽ()Ψ֤ޤ
* @param row ꤹؽԤ¤ؤιֹ
* @return ꤷؽԤʿΨ
* @exception NotItemException ꤷؽԤ¸ߤʤ
* @see #getProblemAverage(int col)
*/
	public double getStudentAverage(int row){
		if (matrix.isRowNumber(row)){
			return getStudentSum(row) * 1.0 / getProblemNumber() * 100.0;
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
/**
* ꤷ()Ψ֤ޤ
* @param col ꤹ¤ؤֹ
* @return ꤷʿΨ
* @exception NotItemException ꤷ꤬¸ߤʤ
* @see #getStudentAverage(int row)
*/
	public double getProblemAverage(int col){
		if (matrix.isColNumber(col)){
			return getProblemSum(col) * 1.0 / getStudentNumber() * 100.0;
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* Τʿ֤ޤ
* @return ʿ
* @see #getProblemAverage()
* @see #getAverage()
*/
	public double getStudentAverage(){
		double value = 0.0;
		for (int i = 0; i < getStudentNumber(); i++){
			value = getStudentSum(i) + value;
		}
		return value / getStudentNumber();
	}
	
/**
* ΤʿԿ֤ޤ
* @return ʿԿ
* @see #getStudentAverage()
* @see #getAverage()
*/
	public double getProblemAverage(){
		double value = 0.0;
		for (int i = 0; i < getProblemNumber(); i++){
			value = getProblemSum(i) + value;
		}
		return value / getProblemNumber();
	}
	
/**
* S-PɽΤʿΨ֤ޤ
* @return ʿΨ
* @see #getStudentAverage()
* @see #getProblemAverage()
*/
	public double getAverage(){
		double value = 0.0;
		for (int i = 0; i < getStudentNumber(); i++){
			value = getStudentSum(i) + value;
		}
		return value * 100 / (getStudentNumber() * getProblemNumber());
	}
	
/**
* ꤷؽ()շ֤ޤ
* @param row ꤹؽԤ¤ؤιֹ
* @return ꤷؽԤշ
* @exception NotItemException ꤷؽԤ¸ߤʤ
* @see #getProblemAttentionCoefficient(int col)
*/
	public double getStudentAttentionCoefficient(int row){
		if (matrix.isRowNumber(row)){
		
		//Sμ
		int sArray[] = new int[getStudentNumber()];
		System.arraycopy(getSArray(), 0, sArray, 0, getStudentNumber());
		
		//SiS麸``0''бԿ
		double zeroProblem;
		
		//SiS鱦``1''бԿ
		double oneProblem;
		
		//SiS麸Կ
		double leftProblem;
		
		//
		double value;
			
			//0ξ(ð)
			if (getStudentSum(row) == 0.0){
				value = 1.0;
			}
			
			//ξ
			else if (getStudentSum(row) == getProblemNumber()){
				value = 0.0;
			}
			else{
				zeroProblem = 0.0;
				oneProblem = 0.0;
				leftProblem = 0.0;
				
				//S麸
				for (int j = 0; j < sArray[getSPRow(row)]; j++){
					if (matrix.getCell(row, getBaseCol(j)) == 0){
						zeroProblem = getProblemSum(getBaseCol(j)) + zeroProblem;
					}
					leftProblem = getProblemSum(getBaseCol(j)) + leftProblem;
				}
				
				//S걦
				for (int k = sArray[getSPRow(row)]; k < getProblemNumber(); k++){
					if (matrix.getCell(row, getBaseCol(k)) == 1){
						oneProblem = getProblemSum(getBaseCol(k)) + oneProblem;
					}
				}
				
				//շη׻
				value = (zeroProblem - oneProblem) / 
					(leftProblem - getStudentSum(row) * getProblemAverage());
			}
		return value;
	}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* ꤷ()շ֤ޤ
* @param col ꤹ¤ؤֹ
* @return ꤷշ
* @exception NotItemException ꤷ꤬¸ߤʤ
* @see #getStudentAttentionCoefficient(int row)
*/
	public double getProblemAttentionCoefficient(int col){
		if (matrix.isColNumber(col)){
		
		//Pμ
		int pArray[] = new int[getProblemNumber()];
		System.arraycopy(getPArray(), 0, pArray, 0, getProblemNumber());
		
		//IiP``0''б̤
		double zeroStudent;
		
		//IiP鲼``1''б̤
		double oneStudent;
		
		//IiP̤Ԥ
		double upStudent;
		
		//
		double value;
			
			//Կ0ξ(ð)
			if (getProblemSum(col) == 0.0){
				value = 1.0;
			}
			
			//ξ
			else if (getProblemSum(col) == getStudentNumber()){
				value = 0.0;
			}
			else{
				zeroStudent = 0.0;
				oneStudent = 0.0;
				upStudent = 0.0;
				
				//P
				for (int j = 0; j < pArray[getSPCol(col)]; j++){
					if (matrix.getCell(getBaseRow(j), col) == 0){
						zeroStudent = getStudentSum(getBaseRow(j)) + zeroStudent;
					}
					upStudent = getStudentSum(getBaseRow(j)) + upStudent;
				}
				
				//P겼
				for (int k = pArray[getSPCol(col)]; k < getStudentNumber(); k++){
					if (matrix.getCell(getBaseRow(k), col) == 1){
						oneStudent = getStudentSum(getBaseRow(k)) + oneStudent;
					}
				}
				
				//շη׻
				value = (zeroStudent - oneStudent) / 
					(upStudent - getProblemSum(col) * getStudentAverage());
			}
			return value;
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* ؽԤեޡ֤ޤ
* @param row ꤹؽԤ¤ؤιֹ
* @return ꤷؽԤեޡ
* @exception NotItemException ꤷؽԤ¸ߤʤ
* @see #getProblemAttentionMark(int col)
* @see #getStudentAttentionNumber(int row)
*/
	public String getStudentAttentionMark(int row){
		if (matrix.isRowNumber(row)){
		
		//շ
		double attention = getStudentAttentionCoefficient(row);
		
		//
		String mark;
			if (getStudentAverage(row) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWOSTRING;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONESTRING;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NONSTRING;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NONSTRING;
			}
			return mark;
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* եޡ֤ޤ
* @param col ꤹ¤ؤֹ
* @return ꤷեޡ
* @exception NotItemException ꤷ꤬¸ߤʤ
* @see #getStudentAttentionMark(int row)
* @see #getProblemAttentionNumber(int col)
*/
	public String getProblemAttentionMark(int col){
		if (matrix.isColNumber(col)){
		//շ
		double attention = getProblemAttentionCoefficient(col);
		
		//
		String mark;
		
			if (getProblemAverage(col) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWOSTRING;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONESTRING;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NONSTRING;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NONSTRING;
			}
			return mark;
	}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* ؽԤեޡ֤ޤ
* ޡʤξ0`!'ξ1`!!'ξ2Ǽޤ
* @param row ꤹؽԤ¤ؤιֹ
* @return ꤷؽԤեޡ
* @exception NotItemException ꤷؽԤ¸ߤʤ
* @see #getProblemAttentionNumber(int col)
* @see #getStudentAttentionMark(int row)
*/
	public int getStudentAttentionNumber(int row){
		if (matrix.isRowNumber(row)){
		//շ
		double attention = getStudentAttentionCoefficient(row);
		
		//
		int mark;
			if (getStudentAverage(row) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWO;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONE;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NON;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NON;
			}
			return mark;
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* եޡ֤ޤ
* ޡʤξ0`!'ξ1`!!'ξ2Ǽޤ
* @param col ꤹ¤ؤֹ
* @return ꤷեޡ
* @exception NotItemException ꤷ꤬¸ߤʤ
* @see #getStudentAttentionNumber(int row)
* @see #getProblemAttentionMark(int col)
*/
	public int getProblemAttentionNumber(int col){
		if (matrix.isColNumber(col)){
		//շ
		double attention = getProblemAttentionCoefficient(col);
		
		//
		int mark;
		
			if (getProblemAverage(col) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWO;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONE;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NON;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NON;
			}
			return mark;
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* S-PɽΥޥȥꥯ֤ޤ
* @return S-PɽΥޥȥꥯ
*/
	public ArithmeticMatrix getBaseSPMatrix(){
		return matrix;
	}
	
/**
* S-Pɽ¸ߤؽԿ(Կ)֤ޤ
* @return ؽԿ
* @see #getProblemNumber()
*/
	public int getStudentNumber(){
		return matrix.getRowLength();
	}
	
/**
* S-Pɽ¸ߤ()֤ޤ
* @return 
* @see #getStudentNumber()
*/
	public int getProblemNumber(){
		return matrix.getColLength();
	}
	
/**
* ꤷԤS-PɽΥޥȥꥯǤϲܤˤäιֹ֤ޤ
* @param row S-Pɽˤֹ
* @return ɽˤֹ
* @exception NotItemException ꤵ줿ֹ椬¸ߤʤ
* @see #getBaseCol(int col)
* @see #getBaseRowArray()
*/
	public int getBaseRow(int row){
		if (matrix.isRowNumber(row)){ //ޥȥꥯϰ⤫ɤĴ٤
		return baseRow[row];
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* S-PɽΥޥȥꥯǤϲܤˤäιֹ򼨤֤ޤ
* @return ֹä
* @see #getBaseColArray()
* @see #getBaseRow(int row)
*/
	public int[] getBaseRowArray(){
		return baseRow;
	}
	
/**
* ꤷS-PɽΥޥȥꥯǤϲܤˤäֹ֤ޤ
* @param col S-Pɽˤֹ
* @return ɽˤֹ
* @exception NotItemException ꤵ줿ֹ椬¸ߤʤ
* @see #getBaseRow(int row)
* @see #getBaseColArray()
*/
	public int getBaseCol(int col){
		if (matrix.isColNumber(col)){ //ޥȥꥯϰ⤫ɤĴ٤
		return baseCol[col];
		}
			else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* S-PɽΥޥȥꥯǤϲܤˤäֹ򼨤֤ޤ
* @return ֹä
* @see #getBaseRowArray()
* @see #getBaseCol(int col)
*/
	public int[] getBaseColArray(){
		return baseCol;
	}
	
/**
* ꤷԤS-PɽΥޥȥꥯǤϲܤˤ뤫ֹ֤ޤ
* @param row ɽˤֹ
* @return S-Pɽˤֹ
* @exception NotItemException ꤵ줿ֹ椬¸ߤʤ
*/
	private int getSPRow(int row){
		if (matrix.isRowNumber(row)){ //ޥȥꥯϰ⤫ɤĴ٤
			for(int i = 0; i < getStudentNumber(); i++){
				if(row == baseRow[i]){
					return i;
				}
			}
		}
			throw new NotItemException("row("+ row +")");
	}
	
/**
* ꤷS-PɽΥޥȥꥯǤϲܤˤ뤫ֹ֤ޤ
* @param col ɽˤֹ
* @return S-Pɽˤֹ
* @exception NotItemException ꤵ줿ֹ椬¸ߤʤ
*/
	private int getSPCol(int col){
		if (matrix.isColNumber(col)){ //ޥȥꥯϰ⤫ɤĴ٤
			for(int i = 0; i < getProblemNumber(); i++){
				if(col == baseCol[i]){
					return i;
				}
			}
		}
			throw new NotItemException("col("+ col +")");
	}
	
/**
* S-PɽΥޥȥꥯꤷޤ
* @param baseMatrix Ԥޥȥꥯ
*/
	private void setBaseMatrix(ArithmeticMatrix baseMatrix){
		matrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.matrixCopy(baseMatrix);
	}
	
/**
* ¤ؤιֹݻޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
*/
	private void setBaseRow(ArithmeticMatrix baseMatrix){
		baseRow = new int[baseMatrix.getRowLength()];
	}
	
/**
* ¤ؤֹݻޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
*/
	private void setBaseCol(ArithmeticMatrix baseMatrix){
		baseCol = new int[baseMatrix.getColLength()];
	}
	
/**
* S-Pɽ븵ȤʤޥȥꥯꤷS-Pɽޤ
* @param baseMatrix ԤȤʤޥȥꥯ
*/
	public void setSPMatrix(ArithmeticMatrix baseMatrix){
		setBaseMatrix(baseMatrix);
		setBaseRow(matrix);
		setBaseCol(matrix);
	}
	
/**
* S-Pɽ븵ȤʤޥȥꥯǤޤ
* @param row Ǥι
* @param col Ǥ
* @param value 
* @exception NotElementException ꤷǤ¸ߤʤ
* @exception ValueFormatException ͤ0ޤ1ʳͤǤ
* @see #setSPMatrix(ArithmeticMatrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			if(value == 0.0 || value == 1.0){
				matrix.setCell(row, col, value);
			}
			else{
				throw new ValueFormatException("value("+value+")");
			}
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
}