package jp.ac.takushoku_u.cs;

/**
* Range饹ϰϤݻ뤿Υ饹Ǥ
* ͤӡǾͤ NaN() Ǥϡ¸ߤ֤ʤפɽޤ
* @version 1.01
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0107
*/
public class Range{
	
/**
* ͤݻޤ
*/
	private double maxValue;
/**
* Ǿͤݻޤ
*/
	private double minValue;
/**
* ͤϰϤ˴ޤޤ뤫򼨤ޤ
*/
	private boolean includeMax;
/**
* ǾͤϰϤ˴ޤޤ뤫򼨤ޤ
*/
	private boolean includeMin;
/**
* ¸ߤ֤ʤɤޤ
*/
	private boolean empty = false;
	
/**
* ¸ߤ֤ʤΤȤκ͡
*/
	private static final double EMPTY_MAX = Double.NaN;
/**
* ¸ߤ֤ʤΤȤκǾ͡
*/
	private static final double EMPTY_MIN = Double.NaN;
	
/**
* ¸ߤ̵֤ Range ꤷޤ
*/
	public Range(){
		createEmpty();
	}
	
/**
* ֤ꤷ Range ꤷޤξü϶֤˴ޤޤޤ<BR>
* ǾͤȺͤΤ줫NaNǤϡ¸ߤ֤ʤפȤʤޤ
* @param min Ǿ
* @param max 
* @exception IllegalRelationValuesException ͤȺǾͤδطۤʤ
*/
	public Range(double min, double max){
		
		if(isExistRange(min, max)){
			setMax(max);
			setMin(min);
			setEmpty(false);
			setHasMax(true);
			setHasMin(true);
		}
		else if(Double.isNaN(min) || Double.isNaN(max)){
			createEmpty();
		}
		else{
			throw new IllegalRelationValuesException("min,max("+min+","+max+")");
		}
	}
	
/**
* ֤ꤷ Range ꤷޤ<BR>
* ǾͤȺͤΤ줫NaNǤϡ¸ߤ֤ʤפȤʤޤ
* @param min Ǿ
* @param max 
* @param isIncludeMin Ǿͤ˴ޤफ
* @param isIncludeMax ͤ˴ޤफ
* @exception IllegalRelationValuesException ͤȺǾͤδطۤʤ
*/
	public Range(double min, double max, boolean isIncludeMin, boolean isIncludeMax){
		
		if(isExistRange(min, max)){
			setMax(max);
			setMin(min);
			setEmpty(false);
			if(max != min){
				setHasMax(isIncludeMax);
				setHasMin(isIncludeMin);
			}
			else{
				setHasMax(true);
				setHasMin(true);
			}
		}
		else if(Double.isNaN(min) || Double.isNaN(max)){
			createEmpty();
		}
		else{
			throw new IllegalRelationValuesException("min,max("+ min +","+ max +")");
		}
	}
	
/**
* ֤κ֤ͤޤ<BR>
* ¸ߤ֤ʤפξNaN֤ޤ
* @return 
*/
	public double getMax(){
		return maxValue;
	}
	
/**
* ֤κǾ֤ͤޤ<BR>
* ¸ߤ֤ʤפξNaN֤ޤ
* @return Ǿ
*/
	public double getMin(){
		return minValue;
	}
	
/**
* ͤ϶֤˴ޤफ֤ޤ
* @return ֤˴ޤޤ true
*/
	public boolean hasMax(){
		return includeMax;
	}
	
/**
* Ǿͤ϶֤˴ޤफ֤ޤ
* @return ֤˴ޤޤ true
*/
	public boolean hasMin(){
		return includeMin;
	}
	
/**
* ¸ߤ֤ʤɤ֤ޤ
* @return ¸ߤ֤ʤʤ true
*/
	public boolean isEmpty(){
		return empty;
	}
	
/**
* ͤȺǾͤɤ֤ޤ
* @return ͤȺǾͤ true
*/
	public boolean isSame(){
		return getMax() == getMin();
	}
	
/**
* ꤷ֤ͤ˴ޤޤƤ뤫åޤ
* @param value ꤷ
* @return ꤷͤޤޤƤ true
*/
	public boolean hasValue(double value){
		boolean bo;
		if(isEmpty()){
			bo = false;
		}
		else if(getMin() < value && value < getMax()){
			bo = true;
		}
		else if(getMin() == value && hasMin()){
			bo = true;
		}
		else if(getMax() == value && hasMax()){
			bo = true;
		}
		else if(value == 0.0 && (getMin() == -0.0 || getMax() == -0.0)){
			bo = true;
		}
		else{
			bo = false;
		}
		return bo;
	}
	
/**
* Range򥳥ԡޤ
* @param copy ԡRange
*/
	public void rangeCopy(Range copy){
		if(copy.isEmpty()){
			setMax(EMPTY_MAX);
			setMin(EMPTY_MIN);
			setEmpty(true);
			setHasMax(true);
			setHasMin(true);
		}
		else{
			setMax(copy.getMax());
			setMin(copy.getMin());
			setEmpty(copy.isEmpty());
			setHasMax(copy.hasMax());
			setHasMin(copy.hasMin());
		}
	}
	
/**
* Range ƱΤ(AND)֤ޤ<BR>
* 2Ĥ Range νŤʤäƤ֤֤ޤ
* ֤Ťʤʤ⤷ϡ줫Ǥ¸ߤ֤ʤǤϡ¸ߤ֤ʤפ֤ޤ
* @param ran Ӥ򤹤 Range
* @return ANDä Range
*/
	public Range getAndRange(Range ran){
		double max;
		double min;
		boolean inMax;
		boolean inMin;
		
		//ΤȤ
		if(isEmpty() || ran.isEmpty()){
			return new Range();
		}
		
		//
		if(getMax() > ran.getMax()){
			max = ran.getMax();
			inMax = ran.hasMax();
		}
		else if(getMax() < ran.getMax()){
			max = getMax();
			inMax = hasMax();
		}
		else if(hasMax() && ran.hasMax()){
			max = getMax();
			inMax = hasMax();
		}
		else{
			max = getMax();
			inMax = false;
		}
		
		//Ǿ
		if(getMin() < ran.getMin()){
			min = ran.getMin();
			inMin = ran.hasMin();
		}
		else if(getMin() > ran.getMin()){
			min = getMin();
			inMin = hasMin();
		}
		else if(hasMin() && ran.hasMin()){
			min = getMin();
			inMin = hasMin();
		}
		else{
			min = getMin();
			inMin = false;
		}
		
		//
		if(max > min){
			return new Range(min, max, inMin, inMax);
		}
		else if(max == min){
			return new Range(min, max, true, true);
		}
		return new Range();
	}
	
/**
* ͤꤷޤ
* @param max ꤹ
*/
	private void setMax(double max){
		maxValue = max;
	}
	
/**
* Ǿͤꤷޤ
* @param min ꤹǾ
*/
	private void setMin(double min){
		minValue = min;
	}
	
/**
* ¸ߤ֤ʤͤꤷޤ
* @param emp ¸ߤ֤ʤʤ true
*/
	private void setEmpty(boolean emp){
		empty = emp;
	}
	
/**
* ͤ϶֤˴ޤफꤷޤ
* @param isInclude ֤˴ޤ true
*/
	private void setHasMax(boolean isInclude){
		includeMax = isInclude;
	}
	
/**
* Ǿͤ϶֤˴ޤफꤷޤ
* @param isInclude ֤˴ޤ true
*/
	private void setHasMin(boolean isInclude){
		includeMin = isInclude;
	}
	
/**
* Range¸ߤ֤ʤꤷޤ
*/
	private void createEmpty(){
		setMax(EMPTY_MAX);
		setMin(EMPTY_MIN);
		setEmpty(true);
		setHasMax(true);
		setHasMin(true);
	}
	
/**
* ǾͤȺͤϰϤäƤ뤫åޤ
* @param min Ǿ
* @param max 
* @return ֤¸ߤ true
*/
	private boolean isExistRange(double min, double max){
		return (min <= max);
	}
	
}