/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors.rule;

import jp.sourceforge.ecurlipse.editor.CurlEditorPlugin;
import jp.sourceforge.ecurlipse.editor.editors.CurlWhitespaceDetector;
import jp.sourceforge.ecurlipse.editor.editors.rule.RuleUtil;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.Assert;

public class CurlReserveWordRule
implements IRule {
    private IToken fToken;

    public CurlReserveWordRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        CurlWhitespaceDetector detector = new CurlWhitespaceDetector();
        StringBuffer sb = new StringBuffer();
        char c = (char)scanner.read();
        if (RuleUtil.isAlphabet(c) || c == '_') {
            scanner.unread();
            scanner.unread();
            c = (char)scanner.read();
            if (!detector.isWhitespace(c) && c != '=' && c != ',' && c != '{' && c != ':') {
                return Token.UNDEFINED;
            }
            c = (char)scanner.read();
            while (RuleUtil.isCurlWordChar(c)) {
                sb.append(c);
                c = (char)scanner.read();
            }
            if (CurlEditorPlugin.getReserveWordSet().contains(sb.toString())) {
                if (detector.isWhitespace(c) || c == ',' || c == '}' || c == '.' || c == ')') {
                    if (c == ',' || c == '}' || c == '.' || c == ')') {
                        scanner.unread();
                    }
                    return this.fToken;
                }
                scanner.unread();
                return Token.UNDEFINED;
            }
            int i = 0;
            while (i < sb.length() + 1) {
                scanner.unread();
                ++i;
            }
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

