/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors.rule;

import java.util.HashSet;
import jp.sourceforge.ecurlipse.editor.editors.CurlWhitespaceDetector;
import jp.sourceforge.ecurlipse.editor.editors.rule.RuleUtil;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CurlDistanceRule
implements IRule {
    private static final int UNDEFINED = -1;
    private IToken fToken;
    private int fColumn = -1;
    private HashSet distanceSet;

    public CurlDistanceRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char c = (char)scanner.read();
        CurlWhitespaceDetector detector = new CurlWhitespaceDetector();
        if (Character.isDigit(c) || c == '-') {
            scanner.unread();
            scanner.unread();
            c = (char)scanner.read();
            if (!detector.isWhitespace(c) && c != '=' && c != ',') {
                return Token.UNDEFINED;
            }
            this.fColumn = scanner.getColumn();
            while (Character.isDigit(c = (char)scanner.read()) || c == '.') {
            }
            if (detector.isWhitespace(c) || c == ',' || c == '}' || c == ')') {
                scanner.unread();
                return this.fToken;
            }
            if (RuleUtil.isAlphabet(c)) {
                StringBuffer sb = new StringBuffer();
                sb.append(c);
                do {
                    if (this.getDistanceSet().contains(sb.toString())) {
                        c = (char)scanner.read();
                        if (detector.isWhitespace(c) || c == ',' || c == '}') {
                            scanner.unread();
                            return this.fToken;
                        }
                        scanner.unread();
                        return Token.UNDEFINED;
                    }
                    c = (char)scanner.read();
                    sb.append(c);
                } while (RuleUtil.isAlphabet(c));
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public HashSet getDistanceSet() {
        if (this.distanceSet == null) {
            this.distanceSet = new HashSet();
            this.distanceSet.add("cm");
            this.distanceSet.add("km");
            this.distanceSet.add("px");
            this.distanceSet.add("pixel");
            this.distanceSet.add("pt");
            this.distanceSet.add("point");
            this.distanceSet.add("%");
        }
        return this.distanceSet;
    }
}

