/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import jp.sourceforge.ecurlipse.editor.CurlEditorPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CurlContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Set proposalWordSet = CurlEditorPlugin.getProposalWordSet();
        String[] proposals = new String[proposalWordSet.size()];
        int i = 0;
        Iterator iterator = proposalWordSet.iterator();
        while (iterator.hasNext()) {
            proposals[i] = iterator.next().toString();
            ++i;
        }
        String word = this.getWord(viewer, documentOffset);
        ArrayList<String> proposalList = new ArrayList<String>();
        int j = 0;
        while (j < proposals.length) {
            if (proposals[j].toLowerCase().startsWith(word.toLowerCase())) {
                proposalList.add(proposals[j]);
            }
            ++j;
        }
        ICompletionProposal[] result = new ICompletionProposal[proposalList.size()];
        int replacementOffset = documentOffset - word.length();
        int replacementLength = word.length();
        int index = 0;
        Iterator iterator2 = proposalList.iterator();
        while (iterator2.hasNext()) {
            String keyWord = (String)iterator2.next();
            result[index] = new CompletionProposal(keyWord, replacementOffset, replacementLength, keyWord.length());
            ++index;
        }
        proposalList.clear();
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'{'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private String getWord(ITextViewer viewer, int documentOffset) {
        String word = "";
        int docOffset = documentOffset - 1;
        try {
            while (docOffset >= viewer.getTopIndexStartOffset() && Character.isLetterOrDigit(viewer.getDocument().getChar(docOffset))) {
                --docOffset;
            }
            word = viewer.getDocument().get(++docOffset, documentOffset - docOffset);
        }
        catch (BadLocationException badLocationException) {}
        return word;
    }
}

