/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.ecurlipse.editor.CurlEditorPlugin;
import jp.sourceforge.ecurlipse.editor.editors.def.CurlColor;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CurlColorManager {
    private static final int RADIX = 16;
    private static final int RED_START = 1;
    private static final int RED_END = 3;
    private static final int GREEN_START = 3;
    private static final int GREEN_END = 5;
    private static final int BLUE_START = 3;
    private static final int BLUE_END = 5;
    private Map fColorTable = new HashMap();
    private final IPreferenceStore preferenceStore;
    private static Logger log;
    private static Map colorMap;
    private Map tokenMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ecurlipse.editor.editors.CurlColorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        colorMap = new HashMap();
        colorMap.put("aqua", CurlColor.AQUA);
        colorMap.put("beige", CurlColor.BEIGE);
        colorMap.put("black", CurlColor.BLACK);
        colorMap.put("blue", CurlColor.BLUE);
        colorMap.put("brown", CurlColor.BROWN);
        colorMap.put("cyan", CurlColor.CYAN);
        colorMap.put("fuchsia", CurlColor.FUCHSIA);
        colorMap.put("gray", CurlColor.GRAY);
        colorMap.put("green", CurlColor.GREEN);
        colorMap.put("lime", CurlColor.LIME);
        colorMap.put("magenta", CurlColor.MAGENTA);
        colorMap.put("maroon", CurlColor.MAROON);
        colorMap.put("navy", CurlColor.NAVY);
        colorMap.put("olive", CurlColor.OLIVE);
        colorMap.put("orange", CurlColor.ORANGE);
        colorMap.put("pink", CurlColor.PINK);
        colorMap.put("purple", CurlColor.PURPLE);
        colorMap.put("red", CurlColor.RED);
        colorMap.put("silver", CurlColor.SILVER);
        colorMap.put("teal", CurlColor.TEAL);
        colorMap.put("wheat", CurlColor.WHEAT);
        colorMap.put("white", CurlColor.WHITE);
        colorMap.put("yellow", CurlColor.YELLOW);
    }

    public CurlColorManager() {
        this.preferenceStore = CurlEditorPlugin.getDefault().getPreferenceStore();
    }

    public static Map getColorMap() {
        return colorMap;
    }

    public static Color getColorByName(String name) {
        return (Color)CurlColorManager.getColorMap().get(name);
    }

    public static Color getColorByCode(String code) {
        int r = Integer.parseInt(code.substring(1, 3), 16);
        int g = Integer.parseInt(code.substring(3, 5), 16);
        int b = Integer.parseInt(code.substring(3, 5), 16);
        Color color = new Color((Device)Display.getCurrent(), r, g, b);
        return color;
    }

    public static Color getColor(String color) {
        Color result = null;
        if (CurlColorManager.getColorMap().containsKey(color)) {
            result = (Color)CurlColorManager.getColorMap().get(color);
        } else if (color.charAt(0) == '#' && color.length() == 7) {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(3, 5), 16);
            result = new Color((Device)Display.getCurrent(), r, g, b);
        }
        return result;
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator iterator = this.fColorTable.values().iterator();
        while (iterator.hasNext()) {
            ((Color)iterator.next()).dispose();
        }
    }

    public IToken getToken(String prefKey) {
        log.debug((Object)("prefKey=" + prefKey));
        Token token = (Token)this.tokenMap.get(prefKey);
        if (token == null) {
            String colorName = this.preferenceStore.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token = new Token((Object)new TextAttribute(this.getColor(rgb)));
            this.tokenMap.put(prefKey, token);
        }
        return token;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        Token token = (Token)this.tokenMap.get(prefKey);
        if (token != null) {
            String colorName = this.preferenceStore.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token.setData((Object)new TextAttribute(this.getColor(rgb)));
        }
    }
}

